/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.buffer;

import io.aeron.driver.buffer.RawLog;
import io.aeron.exceptions.AeronException;
import io.aeron.logbuffer.LogBufferDescriptor;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import org.agrona.BitUtil;
import org.agrona.BufferUtil;
import org.agrona.ErrorHandler;
import org.agrona.IoUtil;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.AtomicCounter;

class MappedRawLog
implements RawLog {
    private static final int ONE_GIG = 0x40000000;
    private static final EnumSet<StandardOpenOption> FILE_OPTIONS = EnumSet.of(StandardOpenOption.CREATE_NEW, StandardOpenOption.READ, StandardOpenOption.WRITE);
    private static final EnumSet<StandardOpenOption> SPARSE_FILE_OPTIONS = EnumSet.of(StandardOpenOption.CREATE_NEW, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.SPARSE);
    private final int termLength;
    private final long logLength;
    private final UnsafeBuffer[] termBuffers = new UnsafeBuffer[3];
    private final UnsafeBuffer logMetaDataBuffer;
    private final ErrorHandler errorHandler;
    private final AtomicCounter mappedBytesCounter;
    private File logFile;
    private MappedByteBuffer[] mappedBuffers;

    MappedRawLog(File location, boolean useSparseFiles, long logLength, int termLength, int filePageSize, ErrorHandler errorHandler, AtomicCounter mappedBytesCounter) {
        this.termLength = termLength;
        this.errorHandler = errorHandler;
        this.logFile = location;
        this.logLength = logLength;
        this.mappedBytesCounter = mappedBytesCounter;
        EnumSet<StandardOpenOption> options = useSparseFiles ? SPARSE_FILE_OPTIONS : FILE_OPTIONS;
        try (FileChannel logChannel = FileChannel.open(this.logFile.toPath(), options, new FileAttribute[0]);){
            logChannel.truncate(logLength);
            if (logLength <= Integer.MAX_VALUE) {
                MappedByteBuffer mappedBuffer = logChannel.map(FileChannel.MapMode.READ_WRITE, 0L, logLength);
                mappedBuffer.order(ByteOrder.LITTLE_ENDIAN);
                this.mappedBuffers = new MappedByteBuffer[]{mappedBuffer};
                for (int i = 0; i < 3; ++i) {
                    this.termBuffers[i] = new UnsafeBuffer(mappedBuffer, i * termLength, termLength);
                }
                this.logMetaDataBuffer = new UnsafeBuffer(mappedBuffer, (int)(logLength - (long)LogBufferDescriptor.LOG_META_DATA_LENGTH), LogBufferDescriptor.LOG_META_DATA_LENGTH);
            } else {
                this.mappedBuffers = new MappedByteBuffer[4];
                for (int i = 0; i < 3; ++i) {
                    MappedByteBuffer buffer = logChannel.map(FileChannel.MapMode.READ_WRITE, (long)termLength * (long)i, termLength);
                    buffer.order(ByteOrder.LITTLE_ENDIAN);
                    this.mappedBuffers[i] = buffer;
                    this.termBuffers[i] = new UnsafeBuffer(buffer, 0, termLength);
                }
                int metaDataMappingLength = BitUtil.align(LogBufferDescriptor.LOG_META_DATA_LENGTH, filePageSize);
                long metaDataSectionOffset = (long)termLength * 3L;
                MappedByteBuffer metaDataMappedBuffer = logChannel.map(FileChannel.MapMode.READ_WRITE, metaDataSectionOffset, metaDataMappingLength);
                metaDataMappedBuffer.order(ByteOrder.LITTLE_ENDIAN);
                this.mappedBuffers[3] = metaDataMappedBuffer;
                this.logMetaDataBuffer = new UnsafeBuffer(metaDataMappedBuffer, metaDataMappingLength - LogBufferDescriptor.LOG_META_DATA_LENGTH, LogBufferDescriptor.LOG_META_DATA_LENGTH);
            }
            if (!useSparseFiles) {
                MappedRawLog.preTouchPages(this.termBuffers, termLength, filePageSize);
            }
            mappedBytesCounter.getAndAddOrdered(logLength);
        }
        catch (IOException ex) {
            IoUtil.delete(this.logFile, true);
            throw new UncheckedIOException(ex);
        }
    }

    @Override
    public int termLength() {
        return this.termLength;
    }

    @Override
    public boolean free() {
        MappedByteBuffer[] mappedBuffers = this.mappedBuffers;
        if (null != mappedBuffers) {
            int i;
            this.mappedBuffers = null;
            for (i = 0; i < mappedBuffers.length; ++i) {
                BufferUtil.free(mappedBuffers[i]);
            }
            this.mappedBytesCounter.getAndAddOrdered(-this.logLength);
            this.logMetaDataBuffer.wrap(0L, 0);
            for (i = 0; i < this.termBuffers.length; ++i) {
                this.termBuffers[i].wrap(0L, 0);
            }
        }
        if (null != this.logFile) {
            if (!this.logFile.delete() && this.logFile.exists()) {
                return false;
            }
            this.logFile = null;
        }
        return true;
    }

    @Override
    public void close() {
        if (!this.free()) {
            this.errorHandler.onError(new AeronException("unable to delete " + this.logFile, AeronException.Category.WARN));
        }
    }

    @Override
    public UnsafeBuffer[] termBuffers() {
        return this.termBuffers;
    }

    @Override
    public UnsafeBuffer metaData() {
        return this.logMetaDataBuffer;
    }

    @Override
    public ByteBuffer[] sliceTerms() {
        ByteBuffer[] terms = new ByteBuffer[3];
        if (this.termLength < 0x40000000) {
            MappedByteBuffer buffer = this.mappedBuffers[0];
            for (int i = 0; i < 3; ++i) {
                buffer.limit(this.termLength * i + this.termLength).position(this.termLength * i);
                terms[i] = buffer.slice();
            }
        } else {
            for (int i = 0; i < 3; ++i) {
                terms[i] = this.mappedBuffers[i].duplicate();
            }
        }
        return terms;
    }

    @Override
    public String fileName() {
        return this.logFile.getAbsolutePath();
    }

    private static void preTouchPages(UnsafeBuffer[] buffers, int length, int pageSize) {
        for (UnsafeBuffer buffer : buffers) {
            for (long i = 0L; i < (long)length; i += (long)pageSize) {
                buffer.putByte((int)i, (byte)0);
            }
        }
    }
}

