/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.AeronClient;
import io.aeron.driver.PublicationImage;
import io.aeron.driver.SubscriptionLink;
import io.aeron.driver.SubscriptionParams;
import io.aeron.driver.media.ReceiveChannelEndpoint;

class NetworkSubscriptionLink
extends SubscriptionLink {
    private final boolean isReliable;
    private final boolean isRejoin;
    private final ReceiveChannelEndpoint channelEndpoint;
    private final boolean isResponse;

    NetworkSubscriptionLink(long registrationId, ReceiveChannelEndpoint channelEndpoint, int streamId, String channelUri, AeronClient aeronClient, SubscriptionParams params) {
        super(registrationId, streamId, channelUri, aeronClient, params);
        this.isReliable = params.isReliable;
        this.isRejoin = params.isRejoin;
        this.isResponse = params.isResponse;
        this.channelEndpoint = channelEndpoint;
    }

    @Override
    boolean isReliable() {
        return this.isReliable;
    }

    @Override
    boolean isRejoin() {
        return this.isRejoin;
    }

    @Override
    boolean isResponse() {
        return this.isResponse;
    }

    @Override
    ReceiveChannelEndpoint channelEndpoint() {
        return this.channelEndpoint;
    }

    @Override
    boolean matches(PublicationImage image) {
        return image.channelEndpoint() == this.channelEndpoint && image.streamId() == this.streamId && this.isWildcardOrSessionIdMatch(image.sessionId());
    }

    @Override
    boolean matches(ReceiveChannelEndpoint channelEndpoint, int streamId, SubscriptionParams params) {
        boolean isExactWildcardOrSessionIdMatch = this.hasSessionId == params.hasSessionId && (!this.hasSessionId || this.sessionId == params.sessionId);
        return channelEndpoint == this.channelEndpoint && streamId == this.streamId && isExactWildcardOrSessionIdMatch;
    }

    @Override
    boolean matches(ReceiveChannelEndpoint channelEndpoint, int streamId, int sessionId) {
        return channelEndpoint == this.channelEndpoint && streamId == this.streamId && this.isWildcardOrSessionIdMatch(sessionId);
    }

    @Override
    boolean supportsMds() {
        return this.channelEndpoint.hasDestinationControl();
    }
}

