/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.codecs.node;

import io.aeron.cluster.codecs.node.MessageHeaderDecoder;
import java.nio.ByteOrder;
import org.agrona.MutableDirectBuffer;

public final class MessageHeaderEncoder {
    public static final int SCHEMA_ID = 112;
    public static final int SCHEMA_VERSION = 10;
    public static final String SEMANTIC_VERSION = "5.3";
    public static final int ENCODED_LENGTH = 16;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private int offset;
    private MutableDirectBuffer buffer;

    public MessageHeaderEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        return this;
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public int encodedLength() {
        return 16;
    }

    public int sbeSchemaId() {
        return 112;
    }

    public int sbeSchemaVersion() {
        return 10;
    }

    public static int blockLengthEncodingOffset() {
        return 0;
    }

    public static int blockLengthEncodingLength() {
        return 2;
    }

    public static int blockLengthNullValue() {
        return 65535;
    }

    public static int blockLengthMinValue() {
        return 0;
    }

    public static int blockLengthMaxValue() {
        return 65534;
    }

    public MessageHeaderEncoder blockLength(int value) {
        this.buffer.putShort(this.offset + 0, (short)value, BYTE_ORDER);
        return this;
    }

    public static int templateIdEncodingOffset() {
        return 2;
    }

    public static int templateIdEncodingLength() {
        return 2;
    }

    public static int templateIdNullValue() {
        return 65535;
    }

    public static int templateIdMinValue() {
        return 0;
    }

    public static int templateIdMaxValue() {
        return 65534;
    }

    public MessageHeaderEncoder templateId(int value) {
        this.buffer.putShort(this.offset + 2, (short)value, BYTE_ORDER);
        return this;
    }

    public static int schemaIdEncodingOffset() {
        return 4;
    }

    public static int schemaIdEncodingLength() {
        return 2;
    }

    public static int schemaIdNullValue() {
        return 65535;
    }

    public static int schemaIdMinValue() {
        return 0;
    }

    public static int schemaIdMaxValue() {
        return 65534;
    }

    public MessageHeaderEncoder schemaId(int value) {
        this.buffer.putShort(this.offset + 4, (short)value, BYTE_ORDER);
        return this;
    }

    public static int versionEncodingOffset() {
        return 6;
    }

    public static int versionEncodingLength() {
        return 2;
    }

    public static int versionNullValue() {
        return 65535;
    }

    public static int versionMinValue() {
        return 0;
    }

    public static int versionMaxValue() {
        return 65534;
    }

    public MessageHeaderEncoder version(int value) {
        this.buffer.putShort(this.offset + 6, (short)value, BYTE_ORDER);
        return this;
    }

    public static int frameLengthEncodingOffset() {
        return 8;
    }

    public static int frameLengthEncodingLength() {
        return 4;
    }

    public static int frameLengthNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int frameLengthMinValue() {
        return -2147483647;
    }

    public static int frameLengthMaxValue() {
        return Integer.MAX_VALUE;
    }

    public MessageHeaderEncoder frameLength(int value) {
        this.buffer.putInt(this.offset + 8, value, BYTE_ORDER);
        return this;
    }

    public static int paddingEncodingOffset() {
        return 12;
    }

    public static int paddingEncodingLength() {
        return 4;
    }

    public static int paddingNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int paddingMinValue() {
        return -2147483647;
    }

    public static int paddingMaxValue() {
        return Integer.MAX_VALUE;
    }

    public MessageHeaderEncoder padding(int value) {
        this.buffer.putInt(this.offset + 12, value, BYTE_ORDER);
        return this;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        MessageHeaderDecoder decoder = new MessageHeaderDecoder();
        decoder.wrap(this.buffer, this.offset);
        return decoder.appendTo(builder);
    }
}

