/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.cluster.client.ClusterException;
import java.util.ArrayDeque;

final class ServiceAck {
    private final long ackId;
    private final long logPosition;
    private final long relevantId;

    ServiceAck(long ackId, long logPosition, long relevantId) {
        this.logPosition = logPosition;
        this.ackId = ackId;
        this.relevantId = relevantId;
    }

    long ackId() {
        return this.ackId;
    }

    long logPosition() {
        return this.logPosition;
    }

    long relevantId() {
        return this.relevantId;
    }

    static boolean hasReached(long logPosition, long ackId, ArrayDeque<ServiceAck>[] queues) {
        for (ArrayDeque<ServiceAck> serviceAckQueue : queues) {
            ServiceAck serviceAck = serviceAckQueue.peek();
            if (null == serviceAck) {
                return false;
            }
            if (serviceAck.ackId != ackId) {
                throw new ClusterException("ack out of sequence, expected=" + ackId + "/" + logPosition + " received=" + serviceAck);
            }
            if (serviceAck.logPosition == logPosition) continue;
            throw new ClusterException("logPosition out of sequence, expected=" + ackId + "/" + logPosition + " received=" + serviceAck);
        }
        return true;
    }

    static void removeHead(ArrayDeque<ServiceAck>[] queues) {
        for (ArrayDeque<ServiceAck> queue : queues) {
            queue.pollFirst();
        }
    }

    static ArrayDeque<ServiceAck>[] newArrayOfQueues(int serviceCount) {
        ArrayDeque[] queues = new ArrayDeque[serviceCount];
        for (int i = 0; i < serviceCount; ++i) {
            queues[i] = new ArrayDeque();
        }
        return queues;
    }

    public String toString() {
        return "ServiceAck{ackId=" + this.ackId + ", logPosition=" + this.logPosition + ", relevantId=" + this.relevantId + '}';
    }
}

