/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.Image;
import io.aeron.ImageControlledFragmentAssembler;
import io.aeron.cluster.ConsensusModuleSnapshotListener;
import io.aeron.cluster.client.ClusterException;
import io.aeron.cluster.codecs.ClusterMembersDecoder;
import io.aeron.cluster.codecs.ClusterSessionDecoder;
import io.aeron.cluster.codecs.ConsensusModuleDecoder;
import io.aeron.cluster.codecs.MessageHeaderDecoder;
import io.aeron.cluster.codecs.PendingMessageTrackerDecoder;
import io.aeron.cluster.codecs.SessionMessageHeaderDecoder;
import io.aeron.cluster.codecs.SnapshotMarkerDecoder;
import io.aeron.cluster.codecs.TimerDecoder;
import io.aeron.cluster.service.ClusterClock;
import io.aeron.logbuffer.ControlledFragmentHandler;
import io.aeron.logbuffer.Header;
import org.agrona.DirectBuffer;

class ConsensusModuleSnapshotAdapter
implements ControlledFragmentHandler {
    static final int FRAGMENT_LIMIT = 10;
    private boolean inSnapshot = false;
    private boolean isDone = false;
    private final MessageHeaderDecoder messageHeaderDecoder = new MessageHeaderDecoder();
    private final SnapshotMarkerDecoder snapshotMarkerDecoder = new SnapshotMarkerDecoder();
    private final ClusterSessionDecoder clusterSessionDecoder = new ClusterSessionDecoder();
    private final SessionMessageHeaderDecoder sessionMessageHeaderDecoder = new SessionMessageHeaderDecoder();
    private final TimerDecoder timerDecoder = new TimerDecoder();
    private final ConsensusModuleDecoder consensusModuleDecoder = new ConsensusModuleDecoder();
    private final ClusterMembersDecoder clusterMembersDecoder = new ClusterMembersDecoder();
    private final PendingMessageTrackerDecoder pendingMessageTrackerDecoder = new PendingMessageTrackerDecoder();
    private final ImageControlledFragmentAssembler fragmentAssembler = new ImageControlledFragmentAssembler(this);
    private final Image image;
    private final ConsensusModuleSnapshotListener listener;

    ConsensusModuleSnapshotAdapter(Image image, ConsensusModuleSnapshotListener listener) {
        this.image = image;
        this.listener = listener;
    }

    boolean isDone() {
        return this.isDone;
    }

    int poll() {
        return this.image.controlledPoll(this.fragmentAssembler, 10);
    }

    @Override
    public ControlledFragmentHandler.Action onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        this.messageHeaderDecoder.wrap(buffer, offset);
        int schemaId = this.messageHeaderDecoder.schemaId();
        if (schemaId != 111) {
            throw new ClusterException("expected schemaId=111, actual=" + schemaId);
        }
        switch (this.messageHeaderDecoder.templateId()) {
            case 1: {
                this.sessionMessageHeaderDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.listener.onLoadPendingMessage(this.sessionMessageHeaderDecoder.clusterSessionId(), buffer, offset, length);
                break;
            }
            case 100: {
                this.snapshotMarkerDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                long typeId = this.snapshotMarkerDecoder.typeId();
                if (typeId != 1L) {
                    throw new ClusterException("unexpected snapshot type: " + typeId);
                }
                switch (this.snapshotMarkerDecoder.mark()) {
                    case BEGIN: {
                        if (this.inSnapshot) {
                            throw new ClusterException("already in snapshot");
                        }
                        this.inSnapshot = true;
                        this.listener.onLoadBeginSnapshot(this.snapshotMarkerDecoder.appVersion(), ClusterClock.map(this.snapshotMarkerDecoder.timeUnit()), buffer, offset, length);
                        return ControlledFragmentHandler.Action.CONTINUE;
                    }
                    case END: {
                        if (!this.inSnapshot) {
                            throw new ClusterException("missing begin snapshot");
                        }
                        this.listener.onLoadEndSnapshot(buffer, offset, length);
                        this.isDone = true;
                        return ControlledFragmentHandler.Action.BREAK;
                    }
                }
                break;
            }
            case 103: {
                this.clusterSessionDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.listener.onLoadClusterSession(this.clusterSessionDecoder.clusterSessionId(), this.clusterSessionDecoder.correlationId(), this.clusterSessionDecoder.openedLogPosition(), this.clusterSessionDecoder.timeOfLastActivity(), this.clusterSessionDecoder.closeReason(), this.clusterSessionDecoder.responseStreamId(), this.clusterSessionDecoder.responseChannel(), buffer, offset, length);
                break;
            }
            case 104: {
                this.timerDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.listener.onLoadTimer(this.timerDecoder.correlationId(), this.timerDecoder.deadline(), buffer, offset, length);
                break;
            }
            case 105: {
                this.consensusModuleDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.listener.onLoadConsensusModuleState(this.consensusModuleDecoder.nextSessionId(), this.consensusModuleDecoder.nextServiceSessionId(), this.consensusModuleDecoder.logServiceSessionId(), this.consensusModuleDecoder.pendingMessageCapacity(), buffer, offset, length);
                break;
            }
            case 106: {
                break;
            }
            case 107: {
                this.pendingMessageTrackerDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.listener.onLoadPendingMessageTracker(this.pendingMessageTrackerDecoder.nextServiceSessionId(), this.pendingMessageTrackerDecoder.logServiceSessionId(), this.pendingMessageTrackerDecoder.pendingMessageCapacity(), this.pendingMessageTrackerDecoder.serviceId(), buffer, offset, length);
            }
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }
}

