/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.CommonContext;
import io.aeron.archive.Archive;
import io.aeron.cluster.ConsensusModule;
import org.agrona.CloseHelper;
import org.agrona.SystemUtil;

public class ClusteredArchive
implements AutoCloseable {
    private final Archive archive;
    private final ConsensusModule consensusModule;

    ClusteredArchive(Archive archive, ConsensusModule consensusModule) {
        this.archive = archive;
        this.consensusModule = consensusModule;
    }

    public static void main(String[] args) {
        SystemUtil.loadPropertiesFiles(args);
        try (ClusteredArchive driver = ClusteredArchive.launch();){
            driver.consensusModule().context().shutdownSignalBarrier().await();
            System.out.println("Shutdown ClusteredArchive...");
        }
    }

    public static ClusteredArchive launch() {
        return ClusteredArchive.launch(CommonContext.getAeronDirectoryName(), new Archive.Context(), new ConsensusModule.Context());
    }

    public static ClusteredArchive launch(String aeronDirectoryName, Archive.Context archiveCtx, ConsensusModule.Context consensusModuleCtx) {
        Archive archive = null;
        ConsensusModule consensusModule = null;
        try {
            archive = Archive.launch(archiveCtx.aeronDirectoryName(aeronDirectoryName));
            consensusModule = ConsensusModule.launch(consensusModuleCtx.aeronDirectoryName(aeronDirectoryName));
            return new ClusteredArchive(archive, consensusModule);
        }
        catch (Exception ex) {
            CloseHelper.quietCloseAll(consensusModule, archive);
            throw ex;
        }
    }

    public Archive archive() {
        return this.archive;
    }

    public ConsensusModule consensusModule() {
        return this.consensusModule;
    }

    @Override
    public void close() {
        CloseHelper.closeAll(this.consensusModule, this.archive);
    }
}

