/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive.client;

public class ReplayParams {
    private int boundingLimitCounterId;
    private int fileIoMaxLength;
    private long position;
    private long length;

    public ReplayParams() {
        this.reset();
    }

    public ReplayParams reset() {
        this.boundingLimitCounterId = -1;
        this.fileIoMaxLength = -1;
        this.position = -1L;
        this.length = -1L;
        return this;
    }

    public ReplayParams position(long position) {
        this.position = position;
        return this;
    }

    public long position() {
        return this.position;
    }

    public ReplayParams length(long length) {
        this.length = length;
        return this;
    }

    public long length() {
        return this.length;
    }

    public ReplayParams boundingLimitCounterId(int boundingLimitCounterId) {
        this.boundingLimitCounterId = boundingLimitCounterId;
        return this;
    }

    public int boundingLimitCounterId() {
        return this.boundingLimitCounterId;
    }

    public ReplayParams fileIoMaxLength(int fileIoMaxLength) {
        this.fileIoMaxLength = fileIoMaxLength;
        return this;
    }

    public int fileIoMaxLength() {
        return this.fileIoMaxLength;
    }

    public boolean isBounded() {
        return -1 != this.boundingLimitCounterId;
    }
}

