/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.ClientConductor;
import io.aeron.DirectBufferVector;
import io.aeron.LogBuffers;
import io.aeron.Publication;
import io.aeron.ReservedValueSupplier;
import io.aeron.logbuffer.BufferClaim;
import io.aeron.logbuffer.FrameDescriptor;
import io.aeron.logbuffer.LogBufferDescriptor;
import java.nio.ByteOrder;
import org.agrona.BitUtil;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.ReadablePosition;

public final class ConcurrentPublication
extends Publication {
    ConcurrentPublication(ClientConductor clientConductor, String channel, int streamId, int sessionId, ReadablePosition positionLimit, int channelStatusId, LogBuffers logBuffers, long originalRegistrationId, long registrationId) {
        super(clientConductor, channel, streamId, sessionId, positionLimit, channelStatusId, logBuffers, originalRegistrationId, registrationId);
    }

    @Override
    public long availableWindow() {
        if (this.isClosed) {
            return -4L;
        }
        return this.positionLimit.getVolatile() - this.position();
    }

    @Override
    public long offer(DirectBuffer buffer, int offset, int length, ReservedValueSupplier reservedValueSupplier) {
        long newPosition = -4L;
        if (!this.isClosed) {
            long limit = this.positionLimit.getVolatile();
            int termCount = LogBufferDescriptor.activeTermCount(this.logMetaDataBuffer);
            int index = LogBufferDescriptor.indexByTermCount(termCount);
            UnsafeBuffer termBuffer = this.termBuffers[index];
            int tailCounterOffset = LogBufferDescriptor.TERM_TAIL_COUNTERS_OFFSET + index * 8;
            long rawTail = this.logMetaDataBuffer.getLongVolatile(tailCounterOffset);
            int termOffset = LogBufferDescriptor.termOffset(rawTail, termBuffer.capacity());
            int termId = LogBufferDescriptor.termId(rawTail);
            if (termCount != termId - this.initialTermId) {
                return -3L;
            }
            long position = LogBufferDescriptor.computePosition(termId, termOffset, this.positionBitsToShift, this.initialTermId);
            if (position < limit) {
                if (length <= this.maxPayloadLength) {
                    this.checkPositiveLength(length);
                    newPosition = this.appendUnfragmentedMessage(termBuffer, tailCounterOffset, buffer, offset, length, reservedValueSupplier);
                } else {
                    this.checkMaxMessageLength(length);
                    newPosition = this.appendFragmentedMessage(termBuffer, tailCounterOffset, buffer, offset, length, reservedValueSupplier);
                }
            } else {
                newPosition = this.backPressureStatus(position, length);
            }
        }
        return newPosition;
    }

    @Override
    public long offer(DirectBuffer bufferOne, int offsetOne, int lengthOne, DirectBuffer bufferTwo, int offsetTwo, int lengthTwo, ReservedValueSupplier reservedValueSupplier) {
        long newPosition = -4L;
        if (!this.isClosed) {
            long limit = this.positionLimit.getVolatile();
            int termCount = LogBufferDescriptor.activeTermCount(this.logMetaDataBuffer);
            int index = LogBufferDescriptor.indexByTermCount(termCount);
            UnsafeBuffer termBuffer = this.termBuffers[index];
            int tailCounterOffset = LogBufferDescriptor.TERM_TAIL_COUNTERS_OFFSET + index * 8;
            long rawTail = this.logMetaDataBuffer.getLongVolatile(tailCounterOffset);
            int termOffset = LogBufferDescriptor.termOffset(rawTail, termBuffer.capacity());
            int termId = LogBufferDescriptor.termId(rawTail);
            if (termCount != termId - this.initialTermId) {
                return -3L;
            }
            long position = LogBufferDescriptor.computePosition(termId, termOffset, this.positionBitsToShift, this.initialTermId);
            int length = ConcurrentPublication.validateAndComputeLength(lengthOne, lengthTwo);
            if (position < limit) {
                if (length <= this.maxPayloadLength) {
                    newPosition = this.appendUnfragmentedMessage(termBuffer, tailCounterOffset, bufferOne, offsetOne, lengthOne, bufferTwo, offsetTwo, lengthTwo, reservedValueSupplier);
                } else {
                    this.checkMaxMessageLength(length);
                    newPosition = this.appendFragmentedMessage(termBuffer, tailCounterOffset, bufferOne, offsetOne, lengthOne, bufferTwo, offsetTwo, lengthTwo, reservedValueSupplier);
                }
            } else {
                newPosition = this.backPressureStatus(position, length);
            }
        }
        return newPosition;
    }

    @Override
    public long offer(DirectBufferVector[] vectors, ReservedValueSupplier reservedValueSupplier) {
        int length = DirectBufferVector.validateAndComputeLength(vectors);
        long newPosition = -4L;
        if (!this.isClosed) {
            long limit = this.positionLimit.getVolatile();
            int termCount = LogBufferDescriptor.activeTermCount(this.logMetaDataBuffer);
            int index = LogBufferDescriptor.indexByTermCount(termCount);
            UnsafeBuffer termBuffer = this.termBuffers[index];
            int tailCounterOffset = LogBufferDescriptor.TERM_TAIL_COUNTERS_OFFSET + index * 8;
            long rawTail = this.logMetaDataBuffer.getLongVolatile(tailCounterOffset);
            int termOffset = LogBufferDescriptor.termOffset(rawTail, termBuffer.capacity());
            int termId = LogBufferDescriptor.termId(rawTail);
            if (termCount != termId - this.initialTermId) {
                return -3L;
            }
            long position = LogBufferDescriptor.computePosition(termId, termOffset, this.positionBitsToShift, this.initialTermId);
            if (position < limit) {
                if (length <= this.maxPayloadLength) {
                    newPosition = this.appendUnfragmentedMessage(termBuffer, tailCounterOffset, vectors, length, reservedValueSupplier);
                } else {
                    this.checkMaxMessageLength(length);
                    newPosition = this.appendFragmentedMessage(termBuffer, tailCounterOffset, vectors, length, reservedValueSupplier);
                }
            } else {
                newPosition = this.backPressureStatus(position, length);
            }
        }
        return newPosition;
    }

    @Override
    public long tryClaim(int length, BufferClaim bufferClaim) {
        this.checkPayloadLength(length);
        long newPosition = -4L;
        if (!this.isClosed) {
            long limit = this.positionLimit.getVolatile();
            int termCount = LogBufferDescriptor.activeTermCount(this.logMetaDataBuffer);
            int index = LogBufferDescriptor.indexByTermCount(termCount);
            UnsafeBuffer termBuffer = this.termBuffers[index];
            int tailCounterOffset = LogBufferDescriptor.TERM_TAIL_COUNTERS_OFFSET + index * 8;
            long rawTail = this.logMetaDataBuffer.getLongVolatile(tailCounterOffset);
            int termOffset = LogBufferDescriptor.termOffset(rawTail, termBuffer.capacity());
            int termId = LogBufferDescriptor.termId(rawTail);
            if (termCount != termId - this.initialTermId) {
                return -3L;
            }
            long position = LogBufferDescriptor.computePosition(termId, termOffset, this.positionBitsToShift, this.initialTermId);
            newPosition = position < limit ? this.claim(termBuffer, tailCounterOffset, length, bufferClaim) : this.backPressureStatus(position, length);
        }
        return newPosition;
    }

    private long appendUnfragmentedMessage(UnsafeBuffer termBuffer, int tailCounterOffset, DirectBuffer buffer, int offset, int length, ReservedValueSupplier reservedValueSupplier) {
        int frameLength = length + 32;
        int alignedLength = BitUtil.align(frameLength, 32);
        int termLength = termBuffer.capacity();
        long rawTail = this.logMetaDataBuffer.getAndAddLong(tailCounterOffset, alignedLength);
        int termId = LogBufferDescriptor.termId(rawTail);
        int termOffset = LogBufferDescriptor.termOffset(rawTail, termLength);
        int resultingOffset = termOffset + alignedLength;
        long position = LogBufferDescriptor.computePosition(termId, resultingOffset, this.positionBitsToShift, this.initialTermId);
        if (resultingOffset > termLength) {
            return this.handleEndOfLog(termBuffer, termLength, termId, termOffset, position);
        }
        this.headerWriter.write(termBuffer, termOffset, frameLength, termId);
        termBuffer.putBytes(termOffset + 32, buffer, offset, length);
        if (null != reservedValueSupplier) {
            long reservedValue = reservedValueSupplier.get(termBuffer, termOffset, frameLength);
            termBuffer.putLong(termOffset + 24, reservedValue, ByteOrder.LITTLE_ENDIAN);
        }
        FrameDescriptor.frameLengthOrdered(termBuffer, termOffset, frameLength);
        return position;
    }

    private long appendFragmentedMessage(UnsafeBuffer termBuffer, int tailCounterOffset, DirectBuffer buffer, int offset, int length, ReservedValueSupplier reservedValueSupplier) {
        int bytesToWrite;
        int framedLength = LogBufferDescriptor.computeFragmentedFrameLength(length, this.maxPayloadLength);
        int termLength = termBuffer.capacity();
        long rawTail = this.logMetaDataBuffer.getAndAddLong(tailCounterOffset, framedLength);
        int termId = LogBufferDescriptor.termId(rawTail);
        int termOffset = LogBufferDescriptor.termOffset(rawTail, termLength);
        int resultingOffset = termOffset + framedLength;
        long position = LogBufferDescriptor.computePosition(termId, resultingOffset, this.positionBitsToShift, this.initialTermId);
        if (resultingOffset > termLength) {
            return this.handleEndOfLog(termBuffer, termLength, termId, termOffset, position);
        }
        int frameOffset = termOffset;
        byte flags = -128;
        int remaining = length;
        do {
            bytesToWrite = Math.min(remaining, this.maxPayloadLength);
            int frameLength = bytesToWrite + 32;
            int alignedLength = BitUtil.align(frameLength, 32);
            this.headerWriter.write(termBuffer, frameOffset, frameLength, termId);
            termBuffer.putBytes(frameOffset + 32, buffer, offset + (length - remaining), bytesToWrite);
            if (remaining <= this.maxPayloadLength) {
                flags = (byte)(flags | 0x40);
            }
            FrameDescriptor.frameFlags(termBuffer, frameOffset, flags);
            if (null != reservedValueSupplier) {
                long reservedValue = reservedValueSupplier.get(termBuffer, frameOffset, frameLength);
                termBuffer.putLong(frameOffset + 24, reservedValue, ByteOrder.LITTLE_ENDIAN);
            }
            FrameDescriptor.frameLengthOrdered(termBuffer, frameOffset, frameLength);
            flags = 0;
            frameOffset += alignedLength;
        } while ((remaining -= bytesToWrite) > 0);
        return position;
    }

    private long appendUnfragmentedMessage(UnsafeBuffer termBuffer, int tailCounterOffset, DirectBuffer bufferOne, int offsetOne, int lengthOne, DirectBuffer bufferTwo, int offsetTwo, int lengthTwo, ReservedValueSupplier reservedValueSupplier) {
        int frameLength = lengthOne + lengthTwo + 32;
        int alignedLength = BitUtil.align(frameLength, 32);
        int termLength = termBuffer.capacity();
        long rawTail = this.logMetaDataBuffer.getAndAddLong(tailCounterOffset, alignedLength);
        int termId = LogBufferDescriptor.termId(rawTail);
        int termOffset = LogBufferDescriptor.termOffset(rawTail, termLength);
        int resultingOffset = termOffset + alignedLength;
        long position = LogBufferDescriptor.computePosition(termId, resultingOffset, this.positionBitsToShift, this.initialTermId);
        if (resultingOffset > termLength) {
            return this.handleEndOfLog(termBuffer, termLength, termId, termOffset, position);
        }
        this.headerWriter.write(termBuffer, termOffset, frameLength, termId);
        termBuffer.putBytes(termOffset + 32, bufferOne, offsetOne, lengthOne);
        termBuffer.putBytes(termOffset + 32 + lengthOne, bufferTwo, offsetTwo, lengthTwo);
        if (null != reservedValueSupplier) {
            long reservedValue = reservedValueSupplier.get(termBuffer, termOffset, frameLength);
            termBuffer.putLong(termOffset + 24, reservedValue, ByteOrder.LITTLE_ENDIAN);
        }
        FrameDescriptor.frameLengthOrdered(termBuffer, termOffset, frameLength);
        return position;
    }

    private long appendFragmentedMessage(UnsafeBuffer termBuffer, int tailCounterOffset, DirectBuffer bufferOne, int offsetOne, int lengthOne, DirectBuffer bufferTwo, int offsetTwo, int lengthTwo, ReservedValueSupplier reservedValueSupplier) {
        int bytesToWrite;
        int length = lengthOne + lengthTwo;
        int framedLength = LogBufferDescriptor.computeFragmentedFrameLength(length, this.maxPayloadLength);
        int termLength = termBuffer.capacity();
        long rawTail = this.logMetaDataBuffer.getAndAddLong(tailCounterOffset, framedLength);
        int termId = LogBufferDescriptor.termId(rawTail);
        int termOffset = LogBufferDescriptor.termOffset(rawTail, termLength);
        int resultingOffset = termOffset + framedLength;
        long position = LogBufferDescriptor.computePosition(termId, resultingOffset, this.positionBitsToShift, this.initialTermId);
        if (resultingOffset > termLength) {
            return this.handleEndOfLog(termBuffer, termLength, termId, termOffset, position);
        }
        int frameOffset = termOffset;
        byte flags = -128;
        int remaining = length;
        int positionOne = 0;
        int positionTwo = 0;
        do {
            bytesToWrite = Math.min(remaining, this.maxPayloadLength);
            int frameLength = bytesToWrite + 32;
            int alignedLength = BitUtil.align(frameLength, 32);
            this.headerWriter.write(termBuffer, frameOffset, frameLength, termId);
            int bytesWritten = 0;
            int payloadOffset = frameOffset + 32;
            do {
                int numBytes;
                int remainingOne;
                if ((remainingOne = lengthOne - positionOne) > 0) {
                    numBytes = Math.min(bytesToWrite - bytesWritten, remainingOne);
                    termBuffer.putBytes(payloadOffset, bufferOne, offsetOne + positionOne, numBytes);
                    bytesWritten += numBytes;
                    payloadOffset += numBytes;
                    positionOne += numBytes;
                    continue;
                }
                numBytes = Math.min(bytesToWrite - bytesWritten, lengthTwo - positionTwo);
                termBuffer.putBytes(payloadOffset, bufferTwo, offsetTwo + positionTwo, numBytes);
                bytesWritten += numBytes;
                payloadOffset += numBytes;
                positionTwo += numBytes;
            } while (bytesWritten < bytesToWrite);
            if (remaining <= this.maxPayloadLength) {
                flags = (byte)(flags | 0x40);
            }
            FrameDescriptor.frameFlags(termBuffer, frameOffset, flags);
            if (null != reservedValueSupplier) {
                long reservedValue = reservedValueSupplier.get(termBuffer, frameOffset, frameLength);
                termBuffer.putLong(frameOffset + 24, reservedValue, ByteOrder.LITTLE_ENDIAN);
            }
            FrameDescriptor.frameLengthOrdered(termBuffer, frameOffset, frameLength);
            flags = 0;
            frameOffset += alignedLength;
        } while ((remaining -= bytesToWrite) > 0);
        return position;
    }

    private long appendUnfragmentedMessage(UnsafeBuffer termBuffer, int tailCounterOffset, DirectBufferVector[] vectors, int length, ReservedValueSupplier reservedValueSupplier) {
        int frameLength = length + 32;
        int alignedLength = BitUtil.align(frameLength, 32);
        int termLength = termBuffer.capacity();
        long rawTail = this.logMetaDataBuffer.getAndAddLong(tailCounterOffset, alignedLength);
        int termId = LogBufferDescriptor.termId(rawTail);
        int termOffset = LogBufferDescriptor.termOffset(rawTail, termLength);
        int resultingOffset = termOffset + alignedLength;
        long position = LogBufferDescriptor.computePosition(termId, resultingOffset, this.positionBitsToShift, this.initialTermId);
        if (resultingOffset > termLength) {
            return this.handleEndOfLog(termBuffer, termLength, termId, termOffset, position);
        }
        this.headerWriter.write(termBuffer, termOffset, frameLength, termId);
        int offset = termOffset + 32;
        for (DirectBufferVector vector : vectors) {
            termBuffer.putBytes(offset, vector.buffer(), vector.offset(), vector.length());
            offset += vector.length();
        }
        if (null != reservedValueSupplier) {
            long reservedValue = reservedValueSupplier.get(termBuffer, termOffset, frameLength);
            termBuffer.putLong(termOffset + 24, reservedValue, ByteOrder.LITTLE_ENDIAN);
        }
        FrameDescriptor.frameLengthOrdered(termBuffer, termOffset, frameLength);
        return position;
    }

    private long appendFragmentedMessage(UnsafeBuffer termBuffer, int tailCounterOffset, DirectBufferVector[] vectors, int length, ReservedValueSupplier reservedValueSupplier) {
        int bytesToWrite;
        int framedLength = LogBufferDescriptor.computeFragmentedFrameLength(length, this.maxPayloadLength);
        int termLength = termBuffer.capacity();
        long rawTail = this.logMetaDataBuffer.getAndAddLong(tailCounterOffset, framedLength);
        int termId = LogBufferDescriptor.termId(rawTail);
        int termOffset = LogBufferDescriptor.termOffset(rawTail, termLength);
        int resultingOffset = termOffset + framedLength;
        long position = LogBufferDescriptor.computePosition(termId, resultingOffset, this.positionBitsToShift, this.initialTermId);
        if (resultingOffset > termLength) {
            return this.handleEndOfLog(termBuffer, termLength, termId, termOffset, position);
        }
        int frameOffset = termOffset;
        byte flags = -128;
        int remaining = length;
        int vectorIndex = 0;
        int vectorOffset = 0;
        do {
            bytesToWrite = Math.min(remaining, this.maxPayloadLength);
            int frameLength = bytesToWrite + 32;
            int alignedLength = BitUtil.align(frameLength, 32);
            this.headerWriter.write(termBuffer, frameOffset, frameLength, termId);
            int bytesWritten = 0;
            int payloadOffset = frameOffset + 32;
            do {
                DirectBufferVector vector = vectors[vectorIndex];
                int vectorRemaining = vector.length() - vectorOffset;
                int numBytes = Math.min(bytesToWrite - bytesWritten, vectorRemaining);
                termBuffer.putBytes(payloadOffset, vector.buffer(), vector.offset() + vectorOffset, numBytes);
                bytesWritten += numBytes;
                payloadOffset += numBytes;
                vectorOffset += numBytes;
                if (vectorRemaining > numBytes) continue;
                ++vectorIndex;
                vectorOffset = 0;
            } while (bytesWritten < bytesToWrite);
            if (remaining <= this.maxPayloadLength) {
                flags = (byte)(flags | 0x40);
            }
            FrameDescriptor.frameFlags(termBuffer, frameOffset, flags);
            if (null != reservedValueSupplier) {
                long reservedValue = reservedValueSupplier.get(termBuffer, frameOffset, frameLength);
                termBuffer.putLong(frameOffset + 24, reservedValue, ByteOrder.LITTLE_ENDIAN);
            }
            FrameDescriptor.frameLengthOrdered(termBuffer, frameOffset, frameLength);
            flags = 0;
            frameOffset += alignedLength;
        } while ((remaining -= bytesToWrite) > 0);
        return position;
    }

    private long claim(UnsafeBuffer termBuffer, int tailCounterOffset, int length, BufferClaim bufferClaim) {
        int frameLength = length + 32;
        int alignedLength = BitUtil.align(frameLength, 32);
        int termLength = termBuffer.capacity();
        long rawTail = this.logMetaDataBuffer.getAndAddLong(tailCounterOffset, alignedLength);
        int termId = LogBufferDescriptor.termId(rawTail);
        int termOffset = LogBufferDescriptor.termOffset(rawTail, termLength);
        int resultingOffset = termOffset + alignedLength;
        long position = LogBufferDescriptor.computePosition(termId, resultingOffset, this.positionBitsToShift, this.initialTermId);
        if (resultingOffset > termLength) {
            return this.handleEndOfLog(termBuffer, termLength, termId, termOffset, position);
        }
        this.headerWriter.write(termBuffer, termOffset, frameLength, termId);
        bufferClaim.wrap(termBuffer, termOffset, frameLength);
        return position;
    }

    private long handleEndOfLog(UnsafeBuffer termBuffer, int termLength, int termId, int termOffset, long position) {
        if (termOffset < termLength) {
            int paddingLength = termLength - termOffset;
            this.headerWriter.write(termBuffer, termOffset, paddingLength, termId);
            FrameDescriptor.frameType(termBuffer, termOffset, 0);
            FrameDescriptor.frameLengthOrdered(termBuffer, termOffset, paddingLength);
        }
        if (position >= this.maxPossiblePosition) {
            return -5L;
        }
        LogBufferDescriptor.rotateLog(this.logMetaDataBuffer, termId - this.initialTermId, termId);
        return -3L;
    }
}

