/*
 * Decompiled with CFR 0.152.
 */
package io.activej.test.rules;

import io.activej.common.exception.FatalErrorHandlers;
import io.activej.eventloop.Eventloop;
import io.activej.reactor.Reactor;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public final class EventloopRule
implements TestRule {
    private static void createEventloop() {
        Eventloop.builder().withCurrentThread().withFatalErrorHandler(FatalErrorHandlers.rethrow()).build();
    }

    public Statement apply(Statement base, Description description) {
        Reactor currentReactor = Reactor.getCurrentReactor();
        if (!(currentReactor instanceof Eventloop) || !currentReactor.inReactorThread()) {
            EventloopRule.createEventloop();
        }
        return base;
    }

    static {
        EventloopRule.createEventloop();
    }
}

