/*
 * Decompiled with CFR 0.152.
 */
package io.activej.test.rules;

import io.activej.codegen.ClassGenerator;
import io.activej.test.rules.LambdaStatement;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.junit.Assert;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public final class ClassBuilderConstantsRule
implements TestRule {
    public Statement apply(Statement base, Description description) {
        if (description.getTestClass().getAnnotation(IgnoreLeaks.class) != null || description.getAnnotation(IgnoreLeaks.class) != null) {
            return base;
        }
        return new LambdaStatement(() -> {
            ClassGenerator.clearStaticConstants();
            base.evaluate();
            Assert.assertEquals((String)"Some static constants have not been cleaned up", (long)0L, (long)ClassGenerator.getStaticConstantsSize());
        });
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    public static @interface IgnoreLeaks {
        public String value() default "";
    }
}

