/*
 * Decompiled with CFR 0.152.
 */
package io.activej.test.rules;

import io.activej.bytebuf.ByteBufPool;
import io.activej.test.rules.LambdaStatement;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.junit.Assert;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public final class ByteBufRule
implements TestRule {
    public Statement apply(Statement base, Description description) {
        if (description.getTestClass().getAnnotation(IgnoreLeaks.class) != null || description.getAnnotation(IgnoreLeaks.class) != null) {
            return base;
        }
        return new LambdaStatement(() -> {
            ByteBufPool.clear();
            base.evaluate();
            Assert.assertEquals((String)ByteBufPool.getStats().getPoolItemsString(), (long)ByteBufPool.getStats().getCreatedItems(), (long)ByteBufPool.getStats().getPoolItems());
        });
    }

    static {
        System.setProperty("ByteBufPool.stats", "true");
        System.setProperty("ByteBufPool.registry", "true");
        System.setProperty("ByteBufPool.minSize", "0");
        System.setProperty("ByteBufPool.maxSize", "0");
        System.setProperty("ByteBufPool.clearOnRecycle", "true");
        System.setProperty("ObjectPool.initialCapacity", "1024");
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    public static @interface IgnoreLeaks {
        public String value() default "";
    }
}

