/*
 * Decompiled with CFR 0.152.
 */
package io.activej.test.rules;

import io.activej.test.TestUtils;
import io.activej.test.rules.LambdaStatement;
import org.junit.Assert;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ActivePromisesRule
implements TestRule {
    private static final Logger logger = LoggerFactory.getLogger(ActivePromisesRule.class);

    public Statement apply(Statement base, Description description) {
        return new LambdaStatement(() -> {
            TestUtils.clearActivePromises();
            try {
                base.evaluate();
            }
            catch (Throwable t) {
                int n = TestUtils.getActivePromises();
                if (n != 0) {
                    logger.info("{} promise assertion{} not checked", (Object)n, (Object)(n == 1 ? " was" : "s were"));
                }
                throw t;
            }
            Assert.assertEquals((String)"Some promises have not been completed", (long)0L, (long)TestUtils.getActivePromises());
        });
    }
}

