/*
 * Decompiled with CFR 0.152.
 */
package io.activej.test;

import io.activej.common.function.BiConsumerEx;
import io.activej.common.function.BiFunctionEx;
import io.activej.common.function.ConsumerEx;
import io.activej.common.function.FunctionEx;
import io.activej.common.function.SupplierEx;
import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public final class TestUtils {
    private static int activePromises = 0;
    static int port = 1024;

    public static synchronized int getFreePort() {
        while (++port < 65536) {
            if (!TestUtils.probeBindAddress(new InetSocketAddress(port)) || !TestUtils.probeBindAddress(new InetSocketAddress("localhost", port)) || !TestUtils.probeBindAddress(new InetSocketAddress("127.0.0.1", port))) continue;
            return port;
        }
        throw new AssertionError();
    }

    private static boolean probeBindAddress(InetSocketAddress inetSocketAddress) {
        try (ServerSocket s = new ServerSocket();){
            s.bind(inetSocketAddress);
        }
        catch (BindException e) {
            return false;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    public static <T> BiConsumerEx<T, Exception> assertCompleteFn(ConsumerEx<T> consumer) {
        ++activePromises;
        return (t, e) -> {
            --activePromises;
            if (e != null) {
                throw new AssertionError(e);
            }
            try {
                consumer.accept(t);
            }
            catch (AssertionError e2) {
                throw e2;
            }
            catch (Throwable e2) {
                throw new AssertionError((Object)e2);
            }
        };
    }

    public static <T> BiConsumerEx<T, Exception> assertCompleteFn() {
        return TestUtils.assertCompleteFn($ -> {});
    }

    public static int getActivePromises() {
        return activePromises;
    }

    public static void clearActivePromises() {
        activePromises = 0;
    }

    public static <T> Supplier<T> assertingFn(SupplierEx<T> fn) {
        return () -> {
            try {
                return fn.get();
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new AssertionError((Object)e);
            }
        };
    }

    public static <T> Consumer<T> assertingFn(ConsumerEx<T> fn) {
        return x -> {
            try {
                fn.accept(x);
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new AssertionError((Object)e);
            }
        };
    }

    public static <T, U> BiConsumerEx<T, U> assertingFn(BiConsumerEx<T, U> fn) {
        return (x, y) -> {
            try {
                fn.accept(x, y);
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable throwable) {
                throw new AssertionError((Object)throwable);
            }
        };
    }

    public static <T, R> Function<T, R> assertingFn(FunctionEx<T, R> fn) {
        return x -> {
            try {
                return fn.apply(x);
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new AssertionError((Object)e);
            }
        };
    }

    public static <T, U, R> BiFunction<T, U, R> assertingFn(BiFunctionEx<T, U, R> fn) {
        return (x, y) -> {
            try {
                return fn.apply(x, y);
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new AssertionError((Object)e);
            }
        };
    }
}

