/*
 * Decompiled with CFR 0.152.
 */
package io.activej.test;

import io.activej.common.collection.CollectionUtils;
import io.activej.inject.Injector;
import io.activej.inject.InstanceInjector;
import io.activej.inject.Key;
import io.activej.inject.binding.Binding;
import io.activej.inject.module.Module;
import io.activej.inject.module.ModuleBuilder;
import io.activej.inject.module.Modules;
import io.activej.inject.util.ReflectionUtils;
import io.activej.test.UseModules;
import io.activej.test.rules.LambdaStatement;
import io.activej.types.Types;
import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.After;
import org.junit.Before;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.MultipleFailureException;
import org.junit.runners.model.Statement;

public class ActiveJRunner
extends BlockJUnit4ClassRunner {
    private final Set<FrameworkMethod> surroundings = new HashSet<FrameworkMethod>();
    private final Set<Key<?>> staticDependencies;
    private Module currentModule;
    private Set<Key<?>> currentDependencies;
    protected Injector currentInjector;

    public ActiveJRunner(Class<?> cls) throws InitializationError {
        super(cls);
        this.surroundings.addAll(this.getTestClass().getAnnotatedMethods(Before.class));
        this.surroundings.addAll(this.getTestClass().getAnnotatedMethods(After.class));
        this.staticDependencies = this.surroundings.stream().flatMap(m -> Arrays.stream(ReflectionUtils.toDependencies((Type)cls, (Executable)m.getMethod()))).collect(Collectors.toSet());
    }

    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        Description description = this.describeChild(method);
        if (this.isIgnored(method)) {
            notifier.fireTestIgnored(description);
            return;
        }
        try {
            Class cls = this.getTestClass().getJavaClass();
            HashSet<Module> modules = new HashSet<Module>();
            ActiveJRunner.addClassModules(modules, cls);
            ActiveJRunner.addMethodModules(modules, method);
            for (FrameworkMethod m : this.surroundings) {
                ActiveJRunner.addMethodModules(modules, m);
            }
            this.currentModule = Modules.combine(modules);
            this.currentDependencies = Arrays.stream(ReflectionUtils.toDependencies((Type)cls, (Executable)method.getMethod())).collect(Collectors.toSet());
        }
        catch (ExceptionInInitializerError e) {
            Throwable cause = e.getCause();
            notifier.fireTestFailure(new Failure(description, cause != null ? cause : e));
            return;
        }
        catch (Exception e) {
            notifier.fireTestFailure(new Failure(description, (Throwable)e));
            return;
        }
        this.runLeaf(this.methodBlock(method), description, notifier);
    }

    private static void addClassModules(Set<Module> modules, Class<?> cls) throws ExceptionInInitializerError, ReflectiveOperationException {
        while (cls != null) {
            UseModules useModules = cls.getAnnotation(UseModules.class);
            if (useModules != null) {
                for (Class<? extends Module> moduleClass : useModules.value()) {
                    modules.add(moduleClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                }
            }
            cls = cls.getSuperclass();
        }
    }

    private static void addMethodModules(Set<Module> modules, FrameworkMethod method) throws ExceptionInInitializerError, ReflectiveOperationException {
        UseModules useModules = method.getMethod().getAnnotation(UseModules.class);
        if (useModules == null) {
            return;
        }
        for (Class<? extends Module> moduleClass : useModules.value()) {
            modules.add(moduleClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
    }

    protected Object createTest() throws Exception {
        Object instance = super.createTest();
        Key self = Key.ofType((Type)this.getTestClass().getJavaClass());
        Key instanceInjectorKey = Key.ofType((Type)Types.parameterizedType(InstanceInjector.class, (Type[])new Type[]{this.getTestClass().getJavaClass()}));
        this.currentInjector = Injector.of((Module[])new Module[]{this.currentModule, ModuleBuilder.create().scan(instance).bind(DependencyToken.class).to(Binding.to(() -> {
            throw new AssertionError((Object)"should never be instantiated");
        }).addDependencies(CollectionUtils.union(this.currentDependencies, this.staticDependencies))).bind(self).toInstance(instance).bind(instanceInjectorKey).build()});
        this.currentInjector.createEagerInstances();
        ((InstanceInjector)this.currentInjector.getInstance(instanceInjectorKey)).injectInto(instance);
        return instance;
    }

    protected void validatePublicVoidNoArgMethods(Class<? extends Annotation> annotation, boolean isStatic, List<Throwable> errors) {
        for (FrameworkMethod testMethod : this.getTestClass().getAnnotatedMethods(annotation)) {
            testMethod.validatePublicVoid(isStatic, errors);
        }
    }

    protected Statement methodInvoker(FrameworkMethod method, Object test) {
        return new LambdaStatement(() -> method.invokeExplosively(test, this.getArgs(method)));
    }

    protected Object[] getArgs(FrameworkMethod method) {
        return Arrays.stream(ReflectionUtils.toDependencies((Type)this.getTestClass().getJavaClass(), (Executable)method.getMethod())).map(dependency -> this.currentInjector.getInstance(dependency)).toArray(Object[]::new);
    }

    protected Statement withBefores(FrameworkMethod method, Object target, Statement test) {
        List methods = this.getTestClass().getAnnotatedMethods(Before.class);
        if (methods.isEmpty()) {
            return test;
        }
        return new LambdaStatement(() -> {
            for (FrameworkMethod m : methods) {
                m.invokeExplosively(target, this.getArgs(m));
            }
            test.evaluate();
        });
    }

    protected Statement withAfters(FrameworkMethod method, Object target, Statement test) {
        List methods = this.getTestClass().getAnnotatedMethods(After.class);
        if (methods.isEmpty()) {
            return test;
        }
        return new LambdaStatement(() -> {
            ArrayList<Throwable> errors = new ArrayList<Throwable>();
            try {
                test.evaluate();
            }
            catch (Throwable e) {
                errors.add(e);
            }
            finally {
                for (FrameworkMethod m : methods) {
                    try {
                        m.invokeExplosively(target, this.getArgs(m));
                    }
                    catch (Throwable e) {
                        errors.add(e);
                    }
                }
            }
            MultipleFailureException.assertEmpty(errors);
        });
    }

    public static final class DependencyToken {
    }
}

