/*
 * Decompiled with CFR 0.152.
 */
package io.activej.common.sql;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;

public class SqlUtils {
    public static void executeScript(DataSource dataSource, Class<?> clazz) throws SQLException, IOException {
        SqlUtils.executeScript(dataSource, clazz.getPackage().getName() + "/" + clazz.getSimpleName() + ".sql");
    }

    public static void executeScript(DataSource dataSource, String scriptName) throws SQLException, IOException {
        String sql = new String(SqlUtils.loadResource(scriptName), StandardCharsets.UTF_8);
        SqlUtils.execute(dataSource, sql);
    }

    public static void execute(DataSource dataSource, String sql) throws SQLException {
        try (Connection connection = dataSource.getConnection();
             Statement statement = connection.createStatement();){
            statement.execute(sql);
        }
    }

    private static byte[] loadResource(String name) throws IOException {
        try (InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(name);){
            assert (stream != null);
            byte[] byArray = stream.readAllBytes();
            return byArray;
        }
    }
}

