/*
 * Decompiled with CFR 0.152.
 */
package io.activej.promise.jmx;

import io.activej.async.function.AsyncRunnable;
import io.activej.async.function.AsyncSupplier;
import io.activej.common.builder.AbstractBuilder;
import io.activej.common.function.BiConsumerEx;
import io.activej.jmx.api.attribute.JmxAttribute;
import io.activej.jmx.api.attribute.JmxReducers;
import io.activej.jmx.stats.ExceptionStats;
import io.activej.jmx.stats.JmxHistogram;
import io.activej.jmx.stats.ValueStats;
import io.activej.promise.Promise;
import io.activej.reactor.Reactor;
import java.time.Duration;
import java.time.Instant;
import org.jetbrains.annotations.Nullable;

public class PromiseStats {
    @Nullable
    private Reactor reactor;
    private int activePromises = 0;
    private long lastStartTimestamp = 0L;
    private long lastCompleteTimestamp = 0L;
    private final ValueStats duration;
    private final ExceptionStats exceptions = ExceptionStats.create();

    protected PromiseStats(@Nullable Reactor reactor, ValueStats duration) {
        this.reactor = reactor;
        this.duration = duration;
    }

    public static PromiseStats createMBean(Reactor reactor, Duration smoothingWindow) {
        return (PromiseStats)PromiseStats.builder(reactor, smoothingWindow).build();
    }

    public static PromiseStats create(Duration smoothingWindow) {
        return (PromiseStats)PromiseStats.builder(smoothingWindow).build();
    }

    public static Builder builder(Duration smoothingWindow) {
        return new PromiseStats(null, ValueStats.create((Duration)smoothingWindow)).new Builder();
    }

    public static Builder builder(Reactor reactor, Duration smoothingWindow) {
        return new PromiseStats(reactor, ValueStats.create((Duration)smoothingWindow)).new Builder();
    }

    public void setHistogram(long[] levels) {
        this.duration.setHistogram(levels);
    }

    public void setHistogram(JmxHistogram histogram) {
        this.duration.setHistogram(histogram);
    }

    private long currentTimeMillis() {
        if (this.reactor == null) {
            this.reactor = Reactor.getCurrentReactor();
        }
        return this.reactor.currentTimeMillis();
    }

    public <T> AsyncSupplier<T> wrapper(AsyncSupplier<T> supplier) {
        return () -> this.monitor(supplier.get());
    }

    public AsyncRunnable wrapper(AsyncRunnable runnable) {
        return () -> this.monitor(runnable.run());
    }

    public <T> Promise<T> monitor(Promise<T> promise) {
        return promise.whenComplete(this.recordStats());
    }

    public <T> BiConsumerEx<T, Exception> recordStats() {
        long before;
        ++this.activePromises;
        this.lastStartTimestamp = before = this.currentTimeMillis();
        return (value, e) -> {
            --this.activePromises;
            long now = this.currentTimeMillis();
            long durationMillis = now - before;
            this.lastCompleteTimestamp = now;
            this.duration.recordValue(durationMillis);
            if (e != null) {
                this.exceptions.recordException((Throwable)e);
            }
        };
    }

    @JmxAttribute(reducer=JmxReducers.JmxReducerSum.class)
    public long getActivePromises() {
        return this.activePromises;
    }

    @JmxAttribute
    @Nullable
    public Instant getLastStartTime() {
        return this.lastStartTimestamp != 0L ? Instant.ofEpochMilli(this.lastStartTimestamp) : null;
    }

    @JmxAttribute
    @Nullable
    public Instant getLastCompleteTime() {
        return this.lastCompleteTimestamp != 0L ? Instant.ofEpochMilli(this.lastCompleteTimestamp) : null;
    }

    @JmxAttribute
    @Nullable
    public Duration getCurrentDuration() {
        return this.activePromises != 0 ? Duration.ofMillis(this.currentTimeMillis() - this.lastStartTimestamp) : null;
    }

    @JmxAttribute
    public ValueStats getDuration() {
        return this.duration;
    }

    @JmxAttribute
    public ExceptionStats getExceptions() {
        return this.exceptions;
    }

    public String toString() {
        return "PromiseStats{activePromises=" + this.activePromises + ", lastStartTimestamp=" + Instant.ofEpochMilli(this.lastStartTimestamp) + ", lastCompleteTimestamp=" + Instant.ofEpochMilli(this.lastCompleteTimestamp) + ", duration=" + this.duration + ", exceptions=" + this.exceptions + "}";
    }

    public class Builder
    extends AbstractBuilder<Builder, PromiseStats> {
        protected Builder() {
        }

        public final Builder withHistogram(long[] levels) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            PromiseStats.this.setHistogram(levels);
            return this;
        }

        public final Builder withHistogram(JmxHistogram histogram) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            PromiseStats.this.setHistogram(histogram);
            return this;
        }

        protected PromiseStats doBuild() {
            return PromiseStats.this;
        }
    }
}

