/*
 * Decompiled with CFR 0.152.
 */
package io.activej.promise;

import io.activej.async.callback.AsyncComputation;
import io.activej.async.callback.Callback;
import io.activej.async.function.AsyncBiFunctionEx;
import io.activej.async.function.AsyncFunctionEx;
import io.activej.async.function.AsyncSupplierEx;
import io.activej.async.function.CallbackBiFunctionEx;
import io.activej.async.function.CallbackFunctionEx;
import io.activej.async.function.CallbackSupplierEx;
import io.activej.common.Checks;
import io.activej.common.collection.Try;
import io.activej.common.exception.FatalErrorHandler;
import io.activej.common.function.BiConsumerEx;
import io.activej.common.function.BiFunctionEx;
import io.activej.common.function.ConsumerEx;
import io.activej.common.function.FunctionEx;
import io.activej.common.function.RunnableEx;
import io.activej.common.function.SupplierEx;
import io.activej.promise.CompleteExceptionallyPromise;
import io.activej.promise.CompleteNullPromise;
import io.activej.promise.CompleteResultPromise;
import io.activej.promise.NextPromise;
import io.activej.promise.SettableCallback;
import io.activej.promise.SettablePromise;
import io.activej.reactor.Reactor;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public interface Promise<T>
extends AsyncComputation<T> {
    public static Promise<Void> complete() {
        return CompleteNullPromise.INSTANCE;
    }

    public static <T> Promise<T> of(@Nullable T value) {
        return value != null ? new CompleteResultPromise<T>(value) : CompleteNullPromise.instance();
    }

    public static <T> Promise<T> ofException(Exception e) {
        return new CompleteExceptionallyPromise(e);
    }

    public static <T> Promise<T> ofCallback(CallbackSupplierEx<T> fn) {
        SettablePromise cb = new SettablePromise();
        try {
            fn.get(cb);
        }
        catch (Exception ex) {
            FatalErrorHandler.handleError((Throwable)ex, fn);
            return Promise.ofException(ex);
        }
        return cb;
    }

    public static <T, R> Promise<R> ofCallback(T value, CallbackFunctionEx<? super T, R> fn) {
        SettablePromise cb = new SettablePromise();
        try {
            fn.apply(value, cb);
        }
        catch (Exception ex) {
            FatalErrorHandler.handleError((Throwable)ex, fn);
            return Promise.ofException(ex);
        }
        return cb;
    }

    public static <T, R> Promise<R> ofCallback(T value, @Nullable Exception exception, CallbackBiFunctionEx<? super T, @Nullable Exception, R> fn) {
        SettablePromise cb = new SettablePromise();
        try {
            fn.apply(value, exception, cb);
        }
        catch (Exception ex) {
            FatalErrorHandler.handleError((Throwable)ex, fn);
            return Promise.ofException(ex);
        }
        return cb;
    }

    public static <T, R> Promise<R> ofCallback(T value, @Nullable Exception exception, CallbackFunctionEx<? super T, R> fn, CallbackFunctionEx<Exception, R> fnException) {
        SettablePromise cb = new SettablePromise();
        try {
            if (exception == null) {
                fn.apply(value, cb);
            } else {
                fnException.apply(exception, cb);
            }
        }
        catch (Exception ex) {
            FatalErrorHandler.handleError((Throwable)ex, fn);
            return Promise.ofException(ex);
        }
        return cb;
    }

    public static <T> Promise<T> ofOptional(Optional<T> optional) {
        return Promise.ofOptional(optional, NoSuchElementException::new);
    }

    public static <T> Promise<T> ofOptional(Optional<T> optional, Supplier<? extends Exception> errorSupplier) {
        if (optional.isPresent()) {
            return Promise.of(optional.get());
        }
        return Promise.ofException(errorSupplier.get());
    }

    public static <T> Promise<T> of(@Nullable T value, @Nullable Exception e) {
        Checks.checkArgument((value == null || e == null ? 1 : 0) != 0, (Object)"Either value or exception should be 'null'");
        return e == null ? Promise.of(value) : Promise.ofException(e);
    }

    public static <T> Promise<T> ofTry(Try<T> t) {
        return (Promise)t.reduce(Promise::of, Promise::ofException);
    }

    public static <T> Promise<T> ofFuture(CompletableFuture<? extends T> future) {
        return Promise.ofCompletionStage(future);
    }

    public static <T> Promise<T> ofCompletionStage(CompletionStage<? extends T> completionStage) {
        return Promise.ofCallback(cb -> {
            Reactor reactor = Reactor.getCurrentReactor();
            reactor.startExternalTask();
            completionStage.whenCompleteAsync((result, throwable) -> {
                reactor.execute(() -> {
                    if (throwable == null) {
                        cb.set(result, null);
                    } else {
                        Exception e = FatalErrorHandler.getExceptionOrThrowError((Throwable)(throwable instanceof CompletionException ? throwable.getCause() : throwable));
                        FatalErrorHandler.handleError((Throwable)e, (Object)cb);
                        cb.set(null, e);
                    }
                });
                reactor.completeExternalTask();
            });
        });
    }

    public static <T> Promise<T> ofFuture(Executor executor, Future<? extends T> future) {
        return Promise.ofCallback(cb -> {
            Reactor reactor = Reactor.getCurrentReactor();
            reactor.startExternalTask();
            try {
                executor.execute(() -> {
                    try {
                        Object value = future.get();
                        reactor.execute(() -> cb.set(value));
                    }
                    catch (ExecutionException ex) {
                        reactor.execute(() -> {
                            Exception e = FatalErrorHandler.getExceptionOrThrowError((Throwable)ex.getCause());
                            FatalErrorHandler.handleError((Throwable)e, (Object)cb);
                            cb.setException(e);
                        });
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        reactor.execute(() -> cb.setException(e));
                    }
                    catch (CancellationException e) {
                        reactor.execute(() -> cb.setException(e));
                    }
                    catch (Throwable throwable) {
                        reactor.execute(() -> {
                            Exception e = FatalErrorHandler.getExceptionOrThrowError((Throwable)throwable);
                            FatalErrorHandler.handleError((Throwable)e, (Object)cb);
                            cb.setException(e);
                        });
                    }
                    finally {
                        reactor.completeExternalTask();
                    }
                });
            }
            catch (RejectedExecutionException e) {
                reactor.completeExternalTask();
                cb.setException(e);
            }
        });
    }

    public static <T> Promise<T> ofBlocking(Executor executor, SupplierEx<? extends T> supplier) {
        return Promise.ofCallback(cb -> {
            Reactor reactor = Reactor.getCurrentReactor();
            reactor.startExternalTask();
            try {
                executor.execute(() -> {
                    try {
                        Object result = supplier.get();
                        reactor.execute(() -> cb.set(result));
                    }
                    catch (Throwable throwable) {
                        reactor.execute(() -> {
                            Exception e = FatalErrorHandler.getExceptionOrThrowError((Throwable)throwable);
                            FatalErrorHandler.handleError((Throwable)e, (Object)cb);
                            cb.setException(e);
                        });
                    }
                    finally {
                        reactor.completeExternalTask();
                    }
                });
            }
            catch (RejectedExecutionException e) {
                reactor.completeExternalTask();
                cb.setException(e);
            }
        });
    }

    public static Promise<Void> ofBlocking(Executor executor, RunnableEx runnable) {
        return Promise.ofBlocking(executor, () -> {
            runnable.run();
            return null;
        });
    }

    @Contract(pure=true)
    default public boolean isComplete() {
        return this.isResult() || this.isException();
    }

    @Contract(pure=true)
    public boolean isResult();

    @Contract(pure=true)
    public boolean isException();

    @Contract(pure=true)
    public T getResult();

    @Contract(pure=true)
    public Exception getException();

    @Contract(pure=true)
    public Try<T> getTry();

    @Contract(pure=true)
    public Promise<T> async();

    public Promise<T> subscribe(Callback<? super T> var1);

    default public <U> Promise<U> map(FunctionEx<? super T, ? extends U> fn) {
        return this.thenCallback((? super T t, SettableCallback<U> cb) -> cb.set(fn.apply(t)));
    }

    default public <U> Promise<U> map(BiFunctionEx<? super T, @Nullable Exception, ? extends U> fn) {
        return this.thenCallback((? super T t, Exception e, SettableCallback<U> cb) -> cb.set(fn.apply(t, e)));
    }

    default public <U> Promise<U> map(FunctionEx<? super T, ? extends U> fn, FunctionEx<Exception, ? extends U> exceptionFn) {
        return this.thenCallback((? super T t, Exception e, SettableCallback<U> cb) -> cb.set(e == null ? fn.apply(t) : exceptionFn.apply(e)));
    }

    default public Promise<T> mapException(FunctionEx<Exception, Exception> exceptionFn) {
        return this.thenCallback((? super T t, Exception e, SettableCallback<U> cb) -> {
            if (e == null) {
                cb.set(t);
            } else {
                cb.setException((Exception)exceptionFn.apply(e));
            }
        });
    }

    default public <E extends Exception> Promise<T> mapException(Class<E> clazz, FunctionEx<? super E, ? extends Exception> exceptionFn) {
        return this.thenCallback((? super T t, Exception e, SettableCallback<U> cb) -> {
            if (e == null) {
                cb.set(t);
            } else {
                cb.setException(clazz.isAssignableFrom(e.getClass()) ? (Exception)exceptionFn.apply(e) : e);
            }
        });
    }

    default public <U> Promise<U> then(AsyncSupplierEx<U> fn) {
        return this.thenCallback((SettableCallback<U> cb) -> fn.get().subscribe(cb));
    }

    default public <U> Promise<U> thenCallback(CallbackSupplierEx<U> fn) {
        return this.thenCallback((? super T t, Exception e, SettableCallback<U> cb) -> {
            if (e == null) {
                fn.get(cb);
            } else {
                cb.setException((Exception)e);
            }
        });
    }

    default public <U> Promise<U> then(AsyncFunctionEx<? super T, U> fn) {
        return this.thenCallback((? super T t, SettableCallback<U> cb) -> fn.apply(t).subscribe(cb));
    }

    default public <U> Promise<U> thenCallback(CallbackFunctionEx<? super T, U> fn) {
        return this.thenCallback((? super T t, Exception e, SettableCallback<U> cb) -> {
            if (e == null) {
                fn.apply(t, cb);
            } else {
                cb.setException((Exception)e);
            }
        });
    }

    default public <U> Promise<U> then(AsyncBiFunctionEx<? super T, @Nullable Exception, U> fn) {
        return this.thenCallback((? super T t, Exception e, SettableCallback<U> cb) -> fn.apply((Object)t, (Exception)e).subscribe(cb));
    }

    public <U> Promise<U> thenCallback(CallbackBiFunctionEx<? super T, @Nullable Exception, U> var1);

    default public <U> Promise<U> then(AsyncFunctionEx<? super T, U> fn, AsyncFunctionEx<Exception, U> exceptionFn) {
        return this.thenCallback((? super T t, Exception e, SettableCallback<U> cb) -> (e == null ? fn.apply(t) : exceptionFn.apply((Exception)e)).subscribe(cb));
    }

    default public <U> Promise<U> thenCallback(CallbackFunctionEx<? super T, U> fn, CallbackFunctionEx<Exception, U> exceptionFn) {
        return this.thenCallback((? super T t, Exception e, SettableCallback<U> cb) -> {
            if (e == null) {
                fn.apply(t, cb);
            } else {
                exceptionFn.apply((Exception)e, cb);
            }
        });
    }

    default public Promise<T> whenComplete(BiConsumerEx<? super T, Exception> fn) {
        return this.thenCallback((? super T t, Exception e, SettableCallback<U> cb) -> {
            fn.accept(t, e);
            cb.set(t, (Exception)e);
        });
    }

    default public Promise<T> whenComplete(ConsumerEx<? super T> fn, ConsumerEx<Exception> exceptionFn) {
        return this.thenCallback((? super T t, Exception e, SettableCallback<U> cb) -> {
            fn.accept(t);
            cb.set(t, (Exception)e);
        });
    }

    default public Promise<T> whenComplete(RunnableEx action) {
        return this.thenCallback((? super T t, Exception e, SettableCallback<U> cb) -> {
            action.run();
            cb.set(t, (Exception)e);
        });
    }

    default public Promise<T> whenResult(ConsumerEx<? super T> fn) {
        return this.thenCallback((? super T t, SettableCallback<U> cb) -> {
            fn.accept(t);
            cb.set(t);
        });
    }

    default public Promise<T> whenResult(RunnableEx action) {
        return this.thenCallback((? super T t, SettableCallback<U> cb) -> {
            action.run();
            cb.set(t);
        });
    }

    default public Promise<T> whenException(ConsumerEx<Exception> fn) {
        return this.thenCallback((? super T t, Exception e, SettableCallback<U> cb) -> {
            if (e != null) {
                fn.accept(e);
            }
            cb.set(t, (Exception)e);
        });
    }

    default public <E extends Exception> Promise<T> whenException(Class<E> clazz, ConsumerEx<? super E> fn) {
        return this.thenCallback((? super T t, Exception e, SettableCallback<U> cb) -> {
            if (e != null && clazz.isAssignableFrom(e.getClass())) {
                fn.accept(e);
            }
            cb.set(t, (Exception)e);
        });
    }

    default public Promise<T> whenException(RunnableEx action) {
        return this.thenCallback((? super T t, Exception e, SettableCallback<U> cb) -> {
            if (e != null) {
                action.run();
            }
            cb.set(t, (Exception)e);
        });
    }

    default public Promise<T> whenException(Class<? extends Exception> clazz, RunnableEx action) {
        return this.thenCallback((? super T t, Exception e, SettableCallback<U> cb) -> {
            if (e != null && clazz.isAssignableFrom(e.getClass())) {
                action.run();
            }
            cb.set(t, (Exception)e);
        });
    }

    default public <U> Promise<U> cast() {
        return this;
    }

    default public <U> Promise<U> cast(Class<? extends U> cls) {
        return this;
    }

    @Contract(pure=true)
    public <U, V> Promise<V> combine(Promise<? extends U> var1, BiFunctionEx<? super T, ? super U, ? extends V> var2);

    @Contract(pure=true)
    public Promise<Void> both(Promise<?> var1);

    @Contract(pure=true)
    public Promise<T> either(Promise<? extends T> var1);

    @Contract(pure=true)
    public Promise<Try<T>> toTry();

    @Contract(pure=true)
    public Promise<Void> toVoid();

    @ApiStatus.Internal
    public void next(NextPromise<? super T, ?> var1);

    @ApiStatus.Internal
    default public void call(Callback<? super T> cb) {
        this.subscribe(cb);
    }

    @Contract(pure=true)
    public CompletableFuture<T> toCompletableFuture();
}

