/*
 * Decompiled with CFR 0.152.
 */
package io.activej.promise;

import io.activej.async.callback.Callback;
import io.activej.async.function.AsyncBiFunctionEx;
import io.activej.async.function.AsyncFunctionEx;
import io.activej.async.function.AsyncSupplierEx;
import io.activej.async.function.CallbackBiFunctionEx;
import io.activej.async.function.CallbackFunctionEx;
import io.activej.async.function.CallbackSupplierEx;
import io.activej.common.collection.Try;
import io.activej.common.exception.FatalErrorHandler;
import io.activej.common.function.BiConsumerEx;
import io.activej.common.function.BiFunctionEx;
import io.activej.common.function.ConsumerEx;
import io.activej.common.function.FunctionEx;
import io.activej.common.function.RunnableEx;
import io.activej.common.recycle.Recyclers;
import io.activej.promise.AbstractPromise;
import io.activej.promise.NextPromise;
import io.activej.promise.Promise;
import io.activej.promise.SettablePromise;
import io.activej.reactor.Reactor;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.Nullable;

public abstract class CompletePromise<T>
implements Promise<T> {
    @Override
    public final boolean isComplete() {
        return true;
    }

    @Override
    public final boolean isResult() {
        return true;
    }

    @Override
    public final boolean isException() {
        return false;
    }

    @Override
    public final Exception getException() {
        return null;
    }

    @Override
    public Try<T> getTry() {
        return Try.of(this.getResult());
    }

    @Override
    public final <U> Promise<U> map(FunctionEx<? super T, ? extends U> fn) {
        try {
            return Promise.of(fn.apply(this.getResult()));
        }
        catch (Exception ex) {
            FatalErrorHandler.handleError((Throwable)ex, (Object)this);
            return Promise.ofException(ex);
        }
    }

    @Override
    public final <U> Promise<U> map(BiFunctionEx<? super T, Exception, ? extends U> fn) {
        try {
            return Promise.of(fn.apply(this.getResult(), null));
        }
        catch (Exception ex) {
            FatalErrorHandler.handleError((Throwable)ex, (Object)this);
            return Promise.ofException(ex);
        }
    }

    @Override
    public <U> Promise<U> map(FunctionEx<? super T, ? extends U> fn, FunctionEx<Exception, ? extends U> exceptionFn) {
        try {
            return Promise.of(fn.apply(this.getResult()));
        }
        catch (Exception ex) {
            FatalErrorHandler.handleError((Throwable)ex, (Object)this);
            return Promise.ofException(ex);
        }
    }

    @Override
    public Promise<T> mapException(FunctionEx<Exception, Exception> exceptionFn) {
        return this;
    }

    @Override
    public <E extends Exception> Promise<T> mapException(Class<E> clazz, FunctionEx<? super E, ? extends Exception> exceptionFn) {
        return this;
    }

    @Override
    public final <U> Promise<U> then(AsyncFunctionEx<? super T, U> fn) {
        try {
            return fn.apply(this.getResult());
        }
        catch (Exception ex) {
            FatalErrorHandler.handleError((Throwable)ex, (Object)this);
            return Promise.ofException(ex);
        }
    }

    @Override
    public <U> Promise<U> thenCallback(CallbackFunctionEx<? super T, U> fn) {
        try {
            return Promise.ofCallback(this.getResult(), fn);
        }
        catch (Exception ex) {
            FatalErrorHandler.handleError((Throwable)ex, (Object)this);
            return Promise.ofException(ex);
        }
    }

    @Override
    public <U> Promise<U> then(AsyncSupplierEx<U> fn) {
        try {
            return fn.get();
        }
        catch (Exception ex) {
            FatalErrorHandler.handleError((Throwable)ex, (Object)this);
            return Promise.ofException(ex);
        }
    }

    @Override
    public <U> Promise<U> thenCallback(CallbackSupplierEx<U> fn) {
        try {
            return Promise.ofCallback(fn);
        }
        catch (Exception ex) {
            FatalErrorHandler.handleError((Throwable)ex, (Object)this);
            return Promise.ofException(ex);
        }
    }

    @Override
    public final <U> Promise<U> then(AsyncBiFunctionEx<? super T, Exception, U> fn) {
        try {
            return fn.apply(this.getResult(), null);
        }
        catch (Exception ex) {
            FatalErrorHandler.handleError((Throwable)ex, (Object)this);
            return Promise.ofException(ex);
        }
    }

    @Override
    public <U> Promise<U> thenCallback(CallbackBiFunctionEx<? super T, @Nullable Exception, U> fn) {
        try {
            return Promise.ofCallback(this.getResult(), null, fn);
        }
        catch (Exception ex) {
            FatalErrorHandler.handleError((Throwable)ex, (Object)this);
            return Promise.ofException(ex);
        }
    }

    @Override
    public <U> Promise<U> then(AsyncFunctionEx<? super T, U> fn, AsyncFunctionEx<Exception, U> exceptionFn) {
        try {
            return fn.apply(this.getResult());
        }
        catch (Exception ex) {
            FatalErrorHandler.handleError((Throwable)ex, (Object)this);
            return Promise.ofException(ex);
        }
    }

    @Override
    public <U> Promise<U> thenCallback(CallbackFunctionEx<? super T, U> fn, CallbackFunctionEx<Exception, U> exceptionFn) {
        try {
            return Promise.ofCallback(this.getResult(), null, fn, exceptionFn);
        }
        catch (Exception ex) {
            FatalErrorHandler.handleError((Throwable)ex, (Object)this);
            return Promise.ofException(ex);
        }
    }

    @Override
    public Promise<T> whenComplete(BiConsumerEx<? super T, Exception> fn) {
        try {
            fn.accept(this.getResult(), null);
            return this;
        }
        catch (Exception ex) {
            FatalErrorHandler.handleError((Throwable)ex, (Object)this);
            return Promise.ofException(ex);
        }
    }

    @Override
    public Promise<T> whenComplete(ConsumerEx<? super T> fn, ConsumerEx<Exception> exceptionFn) {
        try {
            fn.accept(this.getResult());
            return this;
        }
        catch (Exception ex) {
            FatalErrorHandler.handleError((Throwable)ex, (Object)this);
            return Promise.ofException(ex);
        }
    }

    @Override
    public Promise<T> whenComplete(RunnableEx action) {
        try {
            action.run();
            return this;
        }
        catch (Exception ex) {
            FatalErrorHandler.handleError((Throwable)ex, (Object)this);
            return Promise.ofException(ex);
        }
    }

    @Override
    public Promise<T> whenResult(ConsumerEx<? super T> fn) {
        try {
            fn.accept(this.getResult());
            return this;
        }
        catch (Exception ex) {
            FatalErrorHandler.handleError((Throwable)ex, (Object)this);
            return Promise.ofException(ex);
        }
    }

    @Override
    public Promise<T> whenResult(RunnableEx action) {
        try {
            action.run();
            return this;
        }
        catch (Exception ex) {
            FatalErrorHandler.handleError((Throwable)ex, (Object)this);
            return Promise.ofException(ex);
        }
    }

    @Override
    public Promise<T> whenException(ConsumerEx<Exception> fn) {
        return this;
    }

    @Override
    public <E extends Exception> Promise<T> whenException(Class<E> clazz, ConsumerEx<? super E> fn) {
        return this;
    }

    @Override
    public Promise<T> whenException(RunnableEx action) {
        return this;
    }

    @Override
    public Promise<T> whenException(Class<? extends Exception> clazz, RunnableEx action) {
        return this;
    }

    @Override
    public final <U, V> Promise<V> combine(Promise<? extends U> other, BiFunctionEx<? super T, ? super U, ? extends V> fn) {
        return other.map(otherResult -> fn.apply(this.getResult(), otherResult)).whenException(() -> Recyclers.recycle(this.getResult()));
    }

    @Override
    public final Promise<Void> both(Promise<?> other) {
        Recyclers.recycle(this.getResult());
        return other.map(AbstractPromise::recycleToVoid);
    }

    @Override
    public final Promise<T> either(Promise<? extends T> other) {
        other.whenResult(Recyclers::recycle);
        return this;
    }

    @Override
    public final Promise<T> async() {
        SettablePromise result = new SettablePromise();
        Reactor.getCurrentReactor().post(() -> result.set(this.getResult()));
        return result;
    }

    @Override
    public final Promise<Try<T>> toTry() {
        return Promise.of(Try.of(this.getResult()));
    }

    @Override
    public final Promise<Void> toVoid() {
        return Promise.complete();
    }

    @Override
    public void next(NextPromise<? super T, ?> cb) {
        cb.acceptNext(this.getResult(), null);
    }

    @Override
    public Promise<T> subscribe(Callback<? super T> cb) {
        cb.accept(this.getResult(), null);
        return this;
    }

    @Override
    public final CompletableFuture<T> toCompletableFuture() {
        return CompletableFuture.completedFuture(this.getResult());
    }

    static {
        Recyclers.register(CompletePromise.class, promise -> Recyclers.recycle(promise.getResult()));
    }
}

