/*
 * Decompiled with CFR 0.152.
 */
package io.activej.promise;

import io.activej.async.callback.Callback;
import io.activej.async.function.AsyncBiFunctionEx;
import io.activej.async.function.AsyncFunctionEx;
import io.activej.async.function.AsyncSupplierEx;
import io.activej.async.function.CallbackBiFunctionEx;
import io.activej.async.function.CallbackFunctionEx;
import io.activej.async.function.CallbackSupplierEx;
import io.activej.common.collection.Try;
import io.activej.common.exception.FatalErrorHandler;
import io.activej.common.function.BiConsumerEx;
import io.activej.common.function.BiFunctionEx;
import io.activej.common.function.ConsumerEx;
import io.activej.common.function.FunctionEx;
import io.activej.common.function.RunnableEx;
import io.activej.common.recycle.Recyclers;
import io.activej.promise.NextPromise;
import io.activej.promise.Promise;
import io.activej.promise.SettablePromise;
import io.activej.reactor.Reactor;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.Nullable;

public final class CompleteExceptionallyPromise<T>
implements Promise<T> {
    private final Exception exception;

    public CompleteExceptionallyPromise(Exception e) {
        this.exception = e;
    }

    @Override
    public boolean isComplete() {
        return true;
    }

    @Override
    public boolean isResult() {
        return false;
    }

    @Override
    public boolean isException() {
        return true;
    }

    @Override
    public T getResult() {
        return null;
    }

    @Override
    public Exception getException() {
        return this.exception;
    }

    @Override
    public Try<T> getTry() {
        return Try.ofException((Exception)this.exception);
    }

    @Override
    public <U> Promise<U> map(FunctionEx<? super T, ? extends U> fn) {
        return this;
    }

    @Override
    public <U> Promise<U> map(BiFunctionEx<? super T, Exception, ? extends U> fn) {
        try {
            return Promise.of(fn.apply(null, (Object)this.exception));
        }
        catch (Exception ex) {
            FatalErrorHandler.handleError((Throwable)ex, (Object)this);
            return Promise.ofException(ex);
        }
    }

    @Override
    public <U> Promise<U> map(FunctionEx<? super T, ? extends U> fn, FunctionEx<Exception, ? extends U> exceptionFn) {
        try {
            return Promise.of(exceptionFn.apply((Object)this.exception));
        }
        catch (Exception ex) {
            FatalErrorHandler.handleError((Throwable)ex, (Object)this);
            return Promise.ofException(ex);
        }
    }

    @Override
    public Promise<T> mapException(FunctionEx<Exception, Exception> exceptionFn) {
        try {
            return Promise.ofException((Exception)exceptionFn.apply((Object)this.exception));
        }
        catch (Exception ex) {
            FatalErrorHandler.handleError((Throwable)ex, (Object)this);
            return Promise.ofException(ex);
        }
    }

    @Override
    public <E extends Exception> Promise<T> mapException(Class<E> clazz, FunctionEx<? super E, ? extends Exception> exceptionFn) {
        try {
            return clazz.isAssignableFrom(this.exception.getClass()) ? Promise.ofException((Exception)exceptionFn.apply((Object)this.exception)) : this;
        }
        catch (Exception ex) {
            FatalErrorHandler.handleError((Throwable)ex, (Object)this);
            return Promise.ofException(ex);
        }
    }

    @Override
    public <U> Promise<U> then(AsyncFunctionEx<? super T, U> fn) {
        return this;
    }

    @Override
    public <U> Promise<U> thenCallback(CallbackFunctionEx<? super T, U> fn) {
        return this;
    }

    @Override
    public <U> Promise<U> then(AsyncSupplierEx<U> fn) {
        return this;
    }

    @Override
    public <U> Promise<U> thenCallback(CallbackSupplierEx<U> fn) {
        return this;
    }

    @Override
    public <U> Promise<U> then(AsyncBiFunctionEx<? super T, Exception, U> fn) {
        try {
            return fn.apply(null, this.exception);
        }
        catch (Exception ex) {
            FatalErrorHandler.handleError((Throwable)ex, (Object)this);
            return Promise.ofException(ex);
        }
    }

    @Override
    public <U> Promise<U> thenCallback(CallbackBiFunctionEx<? super T, @Nullable Exception, U> fn) {
        try {
            return Promise.ofCallback(null, this.exception, fn);
        }
        catch (Exception ex) {
            FatalErrorHandler.handleError((Throwable)ex, (Object)this);
            return Promise.ofException(ex);
        }
    }

    @Override
    public <U> Promise<U> then(AsyncFunctionEx<? super T, U> fn, AsyncFunctionEx<Exception, U> exceptionFn) {
        try {
            return exceptionFn.apply(this.exception);
        }
        catch (Exception ex) {
            FatalErrorHandler.handleError((Throwable)ex, (Object)this);
            return Promise.ofException(ex);
        }
    }

    @Override
    public <U> Promise<U> thenCallback(CallbackFunctionEx<? super T, U> fn, CallbackFunctionEx<Exception, U> exceptionFn) {
        try {
            return Promise.ofCallback(null, this.exception, fn, exceptionFn);
        }
        catch (Exception ex) {
            FatalErrorHandler.handleError((Throwable)ex, (Object)this);
            return Promise.ofException(ex);
        }
    }

    @Override
    public Promise<T> whenComplete(BiConsumerEx<? super T, Exception> fn) {
        try {
            fn.accept(null, (Object)this.exception);
            return this;
        }
        catch (Exception ex) {
            FatalErrorHandler.handleError((Throwable)ex, (Object)this);
            return Promise.ofException(ex);
        }
    }

    @Override
    public Promise<T> whenComplete(ConsumerEx<? super T> fn, ConsumerEx<Exception> exceptionFn) {
        try {
            exceptionFn.accept((Object)this.exception);
            return this;
        }
        catch (Exception ex) {
            FatalErrorHandler.handleError((Throwable)ex, (Object)this);
            return Promise.ofException(ex);
        }
    }

    @Override
    public Promise<T> whenComplete(RunnableEx action) {
        try {
            action.run();
            return this;
        }
        catch (Exception ex) {
            FatalErrorHandler.handleError((Throwable)ex, (Object)this);
            return Promise.ofException(ex);
        }
    }

    @Override
    public Promise<T> whenResult(ConsumerEx<? super T> fn) {
        return this;
    }

    @Override
    public Promise<T> whenResult(RunnableEx action) {
        return this;
    }

    @Override
    public Promise<T> whenException(ConsumerEx<Exception> fn) {
        try {
            fn.accept((Object)this.exception);
            return this;
        }
        catch (Exception ex) {
            FatalErrorHandler.handleError((Throwable)ex, (Object)this);
            return Promise.ofException(ex);
        }
    }

    @Override
    public <E extends Exception> Promise<T> whenException(Class<E> clazz, ConsumerEx<? super E> fn) {
        try {
            if (clazz.isAssignableFrom(this.exception.getClass())) {
                fn.accept((Object)this.exception);
            }
            return this;
        }
        catch (Exception ex) {
            FatalErrorHandler.handleError((Throwable)ex, (Object)this);
            return Promise.ofException(ex);
        }
    }

    @Override
    public Promise<T> whenException(RunnableEx action) {
        try {
            action.run();
            return this;
        }
        catch (Exception ex) {
            FatalErrorHandler.handleError((Throwable)ex, (Object)this);
            return Promise.ofException(ex);
        }
    }

    @Override
    public Promise<T> whenException(Class<? extends Exception> clazz, RunnableEx action) {
        try {
            if (clazz.isAssignableFrom(this.exception.getClass())) {
                action.run();
            }
            return this;
        }
        catch (Exception ex) {
            FatalErrorHandler.handleError((Throwable)ex, (Object)this);
            return Promise.ofException(ex);
        }
    }

    @Override
    public <U, V> Promise<V> combine(Promise<? extends U> other, BiFunctionEx<? super T, ? super U, ? extends V> fn) {
        other.whenResult(Recyclers::recycle);
        return this;
    }

    @Override
    public Promise<Void> both(Promise<?> other) {
        other.whenResult(Recyclers::recycle);
        return this;
    }

    @Override
    public Promise<T> either(Promise<? extends T> other) {
        return other;
    }

    @Override
    public Promise<T> async() {
        SettablePromise result = new SettablePromise();
        Reactor.getCurrentReactor().post(() -> result.setException(this.exception));
        return result;
    }

    @Override
    public Promise<Try<T>> toTry() {
        return Promise.of(Try.ofException((Exception)this.exception));
    }

    @Override
    public Promise<Void> toVoid() {
        return this;
    }

    @Override
    public void next(NextPromise<? super T, ?> cb) {
        cb.acceptNext(null, this.exception);
    }

    @Override
    public Promise<T> subscribe(Callback<? super T> cb) {
        cb.accept(null, this.exception);
        return this;
    }

    @Override
    public CompletableFuture<T> toCompletableFuture() {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(this.exception);
        return future;
    }
}

