/*
 * Decompiled with CFR 0.152.
 */
package io.activej.promise;

import io.activej.async.callback.Callback;
import io.activej.async.function.AsyncBiFunctionEx;
import io.activej.async.function.AsyncFunctionEx;
import io.activej.async.function.AsyncSupplierEx;
import io.activej.async.function.CallbackBiFunctionEx;
import io.activej.async.function.CallbackFunctionEx;
import io.activej.async.function.CallbackSupplierEx;
import io.activej.common.ApplicationSettings;
import io.activej.common.Checks;
import io.activej.common.collection.Try;
import io.activej.common.exception.FatalErrorHandler;
import io.activej.common.function.BiConsumerEx;
import io.activej.common.function.BiFunctionEx;
import io.activej.common.function.ConsumerEx;
import io.activej.common.function.FunctionEx;
import io.activej.common.function.RunnableEx;
import io.activej.common.recycle.Recyclers;
import io.activej.promise.NextPromise;
import io.activej.promise.Promise;
import io.activej.promise.SettablePromise;
import io.activej.reactor.Reactor;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Async;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPromise<T>
implements Promise<T> {
    private static final boolean CHECKS;
    private static final Object PROMISE_NOT_SET;
    private static final boolean RESET_CALLBACKS;
    protected T result = PROMISE_NOT_SET;
    @Nullable
    protected Exception exception;
    @Nullable
    protected Object next;
    private static final Object NO_RESULT;
    private static final String INDENT = "\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*";
    private static final Pattern PACKAGE_NAME_AND_LAMBDA_PART;

    public void reset() {
        this.result = PROMISE_NOT_SET;
        this.exception = null;
        this.next = null;
    }

    public void resetCallbacks() {
        this.next = null;
    }

    @Override
    public final boolean isComplete() {
        return this.result != PROMISE_NOT_SET;
    }

    @Override
    public final boolean isResult() {
        return this.result != PROMISE_NOT_SET && this.exception == null;
    }

    @Override
    public final boolean isException() {
        return this.exception != null;
    }

    @Override
    public T getResult() {
        return this.result != PROMISE_NOT_SET ? (T)this.result : null;
    }

    @Override
    public Exception getException() {
        return this.exception;
    }

    @Override
    public Try<T> getTry() {
        if (this.isResult()) {
            return Try.of(this.result);
        }
        if (this.isException()) {
            return Try.ofException((Exception)this.exception);
        }
        return null;
    }

    protected void complete(@Nullable T value, @Nullable Exception e) {
        if (CHECKS) {
            Checks.checkState((!this.isComplete() ? 1 : 0) != 0, (Object)"Promise has already been completed");
        }
        if (e == null) {
            this.complete(value);
        } else {
            this.completeExceptionally(e);
        }
    }

    @Async.Execute
    protected void complete(@Nullable T value) {
        if (CHECKS) {
            Checks.checkState((!this.isComplete() ? 1 : 0) != 0, (Object)"Promise has already been completed");
        }
        this.result = value;
        Object object = this.next;
        if (object instanceof NextPromise) {
            NextPromise cb = (NextPromise)object;
            cb.acceptNext(value, null);
        } else {
            object = this.next;
            if (object instanceof Callback) {
                Callback cb = (Callback)object;
                cb.accept(value, null);
            } else {
                object = this.next;
                if (object instanceof Object[]) {
                    Object[] list = (Object[])object;
                    for (int i = 0; i < list.length; ++i) {
                        Object it = list[i];
                        if (it instanceof NextPromise) {
                            NextPromise cb = (NextPromise)it;
                            cb.acceptNext(value, null);
                            continue;
                        }
                        ((Callback)it).accept(value, null);
                    }
                }
            }
        }
        if (RESET_CALLBACKS) {
            this.next = null;
        }
    }

    @Async.Execute
    protected void completeExceptionally(@Nullable Exception e) {
        if (CHECKS) {
            Checks.checkState((!this.isComplete() ? 1 : 0) != 0, (Object)"Promise has already been completed");
        }
        this.result = null;
        this.exception = e;
        Object object = this.next;
        if (object instanceof NextPromise) {
            NextPromise cb = (NextPromise)object;
            cb.acceptNext(null, this.exception);
        } else {
            object = this.next;
            if (object instanceof Callback) {
                Callback cb = (Callback)object;
                cb.accept(null, this.exception);
            } else {
                object = this.next;
                if (object instanceof Object[]) {
                    Object[] list = (Object[])object;
                    for (int i = 0; i < list.length; ++i) {
                        Object it = list[i];
                        if (it instanceof NextPromise) {
                            NextPromise cb = (NextPromise)it;
                            cb.acceptNext(null, this.exception);
                            continue;
                        }
                        ((Callback)it).accept(null, this.exception);
                    }
                }
            }
        }
        if (RESET_CALLBACKS) {
            this.next = null;
        }
    }

    protected boolean tryComplete(@Nullable T value, @Nullable Exception e) {
        if (!this.isComplete()) {
            this.complete(value, e);
            return true;
        }
        return false;
    }

    protected boolean tryComplete(@Nullable T value) {
        if (!this.isComplete()) {
            this.complete(value);
            return true;
        }
        return false;
    }

    protected boolean tryCompleteExceptionally(Exception e) {
        if (!this.isComplete()) {
            this.completeExceptionally(e);
            return true;
        }
        return false;
    }

    @Override
    public <U> Promise<U> map(final FunctionEx<? super T, ? extends U> fn) {
        if (this.isComplete()) {
            try {
                return this.isResult() ? Promise.of(fn.apply(this.result)) : this;
            }
            catch (Exception ex) {
                FatalErrorHandler.handleError((Throwable)ex, (Object)this);
                return Promise.ofException(ex);
            }
        }
        NextPromise resultPromise = new NextPromise<T, U>(){

            @Override
            public void acceptNext(T result, @Nullable Exception e) {
                if (e == null) {
                    Object newResult;
                    try {
                        newResult = fn.apply(result);
                    }
                    catch (Exception ex) {
                        FatalErrorHandler.handleError((Throwable)ex, (Object)this);
                        this.completeExceptionally(ex);
                        return;
                    }
                    this.complete(newResult);
                } else {
                    this.completeExceptionally(e);
                }
            }

            @Override
            public String describe() {
                return ".map(" + AbstractPromise.formatToString(fn) + ")";
            }
        };
        this.next0(resultPromise);
        return resultPromise;
    }

    @Override
    public <U> Promise<U> map(final BiFunctionEx<? super T, Exception, ? extends U> fn) {
        if (this.isComplete()) {
            try {
                return Promise.of(fn.apply(this.result, (Object)this.exception));
            }
            catch (Exception ex) {
                FatalErrorHandler.handleError((Throwable)ex, (Object)this);
                return Promise.ofException(ex);
            }
        }
        NextPromise resultPromise = new NextPromise<T, U>(){

            @Override
            public void acceptNext(T result, Exception e) {
                Object newResult;
                try {
                    newResult = fn.apply(result, (Object)e);
                }
                catch (Exception ex) {
                    FatalErrorHandler.handleError((Throwable)ex, (Object)this);
                    this.completeExceptionally(ex);
                    return;
                }
                this.complete(newResult);
            }

            @Override
            public String describe() {
                return ".map(" + AbstractPromise.formatToString(fn) + ")";
            }
        };
        this.next0(resultPromise);
        return resultPromise;
    }

    @Override
    public <U> Promise<U> map(final FunctionEx<? super T, ? extends U> fn, final FunctionEx<Exception, ? extends U> exceptionFn) {
        if (this.isComplete()) {
            try {
                return Promise.of(this.exception == null ? fn.apply(this.result) : exceptionFn.apply((Object)this.exception));
            }
            catch (Exception ex) {
                FatalErrorHandler.handleError((Throwable)ex, (Object)this);
                return Promise.ofException(ex);
            }
        }
        NextPromise resultPromise = new NextPromise<T, U>(){

            @Override
            public void acceptNext(T result, Exception e) {
                Object newResult;
                try {
                    newResult = e == null ? fn.apply(result) : exceptionFn.apply((Object)e);
                }
                catch (Exception ex) {
                    FatalErrorHandler.handleError((Throwable)ex, (Object)this);
                    this.completeExceptionally(ex);
                    return;
                }
                this.complete(newResult);
            }

            @Override
            public String describe() {
                return ".map(" + AbstractPromise.formatToString(fn) + ", " + AbstractPromise.formatToString(exceptionFn) + ")";
            }
        };
        this.next0(resultPromise);
        return resultPromise;
    }

    @Override
    public Promise<T> mapException(final FunctionEx<Exception, Exception> exceptionFn) {
        if (this.isComplete()) {
            try {
                return this.exception == null ? this : Promise.ofException((Exception)exceptionFn.apply((Object)this.exception));
            }
            catch (Exception ex) {
                FatalErrorHandler.handleError((Throwable)ex, (Object)this);
                return Promise.ofException(ex);
            }
        }
        NextPromise resultPromise = new NextPromise<T, T>(){

            @Override
            public void acceptNext(T result, @Nullable Exception e) {
                if (e == null) {
                    this.complete(result);
                } else {
                    try {
                        e = (Exception)exceptionFn.apply((Object)e);
                    }
                    catch (Exception ex) {
                        FatalErrorHandler.handleError((Throwable)ex, (Object)this);
                        this.completeExceptionally(ex);
                        return;
                    }
                    this.completeExceptionally(e);
                }
            }

            @Override
            public String describe() {
                return ".mapException(" + AbstractPromise.formatToString(exceptionFn) + ")";
            }
        };
        this.next0(resultPromise);
        return resultPromise;
    }

    @Override
    public <E extends Exception> Promise<T> mapException(final Class<E> clazz, final FunctionEx<? super E, ? extends Exception> exceptionFn) {
        if (this.isComplete()) {
            try {
                return this.exception == null ? this : (clazz.isAssignableFrom(this.exception.getClass()) ? Promise.ofException((Exception)exceptionFn.apply((Object)this.exception)) : this);
            }
            catch (Exception ex) {
                FatalErrorHandler.handleError((Throwable)ex, (Object)this);
                return Promise.ofException(ex);
            }
        }
        NextPromise resultPromise = new NextPromise<T, T>(){

            @Override
            public void acceptNext(T result, @Nullable Exception e) {
                if (e == null) {
                    this.complete(result);
                } else {
                    try {
                        e = clazz.isAssignableFrom(e.getClass()) ? (Exception)exceptionFn.apply((Object)e) : e;
                    }
                    catch (Exception ex) {
                        FatalErrorHandler.handleError((Throwable)ex, (Object)this);
                        this.completeExceptionally(ex);
                        return;
                    }
                    this.completeExceptionally(e);
                }
            }

            @Override
            public String describe() {
                return ".mapException(" + clazz.getName() + ", " + AbstractPromise.formatToString(exceptionFn) + ")";
            }
        };
        this.next0(resultPromise);
        return resultPromise;
    }

    @Override
    public <U> Promise<U> then(final AsyncSupplierEx<U> fn) {
        if (this.isComplete()) {
            try {
                return this.isResult() ? fn.get() : this;
            }
            catch (Exception ex) {
                FatalErrorHandler.handleError((Throwable)ex, (Object)this);
                return Promise.ofException(ex);
            }
        }
        NextPromise resultPromise = new NextPromise<T, U>(){

            @Override
            public void acceptNext(T result, @Nullable Exception e) {
                if (e == null) {
                    Promise promise;
                    try {
                        promise = fn.get();
                    }
                    catch (Exception ex) {
                        FatalErrorHandler.handleError((Throwable)ex, (Object)this);
                        this.completeExceptionally(ex);
                        return;
                    }
                    promise.subscribe(this);
                } else {
                    this.completeExceptionally(e);
                }
            }

            @Override
            public String describe() {
                return ".then(" + AbstractPromise.formatToString(fn) + ")";
            }
        };
        this.next0(resultPromise);
        return resultPromise;
    }

    @Override
    public <U> Promise<U> thenCallback(final CallbackSupplierEx<U> fn) {
        if (this.isComplete()) {
            try {
                return this.isResult() ? Promise.ofCallback(fn) : this;
            }
            catch (Exception ex) {
                FatalErrorHandler.handleError((Throwable)ex, (Object)this);
                return Promise.ofException(ex);
            }
        }
        NextPromise resultPromise = new NextPromise<T, U>(){

            @Override
            public void acceptNext(T result, @Nullable Exception e) {
                if (e == null) {
                    try {
                        fn.get(this);
                    }
                    catch (Exception ex) {
                        FatalErrorHandler.handleError((Throwable)ex, (Object)this);
                        this.completeExceptionally(ex);
                    }
                } else {
                    this.completeExceptionally(e);
                }
            }

            @Override
            public String describe() {
                return ".then(" + AbstractPromise.formatToString(fn) + ")";
            }
        };
        this.next0(resultPromise);
        return resultPromise;
    }

    @Override
    public <U> Promise<U> then(final AsyncFunctionEx<? super T, U> fn) {
        if (this.isComplete()) {
            try {
                return this.isResult() ? fn.apply(this.result) : this;
            }
            catch (Exception ex) {
                FatalErrorHandler.handleError((Throwable)ex, (Object)this);
                return Promise.ofException(ex);
            }
        }
        NextPromise resultPromise = new NextPromise<T, U>(){

            @Override
            public void acceptNext(T result, @Nullable Exception e) {
                if (e == null) {
                    Promise promise;
                    try {
                        promise = fn.apply(result);
                    }
                    catch (Exception ex) {
                        FatalErrorHandler.handleError((Throwable)ex, (Object)this);
                        this.completeExceptionally(ex);
                        return;
                    }
                    promise.subscribe(this);
                } else {
                    this.completeExceptionally(e);
                }
            }

            @Override
            public String describe() {
                return ".then(" + AbstractPromise.formatToString(fn) + ")";
            }
        };
        this.next0(resultPromise);
        return resultPromise;
    }

    @Override
    public <U> Promise<U> thenCallback(final CallbackFunctionEx<? super T, U> fn) {
        if (this.isComplete()) {
            try {
                return this.isResult() ? Promise.ofCallback(this.result, fn) : this;
            }
            catch (Exception ex) {
                FatalErrorHandler.handleError((Throwable)ex, (Object)this);
                return Promise.ofException(ex);
            }
        }
        NextPromise resultPromise = new NextPromise<T, U>(){

            @Override
            public void acceptNext(T result, @Nullable Exception e) {
                if (e == null) {
                    try {
                        fn.apply(result, this);
                    }
                    catch (Exception ex) {
                        FatalErrorHandler.handleError((Throwable)ex, (Object)this);
                        this.completeExceptionally(ex);
                    }
                } else {
                    this.completeExceptionally(e);
                }
            }

            @Override
            public String describe() {
                return ".then(" + AbstractPromise.formatToString(fn) + ")";
            }
        };
        this.next0(resultPromise);
        return resultPromise;
    }

    @Override
    public <U> Promise<U> then(final AsyncBiFunctionEx<? super T, Exception, U> fn) {
        if (this.isComplete()) {
            try {
                return fn.apply(this.result, this.exception);
            }
            catch (Exception ex) {
                FatalErrorHandler.handleError((Throwable)ex, (Object)this);
                return Promise.ofException(ex);
            }
        }
        NextPromise resultPromise = new NextPromise<T, U>(){

            @Override
            public void acceptNext(T result, @Nullable Exception e) {
                if (e == null) {
                    Promise promise;
                    try {
                        promise = fn.apply(result, null);
                    }
                    catch (Exception ex) {
                        FatalErrorHandler.handleError((Throwable)ex, (Object)this);
                        this.completeExceptionally(ex);
                        return;
                    }
                    promise.subscribe(this);
                } else {
                    Promise promise;
                    try {
                        promise = fn.apply(null, e);
                    }
                    catch (Exception ex) {
                        FatalErrorHandler.handleError((Throwable)ex, (Object)this);
                        this.completeExceptionally(ex);
                        return;
                    }
                    promise.subscribe(this);
                }
            }

            @Override
            public String describe() {
                return ".then(" + AbstractPromise.formatToString(fn) + ")";
            }
        };
        this.next0(resultPromise);
        return resultPromise;
    }

    @Override
    public <U> Promise<U> thenCallback(final CallbackBiFunctionEx<? super T, @Nullable Exception, U> fn) {
        if (this.isComplete()) {
            try {
                return Promise.ofCallback(this.result, this.exception, fn);
            }
            catch (Exception ex) {
                FatalErrorHandler.handleError((Throwable)ex, (Object)this);
                return Promise.ofException(ex);
            }
        }
        NextPromise resultPromise = new NextPromise<T, U>(){

            @Override
            public void acceptNext(T result, @Nullable Exception e) {
                if (e == null) {
                    try {
                        fn.apply(result, null, this);
                    }
                    catch (Exception ex) {
                        FatalErrorHandler.handleError((Throwable)ex, (Object)this);
                        this.completeExceptionally(ex);
                    }
                } else {
                    try {
                        fn.apply(null, e, this);
                    }
                    catch (Exception ex) {
                        FatalErrorHandler.handleError((Throwable)ex, (Object)this);
                        this.completeExceptionally(ex);
                    }
                }
            }

            @Override
            public String describe() {
                return ".then(" + AbstractPromise.formatToString(fn) + ")";
            }
        };
        this.next0(resultPromise);
        return resultPromise;
    }

    @Override
    public <U> Promise<U> then(final AsyncFunctionEx<? super T, U> fn, final AsyncFunctionEx<Exception, U> exceptionFn) {
        if (this.isComplete()) {
            try {
                return this.exception == null ? fn.apply(this.result) : exceptionFn.apply(this.exception);
            }
            catch (Exception ex) {
                FatalErrorHandler.handleError((Throwable)ex, (Object)this);
                return Promise.ofException(ex);
            }
        }
        NextPromise resultPromise = new NextPromise<T, U>(){

            @Override
            public void acceptNext(T result, @Nullable Exception e) {
                if (e == null) {
                    Promise promise;
                    try {
                        promise = fn.apply(result);
                    }
                    catch (Exception ex) {
                        FatalErrorHandler.handleError((Throwable)ex, (Object)this);
                        this.completeExceptionally(ex);
                        return;
                    }
                    promise.subscribe(this);
                } else {
                    Promise promise;
                    try {
                        promise = exceptionFn.apply(e);
                    }
                    catch (Exception ex) {
                        FatalErrorHandler.handleError((Throwable)ex, (Object)this);
                        this.completeExceptionally(ex);
                        return;
                    }
                    promise.subscribe(this);
                }
            }

            @Override
            public String describe() {
                return ".then(" + AbstractPromise.formatToString(fn) + ", " + AbstractPromise.formatToString(exceptionFn) + ")";
            }
        };
        this.next0(resultPromise);
        return resultPromise;
    }

    @Override
    public <U> Promise<U> thenCallback(final CallbackFunctionEx<? super T, U> fn, final CallbackFunctionEx<Exception, U> exceptionFn) {
        if (this.isComplete()) {
            try {
                return Promise.ofCallback(this.result, this.exception, fn, exceptionFn);
            }
            catch (Exception ex) {
                FatalErrorHandler.handleError((Throwable)ex, (Object)this);
                return Promise.ofException(ex);
            }
        }
        NextPromise resultPromise = new NextPromise<T, U>(){

            @Override
            public void acceptNext(T result, @Nullable Exception e) {
                if (e == null) {
                    try {
                        fn.apply(result, this);
                    }
                    catch (Exception ex) {
                        FatalErrorHandler.handleError((Throwable)ex, (Object)this);
                        this.completeExceptionally(ex);
                    }
                } else {
                    try {
                        exceptionFn.apply(e, this);
                    }
                    catch (Exception ex) {
                        FatalErrorHandler.handleError((Throwable)ex, (Object)this);
                        this.completeExceptionally(ex);
                    }
                }
            }

            @Override
            public String describe() {
                return ".then(" + AbstractPromise.formatToString(fn) + ", " + AbstractPromise.formatToString(exceptionFn) + ")";
            }
        };
        this.next0(resultPromise);
        return resultPromise;
    }

    @Override
    public Promise<T> whenComplete(final BiConsumerEx<? super T, Exception> fn) {
        if (this.isComplete()) {
            try {
                fn.accept(this.result, (Object)this.exception);
            }
            catch (Exception ex) {
                FatalErrorHandler.handleError((Throwable)ex, (Object)this);
                return Promise.ofException(ex);
            }
            return this;
        }
        NextPromise resultPromise = new NextPromise<T, T>(){

            @Override
            public void acceptNext(T result, @Nullable Exception e) {
                try {
                    fn.accept(result, (Object)e);
                }
                catch (Exception ex) {
                    FatalErrorHandler.handleError((Throwable)ex, (Object)this);
                    this.completeExceptionally(ex);
                    return;
                }
                this.complete(result, e);
            }

            @Override
            public String describe() {
                return ".whenComplete(" + AbstractPromise.formatToString(fn) + ")";
            }
        };
        this.next0(resultPromise);
        return resultPromise;
    }

    @Override
    public Promise<T> whenComplete(final ConsumerEx<? super T> fn, final ConsumerEx<Exception> exceptionFn) {
        if (this.isComplete()) {
            try {
                if (this.exception == null) {
                    fn.accept(this.result);
                } else {
                    exceptionFn.accept((Object)this.exception);
                }
            }
            catch (Exception ex) {
                FatalErrorHandler.handleError((Throwable)ex, (Object)this);
                return Promise.ofException(ex);
            }
            return this;
        }
        NextPromise resultPromise = new NextPromise<T, T>(){

            @Override
            public void acceptNext(T result, @Nullable Exception e) {
                try {
                    if (e == null) {
                        fn.accept(result);
                    } else {
                        exceptionFn.accept((Object)e);
                    }
                }
                catch (Exception ex) {
                    FatalErrorHandler.handleError((Throwable)ex, (Object)this);
                    this.completeExceptionally(ex);
                    return;
                }
                this.complete(result, e);
            }

            @Override
            public String describe() {
                return ".whenComplete(" + AbstractPromise.formatToString(fn) + ", " + AbstractPromise.formatToString(exceptionFn) + ")";
            }
        };
        this.next0(resultPromise);
        return resultPromise;
    }

    @Override
    public Promise<T> whenComplete(final RunnableEx action) {
        if (this.isComplete()) {
            try {
                action.run();
            }
            catch (Exception ex) {
                FatalErrorHandler.handleError((Throwable)ex, (Object)this);
                return Promise.ofException(ex);
            }
            return this;
        }
        NextPromise resultPromise = new NextPromise<T, T>(){

            @Override
            public void acceptNext(T result, @Nullable Exception e) {
                try {
                    action.run();
                }
                catch (Exception ex) {
                    FatalErrorHandler.handleError((Throwable)ex, (Object)this);
                    this.completeExceptionally(ex);
                    return;
                }
                this.complete(result, e);
            }

            @Override
            public String describe() {
                return ".whenComplete(" + AbstractPromise.formatToString(action) + ")";
            }
        };
        this.next0(resultPromise);
        return resultPromise;
    }

    @Override
    public Promise<T> whenResult(final ConsumerEx<? super T> fn) {
        if (this.isComplete()) {
            if (this.isResult()) {
                try {
                    fn.accept(this.result);
                }
                catch (Exception ex) {
                    FatalErrorHandler.handleError((Throwable)ex, (Object)this);
                    return Promise.ofException(ex);
                }
            }
            return this;
        }
        NextPromise resultPromise = new NextPromise<T, T>(){

            @Override
            public void acceptNext(T result, @Nullable Exception e) {
                if (e == null) {
                    try {
                        fn.accept(result);
                    }
                    catch (Exception ex) {
                        FatalErrorHandler.handleError((Throwable)ex, (Object)this);
                        this.completeExceptionally(ex);
                        return;
                    }
                    this.complete(result);
                } else {
                    this.completeExceptionally(e);
                }
            }

            @Override
            public String describe() {
                return ".whenResult(" + AbstractPromise.formatToString(fn) + ")";
            }
        };
        this.next0(resultPromise);
        return resultPromise;
    }

    @Override
    public Promise<T> whenResult(final RunnableEx action) {
        if (this.isComplete()) {
            if (this.isResult()) {
                try {
                    action.run();
                }
                catch (Exception ex) {
                    FatalErrorHandler.handleError((Throwable)ex, (Object)this);
                    return Promise.ofException(ex);
                }
            }
            return this;
        }
        NextPromise resultPromise = new NextPromise<T, T>(){

            @Override
            public void acceptNext(T result, @Nullable Exception e) {
                if (e == null) {
                    try {
                        action.run();
                    }
                    catch (Exception ex) {
                        FatalErrorHandler.handleError((Throwable)ex, (Object)this);
                        this.completeExceptionally(ex);
                        return;
                    }
                    this.complete(result);
                } else {
                    this.completeExceptionally(e);
                }
            }

            @Override
            public String describe() {
                return ".whenResult(" + AbstractPromise.formatToString(action) + ")";
            }
        };
        this.next0(resultPromise);
        return resultPromise;
    }

    @Override
    public Promise<T> whenException(final ConsumerEx<Exception> fn) {
        if (this.isComplete()) {
            if (this.isException()) {
                try {
                    fn.accept((Object)this.exception);
                }
                catch (Exception ex) {
                    FatalErrorHandler.handleError((Throwable)ex, (Object)this);
                    return Promise.ofException(ex);
                }
            }
            return this;
        }
        NextPromise resultPromise = new NextPromise<T, T>(){

            @Override
            public void acceptNext(T result, @Nullable Exception e) {
                if (e == null) {
                    this.complete(result);
                } else {
                    try {
                        fn.accept((Object)e);
                    }
                    catch (Exception ex) {
                        FatalErrorHandler.handleError((Throwable)ex, (Object)this);
                        this.completeExceptionally(ex);
                        return;
                    }
                    this.completeExceptionally(e);
                }
            }

            @Override
            public String describe() {
                return ".whenException(" + AbstractPromise.formatToString(fn) + ")";
            }
        };
        this.next0(resultPromise);
        return resultPromise;
    }

    @Override
    public <E extends Exception> Promise<T> whenException(final Class<E> clazz, final ConsumerEx<? super E> fn) {
        if (this.isComplete()) {
            try {
                if (this.exception != null && clazz.isAssignableFrom(this.exception.getClass())) {
                    fn.accept((Object)this.exception);
                }
                return this;
            }
            catch (Exception ex) {
                FatalErrorHandler.handleError((Throwable)ex, (Object)this);
                return Promise.ofException(ex);
            }
        }
        NextPromise resultPromise = new NextPromise<T, T>(){

            @Override
            public void acceptNext(T result1, @Nullable Exception e) {
                try {
                    if (e != null && clazz.isAssignableFrom(e.getClass())) {
                        fn.accept((Object)e);
                    }
                }
                catch (Exception ex) {
                    FatalErrorHandler.handleError((Throwable)ex, (Object)this);
                    this.completeExceptionally(ex);
                    return;
                }
                this.complete(result1, e);
            }

            @Override
            public String describe() {
                return ".whenException(" + clazz.getName() + ", " + AbstractPromise.formatToString(fn) + ")";
            }
        };
        this.next0(resultPromise);
        return resultPromise;
    }

    @Override
    public Promise<T> whenException(final RunnableEx action) {
        if (this.isComplete()) {
            if (this.isException()) {
                try {
                    action.run();
                }
                catch (Exception ex) {
                    FatalErrorHandler.handleError((Throwable)ex, (Object)this);
                    return Promise.ofException(ex);
                }
            }
            return this;
        }
        NextPromise resultPromise = new NextPromise<T, T>(){

            @Override
            public void acceptNext(T result, @Nullable Exception e) {
                if (e == null) {
                    this.complete(result);
                } else {
                    try {
                        action.run();
                    }
                    catch (Exception ex) {
                        FatalErrorHandler.handleError((Throwable)ex, (Object)this);
                        this.completeExceptionally(ex);
                        return;
                    }
                    this.completeExceptionally(e);
                }
            }

            @Override
            public String describe() {
                return ".whenException(" + AbstractPromise.formatToString(action) + ")";
            }
        };
        this.next0(resultPromise);
        return resultPromise;
    }

    @Override
    public Promise<T> whenException(final Class<? extends Exception> clazz, final RunnableEx action) {
        if (this.isComplete()) {
            try {
                if (this.exception != null && clazz.isAssignableFrom(this.exception.getClass())) {
                    action.run();
                }
                return this;
            }
            catch (Exception ex) {
                FatalErrorHandler.handleError((Throwable)ex, (Object)this);
                return Promise.ofException(ex);
            }
        }
        NextPromise resultPromise = new NextPromise<T, T>(){

            @Override
            public void acceptNext(T result, @Nullable Exception e) {
                try {
                    if (e != null && clazz.isAssignableFrom(e.getClass())) {
                        action.run();
                    }
                }
                catch (Exception ex) {
                    FatalErrorHandler.handleError((Throwable)ex, (Object)this);
                    this.completeExceptionally(ex);
                    return;
                }
                this.complete(result, e);
            }

            @Override
            public String describe() {
                return ".whenException(" + clazz.getName() + ", " + AbstractPromise.formatToString(action) + ")";
            }
        };
        this.next0(resultPromise);
        return resultPromise;
    }

    @Override
    public Promise<T> async() {
        if (this.isComplete()) {
            SettablePromise promise = new SettablePromise();
            Reactor.getCurrentReactor().post(this.exception == null ? () -> promise.set(this.result) : () -> promise.setException(this.exception));
            return promise;
        }
        return this;
    }

    @Override
    public <U, V> Promise<V> combine(Promise<? extends U> other, BiFunctionEx<? super T, ? super U, ? extends V> fn) {
        if (this.isComplete()) {
            if (this.isResult()) {
                return other.map(otherResult -> fn.apply(this.getResult(), otherResult)).whenException(() -> Recyclers.recycle(this.getResult()));
            }
            other.whenResult(Recyclers::recycle);
            return this;
        }
        if (other.isComplete()) {
            if (other.isResult()) {
                return this.map(result -> fn.apply(result, other.getResult())).whenException(() -> Recyclers.recycle(other.getResult()));
            }
            this.whenResult(Recyclers::recycle);
            return other;
        }
        PromiseCombine<? super T, ? extends V, ? super U> resultPromise = new PromiseCombine<T, V, U>(fn);
        other.subscribe(resultPromise::acceptOther);
        this.next0(resultPromise);
        return resultPromise;
    }

    @Override
    public Promise<Void> both(Promise<?> other) {
        if (this.isComplete()) {
            if (this.isResult()) {
                Recyclers.recycle(this.getResult());
                return other.map(AbstractPromise::recycleToVoid);
            }
            other.whenResult(Recyclers::recycle);
            return this;
        }
        if (other.isComplete()) {
            if (other.isResult()) {
                Recyclers.recycle(other.getResult());
                return this.map(AbstractPromise::recycleToVoid);
            }
            this.whenResult(Recyclers::recycle);
            return other;
        }
        PromiseBoth resultPromise = new PromiseBoth();
        other.next(resultPromise);
        this.next0(resultPromise);
        return resultPromise;
    }

    @Nullable
    protected static Void recycleToVoid(Object item) {
        Recyclers.recycle((Object)item);
        return null;
    }

    @Override
    public Promise<T> either(Promise<? extends T> other) {
        if (this.isComplete()) {
            if (this.isResult()) {
                other.whenResult(Recyclers::recycle);
                return this;
            }
            return other;
        }
        if (other.isComplete()) {
            if (other.isResult()) {
                this.whenResult(Recyclers::recycle);
                return other;
            }
            return this;
        }
        EitherPromise resultPromise = new EitherPromise();
        other.next(resultPromise);
        this.next0(resultPromise);
        return resultPromise;
    }

    @Override
    public Promise<Try<T>> toTry() {
        if (this.isComplete()) {
            return Promise.of(this.isResult() ? Try.of(this.result) : Try.ofException((Exception)this.exception));
        }
        NextPromise resultPromise = new NextPromise<T, Try<T>>(){

            @Override
            public void acceptNext(T result, @Nullable Exception e) {
                if (e == null) {
                    this.complete(Try.of(result));
                } else {
                    this.complete(Try.ofException((Exception)e));
                }
            }

            @Override
            public String describe() {
                return ".toTry()";
            }
        };
        this.next0(resultPromise);
        return resultPromise;
    }

    @Override
    public Promise<Void> toVoid() {
        if (this.isComplete()) {
            return this.isResult() ? Promise.complete() : this;
        }
        NextPromise resultPromise = new NextPromise<T, Void>(){

            @Override
            public void acceptNext(T result, @Nullable Exception e) {
                if (e == null) {
                    this.complete(null);
                } else {
                    this.completeExceptionally(e);
                }
            }

            @Override
            public String describe() {
                return ".toVoid()";
            }
        };
        this.next0(resultPromise);
        return resultPromise;
    }

    @Override
    public void next(NextPromise<? super T, ?> cb) {
        if (this.isComplete()) {
            cb.acceptNext(this.result, this.exception);
            return;
        }
        this.next0(cb);
    }

    @Async.Schedule
    private void next0(NextPromise<? super T, ?> callback) {
        assert (!this.isComplete());
        if (this.next == null) {
            this.next = callback;
        } else {
            Object object = this.next;
            if (object instanceof Object[]) {
                Object[] array = (Object[])object;
                array = Arrays.copyOf(array, array.length + 1);
                array[array.length - 1] = callback;
                this.next = array;
            } else {
                Object[] array = new Object[]{this.next, callback};
                this.next = array;
            }
        }
    }

    @Override
    public Promise<T> subscribe(Callback<? super T> cb) {
        if (this.isComplete()) {
            cb.accept(this.result, this.exception);
            return this;
        }
        if (cb instanceof NextPromise) {
            cb = (arg_0, arg_1) -> cb.accept(arg_0, arg_1);
        }
        if (this.next == null) {
            this.next = cb;
        } else {
            Object object = this.next;
            if (object instanceof Object[]) {
                Object[] array = (Object[])object;
                array = Arrays.copyOf(array, array.length + 1);
                array[array.length - 1] = cb;
                this.next = array;
            } else {
                Object[] array = new Object[]{this.next, cb};
                this.next = array;
            }
        }
        return this;
    }

    @Override
    public CompletableFuture<T> toCompletableFuture() {
        if (this.isComplete()) {
            if (this.isResult()) {
                return CompletableFuture.completedFuture(this.result);
            }
            CompletableFuture future = new CompletableFuture();
            future.completeExceptionally(this.exception);
            return future;
        }
        final CompletableFuture future = new CompletableFuture();
        this.subscribe(new Callback<T>(){

            public void accept(T result, @Nullable Exception e) {
                if (e == null) {
                    future.complete(result);
                } else {
                    future.completeExceptionally(e);
                }
            }

            public String toString() {
                return ".toCompletableFuture()";
            }
        });
        return future;
    }

    private static <T> void appendChildren(StringBuilder sb, Object callback, String indent) {
        if (callback == null) {
            return;
        }
        if (callback instanceof Object[]) {
            Object[] nextCallbacks;
            for (Object nextCallback : nextCallbacks = (Object[])callback) {
                AbstractPromise.appendChildren(sb, nextCallback, (String)indent);
                if (nextCallback != null) {
                    continue;
                }
                break;
            }
        } else {
            indent = (String)indent + "\t";
            sb.append("\n");
            if (callback instanceof AbstractPromise) {
                sb.append(((AbstractPromise)callback).toString((String)indent));
            } else {
                sb.append((String)indent + callback);
            }
        }
    }

    private static String formatToString(Object object) {
        return PACKAGE_NAME_AND_LAMBDA_PART.matcher(object.toString()).replaceAll("$1");
    }

    private String toString(String indent) {
        StringBuilder sb = new StringBuilder(indent);
        sb.append(this.describe());
        if (this.isComplete()) {
            sb.append('{');
            if (this.exception == null) {
                sb.append(this.result);
            } else {
                sb.append("exception=");
                sb.append(this.exception.getClass().getSimpleName());
            }
            sb.append('}');
        }
        AbstractPromise.appendChildren(sb, this.next, indent);
        return sb.toString();
    }

    protected String describe() {
        return "AbstractPromise";
    }

    public String toString() {
        return this.toString("");
    }

    static {
        Recyclers.register(AbstractPromise.class, promise -> promise.whenResult(Recyclers::recycle));
        CHECKS = Checks.isEnabled(AbstractPromise.class);
        PROMISE_NOT_SET = new Object();
        RESET_CALLBACKS = ApplicationSettings.getBoolean(AbstractPromise.class, (String)"resetCallbacks", (Boolean)false);
        NO_RESULT = new Object();
        PACKAGE_NAME_AND_LAMBDA_PART = Pattern.compile("^(?:\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.)*((?:\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*?)\\$\\$Lambda\\$\\d+)/.*$");
    }

    public static class PromiseCombine<T, V, U>
    extends NextPromise<T, V> {
        final BiFunctionEx<? super T, ? super U, ? extends V> fn;
        @Nullable
        T thisResult = NO_RESULT;
        @Nullable
        U otherResult = NO_RESULT;

        PromiseCombine(BiFunctionEx<? super T, ? super U, ? extends V> fn) {
            this.fn = fn;
        }

        @Override
        public void acceptNext(T result, @Nullable Exception e) {
            if (e == null) {
                if (this.otherResult != NO_RESULT) {
                    this.onBothResults(result, this.otherResult);
                } else {
                    this.thisResult = result;
                }
            } else {
                this.onAnyException(e);
            }
        }

        public void acceptOther(U result, @Nullable Exception e) {
            if (e == null) {
                if (this.thisResult != NO_RESULT) {
                    this.onBothResults(this.thisResult, result);
                } else {
                    this.otherResult = result;
                }
            } else {
                this.onAnyException(e);
            }
        }

        void onBothResults(@Nullable T thisResult, @Nullable U otherResult) {
            try {
                this.tryComplete(this.fn.apply(thisResult, otherResult));
            }
            catch (Exception e) {
                FatalErrorHandler.handleError((Throwable)e, this.fn);
                this.tryCompleteExceptionally(e);
            }
        }

        void onAnyException(Exception e) {
            if (this.tryCompleteExceptionally(e)) {
                if (this.thisResult != NO_RESULT) {
                    Recyclers.recycle(this.thisResult);
                }
                if (this.otherResult != NO_RESULT) {
                    Recyclers.recycle(this.otherResult);
                }
            }
        }

        @Override
        public String describe() {
            return ".combine(" + AbstractPromise.formatToString(this.fn) + ")";
        }
    }

    public static class PromiseBoth<T>
    extends NextPromise<T, Void> {
        int counter = 2;

        @Override
        public void acceptNext(T result, @Nullable Exception e) {
            if (e == null) {
                Recyclers.recycle(result);
                if (--this.counter == 0) {
                    this.complete(null);
                }
            } else {
                this.tryCompleteExceptionally(e);
            }
        }

        @Override
        public String describe() {
            return ".both()";
        }
    }

    public static final class EitherPromise<T>
    extends NextPromise<T, T> {
        int errors = 2;

        @Override
        public void acceptNext(T result, @Nullable Exception e) {
            if (e == null) {
                if (!this.tryComplete(result)) {
                    Recyclers.recycle(result);
                }
            } else if (--this.errors == 0) {
                this.completeExceptionally(new Exception("Both promises completed exceptionally"));
            }
        }

        @Override
        public String describe() {
            return ".either()";
        }
    }
}

