/*
 * Decompiled with CFR 0.152.
 */
package io.activej.async.process;

import io.activej.async.function.AsyncSupplier;
import io.activej.common.exception.FatalErrorHandler;
import io.activej.promise.Promise;
import java.util.concurrent.Callable;
import java.util.concurrent.RejectedExecutionException;

public interface AsyncExecutor {
    public <T> Promise<T> execute(AsyncSupplier<T> var1) throws RejectedExecutionException;

    default public Promise<Void> run(Runnable runnable) throws RejectedExecutionException {
        return this.execute(() -> {
            runnable.run();
            return Promise.complete();
        });
    }

    default public <T> Promise<T> call(Callable<T> callable) throws RejectedExecutionException {
        return this.execute(() -> {
            Object result;
            try {
                result = callable.call();
            }
            catch (Exception e) {
                FatalErrorHandler.handleError((Throwable)e, (Object)this);
                return Promise.ofException(e);
            }
            return Promise.of(result);
        });
    }
}

