/*
 * Decompiled with CFR 0.152.
 */
package io.activej.async.process;

import io.activej.async.process.AsyncCloseable;
import io.activej.common.recycle.Recyclers;
import io.activej.promise.Promise;
import io.activej.reactor.ImplicitlyReactive;
import io.activej.reactor.Reactive;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractAsyncCloseable
extends ImplicitlyReactive
implements AsyncCloseable {
    @Nullable
    private AsyncCloseable closeable;
    private Exception exception;

    public Exception getException() {
        return this.exception;
    }

    @Nullable
    public AsyncCloseable getCloseable() {
        return this.closeable;
    }

    public final void setCloseable(@Nullable AsyncCloseable closeable) {
        this.closeable = closeable;
    }

    protected void onClosed(Exception e) {
    }

    protected void onCleanup() {
    }

    @Override
    public final void closeEx(Exception e) {
        Reactive.checkInReactorThread((Reactive)this);
        if (this.isClosed()) {
            return;
        }
        this.exception = e;
        this.reactor.post(this::onCleanup);
        this.onClosed(e);
        if (this.closeable != null) {
            this.closeable.closeEx(e);
            this.closeable = null;
        }
    }

    public final boolean isClosed() {
        return this.exception != null;
    }

    public final <T> Promise<T> sanitize(Promise<T> promise) {
        return promise.async().then(this::doSanitize);
    }

    protected final <T> Promise<T> doSanitize(T value, @Nullable Exception e) {
        if (this.exception != null) {
            Recyclers.recycle(value);
            if (value instanceof AsyncCloseable) {
                ((AsyncCloseable)value).closeEx(this.exception);
            }
            return Promise.ofException(this.exception);
        }
        if (e == null) {
            return Promise.of(value);
        }
        this.closeEx(e);
        return Promise.ofException(e);
    }
}

