/*
 * Decompiled with CFR 0.152.
 */
package io.activej.async.function;

import io.activej.async.function.AsyncFunction;
import io.activej.async.function.AsyncSupplier;
import io.activej.async.process.AsyncExecutor;
import io.activej.async.process.AsyncExecutors;
import io.activej.promise.Promise;
import io.activej.promise.Promises;
import java.util.ArrayDeque;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public final class AsyncSuppliers {
    @Contract(pure=true)
    public static <T> AsyncSupplier<T> reuse(final AsyncSupplier<? extends T> actual) {
        return new AsyncSupplier<T>(){
            @Nullable
            Promise<T> runningPromise;

            @Override
            public Promise<T> get() {
                if (this.runningPromise != null) {
                    return this.runningPromise;
                }
                this.runningPromise = actual.get();
                Promise runningPromise = this.runningPromise;
                runningPromise.whenComplete(() -> {
                    this.runningPromise = null;
                });
                return runningPromise;
            }
        };
    }

    @Contract(pure=true)
    public static <T> AsyncSupplier<T> coalesce(AsyncSupplier<T> actual) {
        AsyncFunction fn = Promises.coalesce(() -> null, (a, v) -> {}, a -> actual.get());
        return () -> fn.apply(null);
    }

    @Contract(pure=true)
    public static <T> AsyncSupplier<T> buffer(AsyncSupplier<T> actual) {
        return AsyncSuppliers.buffer(1, Integer.MAX_VALUE, actual);
    }

    @Contract(pure=true)
    public static <T> AsyncSupplier<T> buffer(int maxParallelCalls, int maxBufferedCalls, AsyncSupplier<T> actualSupplier) {
        return AsyncSuppliers.ofExecutor(AsyncExecutors.buffered(maxParallelCalls, maxBufferedCalls), actualSupplier);
    }

    @Contract(pure=true)
    public static <T> AsyncSupplier<T> ofExecutor(AsyncExecutor executor, AsyncSupplier<T> supplier) {
        return () -> executor.execute(supplier);
    }

    @Contract(pure=true)
    public static <T> AsyncSupplier<T> prefetch(int count, AsyncSupplier<? extends T> supplier) {
        return AsyncSuppliers.prefetch(count, supplier, supplier);
    }

    @Contract(pure=true)
    public static <T> AsyncSupplier<T> prefetch(final int count, final AsyncSupplier<? extends T> actualSupplier, final AsyncSupplier<? extends T> prefetchSupplier) {
        if (count == 0) {
            return actualSupplier;
        }
        return new AsyncSupplier<T>(){
            final ArrayDeque<T> prefetched = new ArrayDeque();
            int prefetchCalls;

            @Override
            public Promise<T> get() {
                Promise result = this.prefetched.isEmpty() ? actualSupplier.get() : Promise.of(this.prefetched.pollFirst());
                this.prefetch();
                return result;
            }

            void prefetch() {
                for (int i = 0; i < count - (this.prefetched.size() + this.prefetchCalls); ++i) {
                    ++this.prefetchCalls;
                    prefetchSupplier.get().async().subscribe((value, e) -> {
                        --this.prefetchCalls;
                        if (e == null) {
                            this.prefetched.addLast(value);
                        }
                    });
                }
            }
        };
    }
}

