/*
 * Decompiled with CFR 0.152.
 */
package io.activej.async.function;

import io.activej.async.function.AsyncSupplierEx;
import io.activej.common.exception.FatalErrorHandler;
import io.activej.common.function.SupplierEx;
import io.activej.promise.Promise;

@FunctionalInterface
public interface AsyncSupplier<T>
extends AsyncSupplierEx<T> {
    @Override
    public Promise<T> get();

    public static <T> AsyncSupplier<T> of(SupplierEx<T> supplier) {
        return () -> {
            try {
                return Promise.of(supplier.get());
            }
            catch (Exception e) {
                FatalErrorHandler.handleError((Throwable)e, (Object)supplier);
                return Promise.ofException(e);
            }
        };
    }

    public static <T> AsyncSupplier<T> sanitize(AsyncSupplierEx<T> supplier) {
        return () -> {
            try {
                return supplier.get();
            }
            catch (Exception e) {
                FatalErrorHandler.handleError((Throwable)e, (Object)supplier);
                return Promise.ofException(e);
            }
        };
    }
}

