/*
 * Decompiled with CFR 0.152.
 */
package io.activej.async.function;

import io.activej.async.function.AsyncFunction;
import io.activej.async.function.AsyncRunnable;
import io.activej.async.process.AsyncExecutor;
import io.activej.async.process.AsyncExecutors;
import io.activej.promise.Promise;
import io.activej.promise.Promises;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public final class AsyncRunnables {
    @Contract(pure=true)
    public static AsyncRunnable reuse(final AsyncRunnable actual) {
        return new AsyncRunnable(){
            @Nullable
            Promise<Void> runningPromise;

            @Override
            public Promise<Void> run() {
                if (this.runningPromise != null) {
                    return this.runningPromise;
                }
                Promise<Void> runningPromise = this.runningPromise = actual.run();
                runningPromise.whenComplete(() -> {
                    this.runningPromise = null;
                });
                return runningPromise;
            }
        };
    }

    @Contract(pure=true)
    public static AsyncRunnable coalesce(AsyncRunnable actual) {
        AsyncFunction fn = Promises.coalesce(() -> null, (a, v) -> {}, a -> actual.run());
        return () -> fn.apply(null);
    }

    @Contract(pure=true)
    public static AsyncRunnable buffer(AsyncRunnable actual) {
        return AsyncRunnables.buffer(1, Integer.MAX_VALUE, actual);
    }

    @Contract(pure=true)
    public static AsyncRunnable buffer(int maxParallelCalls, int maxBufferedCalls, AsyncRunnable runnable) {
        return AsyncRunnables.ofExecutor(AsyncExecutors.buffered(maxParallelCalls, maxBufferedCalls), runnable);
    }

    @Contract(pure=true)
    public static AsyncRunnable ofExecutor(AsyncExecutor executor, AsyncRunnable runnable) {
        return () -> executor.execute(runnable::run);
    }
}

