/*
 * Decompiled with CFR 0.152.
 */
package io.activej.async.function;

import io.activej.async.function.AsyncRunnableEx;
import io.activej.common.exception.FatalErrorHandler;
import io.activej.common.function.RunnableEx;
import io.activej.promise.Promise;

@FunctionalInterface
public interface AsyncRunnable
extends AsyncRunnableEx {
    @Override
    public Promise<Void> run();

    public static AsyncRunnable of(RunnableEx runnable) {
        return () -> {
            try {
                runnable.run();
            }
            catch (Exception e) {
                FatalErrorHandler.handleError((Throwable)e, (Object)runnable);
                return Promise.ofException(e);
            }
            return Promise.complete();
        };
    }

    public static AsyncRunnable sanitize(AsyncRunnableEx runnable) {
        return () -> {
            try {
                return runnable.run();
            }
            catch (Exception e) {
                FatalErrorHandler.handleError((Throwable)e, (Object)runnable);
                return Promise.ofException(e);
            }
        };
    }
}

