/*
 * Decompiled with CFR 0.152.
 */
package io.activej.async.function;

import io.activej.async.AsyncAccumulator;
import io.activej.async.function.AsyncPredicate;
import io.activej.async.process.AsyncExecutor;
import io.activej.async.process.AsyncExecutors;
import io.activej.common.ref.RefBoolean;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Contract;

public final class AsyncPredicates {
    @Contract(pure=true)
    public static <T> AsyncPredicate<T> buffer(AsyncPredicate<T> actual) {
        return AsyncPredicates.buffer(1, Integer.MAX_VALUE, actual);
    }

    @Contract(pure=true)
    public static <T> AsyncPredicate<T> buffer(int maxParallelCalls, int maxBufferedCalls, AsyncPredicate<T> predicate) {
        return AsyncPredicates.ofExecutor(AsyncExecutors.buffered(maxParallelCalls, maxBufferedCalls), predicate);
    }

    @Contract(pure=true)
    public static <T> AsyncPredicate<T> ofExecutor(AsyncExecutor executor, AsyncPredicate<T> predicate) {
        return t -> executor.execute(() -> predicate.test(t));
    }

    public static <T> AsyncPredicate<T> and(Collection<AsyncPredicate<? super T>> predicates) {
        return t -> {
            AsyncAccumulator<RefBoolean> accumulator = AsyncAccumulator.create(new RefBoolean(true));
            for (AsyncPredicate predicate : predicates) {
                accumulator.addPromise(predicate.test(t), (ref, result) -> ref.set(ref.get() && result != false));
            }
            return accumulator.run().map(RefBoolean::get);
        };
    }

    public static <T> AsyncPredicate<T> and() {
        return AsyncPredicate.alwaysTrue();
    }

    public static <T> AsyncPredicate<T> and(AsyncPredicate<? super T> predicate1) {
        return predicate1;
    }

    public static <T> AsyncPredicate<T> and(AsyncPredicate<? super T> predicate1, AsyncPredicate<? super T> predicate2) {
        return predicate1.and(predicate2);
    }

    @SafeVarargs
    public static <T> AsyncPredicate<T> and(AsyncPredicate<? super T> ... predicates) {
        return AsyncPredicates.and(List.of(predicates));
    }

    public static <T> AsyncPredicate<T> or(Collection<AsyncPredicate<? super T>> predicates) {
        return t -> {
            AsyncAccumulator<RefBoolean> accumulator = AsyncAccumulator.create(new RefBoolean(false));
            for (AsyncPredicate predicate : predicates) {
                accumulator.addPromise(predicate.test(t), (ref, result) -> ref.set(ref.get() || result != false));
            }
            return accumulator.run().map(RefBoolean::get);
        };
    }

    public static <T> AsyncPredicate<T> or() {
        return AsyncPredicate.alwaysFalse();
    }

    public static <T> AsyncPredicate<T> or(AsyncPredicate<? super T> predicate1) {
        return predicate1;
    }

    public static <T> AsyncPredicate<T> or(AsyncPredicate<? super T> predicate1, AsyncPredicate<? super T> predicate2) {
        return predicate1.or(predicate2);
    }

    @SafeVarargs
    public static <T> AsyncPredicate<T> or(AsyncPredicate<? super T> ... predicates) {
        return AsyncPredicates.or(List.of(predicates));
    }
}

