/*
 * Decompiled with CFR 0.152.
 */
package io.activej.async.function;

import io.activej.async.function.AsyncPredicateEx;
import io.activej.common.exception.FatalErrorHandler;
import io.activej.common.function.PredicateEx;
import io.activej.promise.Promise;

@FunctionalInterface
public interface AsyncPredicate<T>
extends AsyncPredicateEx<T> {
    @Override
    public Promise<Boolean> test(T var1);

    public static <T> AsyncPredicate<T> of(PredicateEx<T> predicate) {
        return value -> {
            try {
                return Promise.of(predicate.test(value));
            }
            catch (Exception e) {
                FatalErrorHandler.handleError((Throwable)e, (Object)predicate);
                return Promise.ofException(e);
            }
        };
    }

    public static <T> AsyncPredicate<T> sanitize(AsyncPredicateEx<T> predicate) {
        return value -> {
            try {
                return predicate.test(value);
            }
            catch (Exception e) {
                FatalErrorHandler.handleError((Throwable)e, (Object)predicate);
                return Promise.ofException(e);
            }
        };
    }

    public static <T> AsyncPredicate<T> alwaysTrue() {
        return t -> Promise.of(Boolean.TRUE);
    }

    public static <T> AsyncPredicate<T> alwaysFalse() {
        return t -> Promise.of(Boolean.FALSE);
    }

    public static <T> AsyncPredicate<T> not(AsyncPredicate<? super T> predicate) {
        return predicate.negate();
    }

    default public AsyncPredicate<T> negate() {
        return t -> this.test(t).map(b -> b == false);
    }

    default public AsyncPredicate<T> and(AsyncPredicate<? super T> other) {
        return t -> this.test(t).combine(other.test(t), (b1, b2) -> b1 != false && b2 != false);
    }

    default public AsyncPredicate<T> or(AsyncPredicate<? super T> other) {
        return t -> this.test(t).combine(other.test(t), (b1, b2) -> b1 != false || b2 != false);
    }
}

