/*
 * Decompiled with CFR 0.152.
 */
package io.activej.async.function;

import io.activej.async.function.AsyncFunction;
import io.activej.async.process.AsyncExecutor;
import io.activej.async.process.AsyncExecutors;
import org.jetbrains.annotations.Contract;

public final class AsyncFunctions {
    @Contract(pure=true)
    public static <T, R> AsyncFunction<T, R> buffer(AsyncFunction<T, R> actual) {
        return AsyncFunctions.buffer(1, Integer.MAX_VALUE, actual);
    }

    @Contract(pure=true)
    public static <T, R> AsyncFunction<T, R> buffer(int maxParallelCalls, int maxBufferedCalls, AsyncFunction<T, R> function) {
        return AsyncFunctions.ofExecutor(AsyncExecutors.buffered(maxParallelCalls, maxBufferedCalls), function);
    }

    @Contract(pure=true)
    public static <T, R> AsyncFunction<T, R> ofExecutor(AsyncExecutor executor, AsyncFunction<T, R> function) {
        return t -> executor.execute(() -> function.apply(t));
    }
}

