/*
 * Decompiled with CFR 0.152.
 */
package io.activej.async.function;

import io.activej.async.function.AsyncFunctionEx;
import io.activej.common.exception.FatalErrorHandler;
import io.activej.common.function.FunctionEx;
import io.activej.promise.Promise;

@FunctionalInterface
public interface AsyncFunction<T, R>
extends AsyncFunctionEx<T, R> {
    @Override
    public Promise<R> apply(T var1);

    public static <T, R> AsyncFunction<T, R> of(FunctionEx<? super T, ? extends R> function) {
        return value -> {
            try {
                return Promise.of(function.apply(value));
            }
            catch (Exception e) {
                FatalErrorHandler.handleError((Throwable)e, (Object)function);
                return Promise.ofException(e);
            }
        };
    }

    public static <T, R> AsyncFunction<T, R> sanitize(AsyncFunctionEx<? super T, R> function) {
        return value -> {
            try {
                return function.apply(value);
            }
            catch (Exception e) {
                FatalErrorHandler.handleError((Throwable)e, (Object)function);
                return Promise.ofException(e);
            }
        };
    }
}

