/*
 * Decompiled with CFR 0.152.
 */
package io.activej.async.function;

import io.activej.async.function.AsyncConsumerEx;
import io.activej.common.exception.FatalErrorHandler;
import io.activej.common.function.ConsumerEx;
import io.activej.promise.Promise;

@FunctionalInterface
public interface AsyncConsumer<T>
extends AsyncConsumerEx<T> {
    @Override
    public Promise<Void> accept(T var1);

    public static <T> AsyncConsumer<T> of(ConsumerEx<? super T> consumer) {
        return value -> {
            try {
                consumer.accept(value);
            }
            catch (Exception e) {
                FatalErrorHandler.handleError((Throwable)e, (Object)consumer);
                return Promise.ofException(e);
            }
            return Promise.complete();
        };
    }

    public static <T> AsyncConsumer<T> sanitize(AsyncConsumerEx<? super T> consumer) {
        return value -> {
            try {
                return consumer.accept(value);
            }
            catch (Exception e) {
                FatalErrorHandler.handleError((Throwable)e, (Object)consumer);
                return Promise.ofException(e);
            }
        };
    }
}

