/*
 * Decompiled with CFR 0.152.
 */
package io.activej.async.function;

import io.activej.async.AsyncAccumulator;
import io.activej.async.function.AsyncBiPredicate;
import io.activej.async.process.AsyncExecutor;
import io.activej.async.process.AsyncExecutors;
import io.activej.common.ref.RefBoolean;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Contract;

public final class AsyncBiPredicates {
    @Contract(pure=true)
    public static <T, U> AsyncBiPredicate<T, U> buffer(AsyncBiPredicate<T, U> actual) {
        return AsyncBiPredicates.buffer(1, Integer.MAX_VALUE, actual);
    }

    @Contract(pure=true)
    public static <T, U> AsyncBiPredicate<T, U> buffer(int maxParallelCalls, int maxBufferedCalls, AsyncBiPredicate<T, U> predicate) {
        return AsyncBiPredicates.ofExecutor(AsyncExecutors.buffered(maxParallelCalls, maxBufferedCalls), predicate);
    }

    @Contract(pure=true)
    public static <T, U> AsyncBiPredicate<T, U> ofExecutor(AsyncExecutor executor, AsyncBiPredicate<T, U> predicate) {
        return (t, u) -> executor.execute(() -> predicate.test(t, u));
    }

    public static <T, U> AsyncBiPredicate<T, U> and(Collection<AsyncBiPredicate<? super T, ? super U>> predicates) {
        return (t, u) -> {
            AsyncAccumulator<RefBoolean> accumulator = AsyncAccumulator.create(new RefBoolean(true));
            for (AsyncBiPredicate predicate : predicates) {
                accumulator.addPromise(predicate.test(t, u), (ref, result) -> ref.set(ref.get() && result != false));
            }
            return accumulator.run().map(RefBoolean::get);
        };
    }

    public static <T, U> AsyncBiPredicate<T, U> and() {
        return AsyncBiPredicate.alwaysTrue();
    }

    public static <T, U> AsyncBiPredicate<T, U> and(AsyncBiPredicate<? super T, ? super U> predicate1) {
        return predicate1;
    }

    public static <T, U> AsyncBiPredicate<T, U> and(AsyncBiPredicate<? super T, ? super U> predicate1, AsyncBiPredicate<? super T, ? super U> predicate2) {
        return predicate1.and(predicate2);
    }

    @SafeVarargs
    public static <T, U> AsyncBiPredicate<T, U> and(AsyncBiPredicate<? super T, ? super U> ... predicates) {
        return AsyncBiPredicates.and(List.of(predicates));
    }

    public static <T, U> AsyncBiPredicate<T, U> or(Collection<AsyncBiPredicate<? super T, ? super U>> predicates) {
        return (t, u) -> {
            AsyncAccumulator<RefBoolean> accumulator = AsyncAccumulator.create(new RefBoolean(false));
            for (AsyncBiPredicate predicate : predicates) {
                accumulator.addPromise(predicate.test(t, u), (ref, result) -> ref.set(ref.get() || result != false));
            }
            return accumulator.run().map(RefBoolean::get);
        };
    }

    public static <T, U> AsyncBiPredicate<T, U> or() {
        return AsyncBiPredicate.alwaysFalse();
    }

    public static <T, U> AsyncBiPredicate<T, U> or(AsyncBiPredicate<? super T, ? super U> predicate1) {
        return predicate1;
    }

    public static <T, U> AsyncBiPredicate<T, U> or(AsyncBiPredicate<? super T, ? super U> predicate1, AsyncBiPredicate<? super T, ? super U> predicate2) {
        return predicate1.or(predicate2);
    }

    @SafeVarargs
    public static <T, U> AsyncBiPredicate<T, U> or(AsyncBiPredicate<? super T, ? super U> ... predicates) {
        return AsyncBiPredicates.or(List.of(predicates));
    }
}

