/*
 * Decompiled with CFR 0.152.
 */
package io.activej.async.function;

import io.activej.async.function.AsyncBiPredicateEx;
import io.activej.common.exception.FatalErrorHandler;
import io.activej.common.function.BiPredicateEx;
import io.activej.promise.Promise;

@FunctionalInterface
public interface AsyncBiPredicate<T, U>
extends AsyncBiPredicateEx<T, U> {
    @Override
    public Promise<Boolean> test(T var1, U var2);

    public static <T, U> AsyncBiPredicate<T, U> of(BiPredicateEx<? super T, ? super U> predicate) {
        return (t, u) -> {
            try {
                return Promise.of(predicate.test(t, u));
            }
            catch (Exception e) {
                FatalErrorHandler.handleError((Throwable)e, (Object)predicate);
                return Promise.ofException(e);
            }
        };
    }

    public static <T, U> AsyncBiPredicate<T, U> sanitize(AsyncBiPredicateEx<? super T, ? super U> predicate) {
        return (t, u) -> {
            try {
                return predicate.test(t, u);
            }
            catch (Exception e) {
                FatalErrorHandler.handleError((Throwable)e, (Object)predicate);
                return Promise.ofException(e);
            }
        };
    }

    public static <T, U> AsyncBiPredicate<T, U> alwaysTrue() {
        return (t, u) -> Promise.of(Boolean.TRUE);
    }

    public static <T, U> AsyncBiPredicate<T, U> alwaysFalse() {
        return (t, u) -> Promise.of(Boolean.FALSE);
    }

    public static <T, U> AsyncBiPredicate<T, U> not(AsyncBiPredicate<? super T, ? super U> predicate) {
        return predicate.negate();
    }

    default public AsyncBiPredicate<T, U> negate() {
        return (t, u) -> this.test(t, u).map(b -> b == false);
    }

    default public AsyncBiPredicate<T, U> and(AsyncBiPredicate<? super T, ? super U> other) {
        return (t, u) -> this.test(t, u).combine(other.test(t, u), (b1, b2) -> b1 != false && b2 != false);
    }

    default public AsyncBiPredicate<T, U> or(AsyncBiPredicate<? super T, ? super U> other) {
        return (t, u) -> this.test(t, u).combine(other.test(t, u), (b1, b2) -> b1 != false || b2 != false);
    }
}

