/*
 * Decompiled with CFR 0.152.
 */
package io.activej.async.function;

import io.activej.async.function.AsyncBiFunction;
import io.activej.async.process.AsyncExecutor;
import io.activej.async.process.AsyncExecutors;
import org.jetbrains.annotations.Contract;

public final class AsyncBiFunctions {
    @Contract(pure=true)
    public static <T, U, R> AsyncBiFunction<T, U, R> buffer(AsyncBiFunction<T, U, R> actual) {
        return AsyncBiFunctions.buffer(1, Integer.MAX_VALUE, actual);
    }

    @Contract(pure=true)
    public static <T, U, R> AsyncBiFunction<T, U, R> buffer(int maxParallelCalls, int maxBufferedCalls, AsyncBiFunction<T, U, R> function) {
        return AsyncBiFunctions.ofExecutor(AsyncExecutors.buffered(maxParallelCalls, maxBufferedCalls), function);
    }

    @Contract(pure=true)
    public static <T, U, R> AsyncBiFunction<T, U, R> ofExecutor(AsyncExecutor executor, AsyncBiFunction<T, U, R> function) {
        return (t, u) -> executor.execute(() -> function.apply(t, u));
    }
}

