/*
 * Decompiled with CFR 0.152.
 */
package io.activej.async.function;

import io.activej.async.function.AsyncBiFunctionEx;
import io.activej.common.exception.FatalErrorHandler;
import io.activej.common.function.BiFunctionEx;
import io.activej.promise.Promise;

@FunctionalInterface
public interface AsyncBiFunction<T, U, R>
extends AsyncBiFunctionEx<T, U, R> {
    @Override
    public Promise<R> apply(T var1, U var2);

    public static <T, U, R> AsyncBiFunction<T, U, R> of(BiFunctionEx<? super T, ? super U, ? extends R> function) {
        return (t, u) -> {
            try {
                return Promise.of(function.apply(t, u));
            }
            catch (Exception e) {
                FatalErrorHandler.handleError((Throwable)e, (Object)function);
                return Promise.ofException(e);
            }
        };
    }

    public static <T, U, R> AsyncBiFunction<T, U, R> sanitize(AsyncBiFunctionEx<? super T, ? super U, R> function) {
        return (t, u) -> {
            try {
                return function.apply(t, u);
            }
            catch (Exception e) {
                FatalErrorHandler.handleError((Throwable)e, (Object)function);
                return Promise.ofException(e);
            }
        };
    }
}

