/*
 * Decompiled with CFR 0.152.
 */
package io.activej.async.function;

import io.activej.async.function.AsyncBiConsumerEx;
import io.activej.common.exception.FatalErrorHandler;
import io.activej.common.function.BiConsumerEx;
import io.activej.promise.Promise;

@FunctionalInterface
public interface AsyncBiConsumer<T, U>
extends AsyncBiConsumerEx<T, U> {
    @Override
    public Promise<Void> accept(T var1, U var2);

    public static <T, U> AsyncBiConsumer<T, U> of(BiConsumerEx<? super T, ? super U> consumer) {
        return (t, u) -> {
            try {
                consumer.accept(t, u);
            }
            catch (Exception e) {
                FatalErrorHandler.handleError((Throwable)e, (Object)consumer);
                return Promise.ofException(e);
            }
            return Promise.complete();
        };
    }

    public static <T, U> AsyncBiConsumer<T, U> sanitize(AsyncBiConsumerEx<? super T, U> consumer) {
        return (t, u) -> {
            try {
                return consumer.accept(t, u);
            }
            catch (Exception e) {
                FatalErrorHandler.handleError((Throwable)e, (Object)consumer);
                return Promise.ofException(e);
            }
        };
    }
}

