/*
 * Decompiled with CFR 0.152.
 */
package io.activej.async.file;

import io.activej.async.file.IFileService;
import io.activej.common.Checks;
import io.activej.promise.Promise;
import io.activej.reactor.AbstractReactive;
import io.activej.reactor.Reactive;
import io.activej.reactor.Reactor;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.Executor;

public final class ExecutorFileService
extends AbstractReactive
implements IFileService {
    private static final boolean CHECKS = Checks.isEnabled(ExecutorFileService.class);
    private final Executor executor;

    public ExecutorFileService(Reactor reactor, Executor executor) {
        super(reactor);
        this.executor = executor;
    }

    @Override
    public Promise<Integer> read(FileChannel channel, long position, byte[] array, int offset, int size) {
        if (CHECKS) {
            Reactive.checkInReactorThread((Reactive)this);
        }
        return Promise.ofBlocking(this.executor, () -> {
            int readBytes;
            ByteBuffer buffer = ByteBuffer.wrap(array, offset, size);
            long pos = position;
            while ((readBytes = channel.read(buffer, pos)) != -1) {
                pos += (long)readBytes;
                if (buffer.position() < buffer.limit()) continue;
            }
            return Math.toIntExact(pos - position);
        });
    }

    @Override
    public Promise<Integer> write(FileChannel channel, long position, byte[] array, int offset, int size) {
        if (CHECKS) {
            Reactive.checkInReactorThread((Reactive)this);
        }
        return Promise.ofBlocking(this.executor, () -> {
            ByteBuffer buffer = ByteBuffer.wrap(array, offset, size);
            long pos = position;
            do {
                pos += (long)channel.write(buffer, pos);
            } while (buffer.position() < buffer.limit());
            return Math.toIntExact(pos - position);
        });
    }
}

