/*
 * Decompiled with CFR 0.152.
 */
package io.activej.async;

import io.activej.async.process.AsyncCloseable;
import io.activej.common.Checks;
import io.activej.common.builder.AbstractBuilder;
import io.activej.common.exception.FatalErrorHandler;
import io.activej.common.function.BiConsumerEx;
import io.activej.common.recycle.Recyclers;
import io.activej.promise.Promise;
import io.activej.promise.SettablePromise;
import io.activej.reactor.ImplicitlyReactive;
import io.activej.reactor.Reactive;
import org.jetbrains.annotations.Nullable;

public final class AsyncAccumulator<A>
extends ImplicitlyReactive
implements AsyncCloseable {
    private static final boolean CHECKS = Checks.isEnabled(AsyncAccumulator.class);
    private final SettablePromise<A> resultPromise = new SettablePromise();
    private boolean started;
    private final A accumulator;
    private int activePromises;

    private AsyncAccumulator(@Nullable A accumulator) {
        this.accumulator = accumulator;
    }

    public static <A> AsyncAccumulator<A> create(@Nullable A accumulator) {
        return (AsyncAccumulator)AsyncAccumulator.builder(accumulator).build();
    }

    public static <A> Builder builder(@Nullable A accumulator) {
        return new AsyncAccumulator<A>(accumulator).new Builder();
    }

    public Promise<A> run() {
        Reactive.checkInReactorThread((Reactive)this);
        Checks.checkState((!this.started ? 1 : 0) != 0);
        this.started = true;
        if (this.resultPromise.isComplete()) {
            return this.resultPromise;
        }
        if (this.activePromises == 0) {
            this.resultPromise.set(this.accumulator);
        }
        return this.resultPromise;
    }

    public Promise<A> run(Promise<Void> runtimePromise) {
        Reactive.checkInReactorThread((Reactive)this);
        this.addPromise(runtimePromise, (result, v) -> {});
        return this.run();
    }

    public <T> void addPromise(Promise<T> promise, BiConsumerEx<A, T> consumer) {
        if (CHECKS) {
            Reactive.checkInReactorThread((Reactive)this);
        }
        if (this.resultPromise.isComplete()) {
            promise.whenResult(Recyclers::recycle);
            return;
        }
        ++this.activePromises;
        promise.subscribe((v, e) -> {
            --this.activePromises;
            if (this.resultPromise.isComplete()) {
                Recyclers.recycle((Object)v);
                return;
            }
            if (e == null) {
                try {
                    consumer.accept(this.accumulator, v);
                }
                catch (Exception ex) {
                    FatalErrorHandler.handleError((Throwable)ex, (Object)this);
                    this.resultPromise.setException(ex);
                    Recyclers.recycle(this.accumulator);
                    return;
                }
                if (this.activePromises == 0 && this.started) {
                    this.resultPromise.set(this.accumulator);
                }
            } else {
                this.resultPromise.setException(e);
                Recyclers.recycle(this.accumulator);
            }
        });
    }

    public <V> SettablePromise<V> newPromise(BiConsumerEx<A, V> consumer) {
        if (CHECKS) {
            Reactive.checkInReactorThread((Reactive)this);
        }
        SettablePromise resultPromise = new SettablePromise();
        this.addPromise(resultPromise, consumer);
        return resultPromise;
    }

    public Promise<A> get() {
        return this.resultPromise;
    }

    public A getAccumulator() {
        return this.accumulator;
    }

    public int getActivePromises() {
        return this.activePromises;
    }

    public void complete() {
        Reactive.checkInReactorThread((Reactive)this);
        this.resultPromise.trySet(this.accumulator);
    }

    public void complete(A result) {
        Reactive.checkInReactorThread((Reactive)this);
        if (this.resultPromise.trySet(result) && result != this.accumulator) {
            Recyclers.recycle(this.accumulator);
        }
    }

    @Override
    public void closeEx(Exception e) {
        Reactive.checkInReactorThread((Reactive)this);
        if (this.resultPromise.trySetException(e)) {
            Recyclers.recycle(this.accumulator);
        }
    }

    public final class Builder
    extends AbstractBuilder<Builder, AsyncAccumulator<A>> {
        private Builder() {
        }

        public <T> Builder withPromise(Promise<T> promise, BiConsumerEx<A, T> accumulator) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            AsyncAccumulator.this.addPromise(promise, accumulator);
            return this;
        }

        protected AsyncAccumulator<A> doBuild() {
            return AsyncAccumulator.this;
        }
    }
}

