/*
 * Decompiled with CFR 0.152.
 */
package io.activej.net.socket.udp;

import io.activej.async.exception.AsyncCloseException;
import io.activej.bytebuf.ByteBuf;
import io.activej.bytebuf.ByteBufPool;
import io.activej.common.Checks;
import io.activej.common.MemSize;
import io.activej.common.inspector.AbstractInspector;
import io.activej.common.inspector.BaseInspector;
import io.activej.common.recycle.Recyclers;
import io.activej.common.tuple.Tuple2;
import io.activej.jmx.api.attribute.JmxAttribute;
import io.activej.jmx.stats.EventStats;
import io.activej.jmx.stats.ValueStats;
import io.activej.net.socket.udp.IUdpSocket;
import io.activej.net.socket.udp.UdpPacket;
import io.activej.promise.Promise;
import io.activej.promise.SettableCallback;
import io.activej.reactor.AbstractNioReactive;
import io.activej.reactor.Reactive;
import io.activej.reactor.nio.NioChannelEventHandler;
import io.activej.reactor.nio.NioReactor;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.time.Duration;
import java.util.ArrayDeque;
import org.jetbrains.annotations.Nullable;

public final class UdpSocket
extends AbstractNioReactive
implements IUdpSocket,
NioChannelEventHandler {
    private static final boolean CHECKS = Checks.isEnabled(UdpSocket.class);
    private static final int OP_POSTPONED = 128;
    private static final MemSize DEFAULT_UDP_BUFFER_SIZE = MemSize.kilobytes((long)16L);
    @Nullable
    private SelectionKey key;
    private int receiveBufferSize = DEFAULT_UDP_BUFFER_SIZE.toInt();
    private final DatagramChannel channel;
    private final ArrayDeque<SettableCallback<UdpPacket>> readQueue = new ArrayDeque();
    private final ArrayDeque<UdpPacket> readBuffer = new ArrayDeque();
    private final ArrayDeque<Tuple2<UdpPacket, SettableCallback<Void>>> writeQueue = new ArrayDeque();
    private int ops = 0;
    @Nullable
    private Inspector inspector;

    private UdpSocket(NioReactor reactor, DatagramChannel channel) throws IOException {
        super(reactor);
        this.channel = channel;
        this.key = channel.register(reactor.ensureSelector(), 0, this);
    }

    public static Promise<UdpSocket> connect(NioReactor reactor, DatagramChannel channel) {
        try {
            return Promise.of((Object)new UdpSocket(reactor, channel));
        }
        catch (IOException e) {
            return Promise.ofException((Exception)e);
        }
    }

    public void setInspector(@Nullable Inspector inspector) {
        this.inspector = inspector;
    }

    public void setReceiveBufferSize(int receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
    }

    public boolean isOpen() {
        return this.key != null;
    }

    @Override
    public Promise<UdpPacket> receive() {
        if (CHECKS) {
            Reactive.checkInReactorThread((Reactive)this);
        }
        if (!this.isOpen()) {
            return Promise.ofException((Exception)new AsyncCloseException());
        }
        UdpPacket polled = this.readBuffer.poll();
        if (polled != null) {
            return Promise.of((Object)polled);
        }
        return Promise.ofCallback(cb -> {
            this.readQueue.add((SettableCallback<UdpPacket>)cb);
            this.readInterest(true);
        });
    }

    public void onReadReady() {
        assert (this.reactor.inReactorThread());
        while (this.isOpen()) {
            SettableCallback<UdpPacket> cb;
            InetSocketAddress sourceAddress;
            ByteBuffer buffer;
            ByteBuf buf;
            block7: {
                buf = ByteBufPool.allocate((int)this.receiveBufferSize);
                buffer = buf.toWriteByteBuffer();
                sourceAddress = null;
                try {
                    sourceAddress = (InetSocketAddress)this.channel.receive(buffer);
                }
                catch (IOException e) {
                    if (this.inspector == null) break block7;
                    this.inspector.onReceiveError(this, e);
                }
            }
            if (sourceAddress == null) {
                buf.recycle();
                break;
            }
            buf.ofWriteByteBuffer(buffer);
            UdpPacket packet = UdpPacket.of(buf, sourceAddress);
            if (this.inspector != null) {
                this.inspector.onReceive(this, packet);
            }
            if ((cb = this.readQueue.poll()) != null) {
                cb.set((Object)packet);
                return;
            }
            this.readBuffer.add(packet);
        }
    }

    @Override
    public Promise<Void> send(UdpPacket packet) {
        if (CHECKS) {
            Reactive.checkInReactorThread((Reactive)this);
        }
        if (!this.isOpen()) {
            return Promise.ofException((Exception)new AsyncCloseException());
        }
        return Promise.ofCallback(cb -> {
            this.writeQueue.add((Tuple2<UdpPacket, SettableCallback<Void>>)new Tuple2((Object)packet, (Object)cb));
            this.onWriteReady();
        });
    }

    public void onWriteReady() {
        Tuple2<UdpPacket, SettableCallback<Void>> entry;
        assert (this.reactor.inReactorThread());
        while ((entry = this.writeQueue.peek()) != null) {
            UdpPacket packet;
            block6: {
                packet = (UdpPacket)entry.value1();
                ByteBuffer buffer = packet.getBuf().toReadByteBuffer();
                try {
                    if (this.channel.send(buffer, packet.getSocketAddress()) == 0) {
                    }
                    break block6;
                }
                catch (IOException e) {
                    if (this.inspector == null) break;
                    this.inspector.onSendError(this, e);
                }
                break;
            }
            ((SettableCallback)entry.value2()).set(null);
            if (this.inspector != null) {
                this.inspector.onSend(this, packet);
            }
            this.writeQueue.poll();
            packet.recycle();
        }
        this.writeInterest(!this.writeQueue.isEmpty());
    }

    private void interests(int newOps) {
        if (this.ops != newOps) {
            this.ops = newOps;
            if ((this.ops & 0x80) == 0 && this.key != null) {
                this.key.interestOps(this.ops);
            }
        }
    }

    private void readInterest(boolean readInterest) {
        this.interests(readInterest ? this.ops | 1 : this.ops & 0xFFFFFFFE);
    }

    private void writeInterest(boolean writeInterest) {
        this.interests(writeInterest ? this.ops | 4 : this.ops & 0xFFFFFFFB);
    }

    @Override
    public void close() {
        Reactive.checkInReactorThread((Reactive)this);
        SelectionKey key = this.key;
        if (key == null) {
            return;
        }
        this.key = null;
        if (this.inspector != null) {
            this.inspector.onClose(this);
        }
        this.reactor.closeChannel((SelectableChannel)this.channel, key);
        Recyclers.recycle(this.writeQueue);
    }

    public String toString() {
        if (this.isOpen()) {
            return "UDP socket: " + this.getRemoteSocketAddress();
        }
        return "closed UDP socket";
    }

    private InetSocketAddress getRemoteSocketAddress() {
        try {
            return (InetSocketAddress)this.channel.getRemoteAddress();
        }
        catch (ClosedChannelException ignored) {
            throw new AssertionError((Object)"Channel is closed");
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static interface Inspector
    extends BaseInspector<Inspector> {
        public void onCreate(UdpSocket var1);

        public void onReceive(UdpSocket var1, UdpPacket var2);

        public void onReceiveError(UdpSocket var1, IOException var2);

        public void onSend(UdpSocket var1, UdpPacket var2);

        public void onSendError(UdpSocket var1, IOException var2);

        public void onClose(UdpSocket var1);
    }

    public static class JmxInspector
    extends AbstractInspector<Inspector>
    implements Inspector {
        private final EventStats creates;
        private final ValueStats receives;
        private final EventStats receiveErrors;
        private final ValueStats sends;
        private final EventStats sendErrors;
        private final EventStats closes;

        public JmxInspector(Duration smoothingWindow) {
            this.creates = EventStats.create((Duration)smoothingWindow);
            this.receives = (ValueStats)ValueStats.builder((Duration)smoothingWindow).withUnit("bytes").withRate().build();
            this.receiveErrors = EventStats.create((Duration)smoothingWindow);
            this.sends = (ValueStats)ValueStats.builder((Duration)smoothingWindow).withUnit("bytes").withRate().build();
            this.sendErrors = EventStats.create((Duration)smoothingWindow);
            this.closes = EventStats.create((Duration)smoothingWindow);
        }

        @Override
        public void onCreate(UdpSocket socket) {
            this.creates.recordEvent();
        }

        @Override
        public void onReceive(UdpSocket socket, UdpPacket packet) {
            this.receives.recordValue((long)packet.getBuf().readRemaining());
        }

        @Override
        public void onReceiveError(UdpSocket socket, IOException e) {
            this.receiveErrors.recordEvent();
        }

        @Override
        public void onSend(UdpSocket socket, UdpPacket packet) {
            this.sends.recordValue((long)packet.getBuf().readRemaining());
        }

        @Override
        public void onSendError(UdpSocket socket, IOException e) {
            this.sendErrors.recordEvent();
        }

        @Override
        public void onClose(UdpSocket socket) {
            this.closes.recordEvent();
        }

        @JmxAttribute
        public EventStats getCreates() {
            return this.creates;
        }

        @JmxAttribute(description="Received packet size")
        public ValueStats getReceives() {
            return this.receives;
        }

        @JmxAttribute
        public EventStats getReceiveErrors() {
            return this.receiveErrors;
        }

        @JmxAttribute(description="Sent packet size")
        public ValueStats getSends() {
            return this.sends;
        }

        @JmxAttribute
        public EventStats getSendErrors() {
            return this.sendErrors;
        }

        @JmxAttribute
        public EventStats getCloses() {
            return this.closes;
        }
    }
}

