/*
 * Decompiled with CFR 0.152.
 */
package io.activej.net.socket.tcp;

import io.activej.async.exception.AsyncCloseException;
import io.activej.bytebuf.ByteBuf;
import io.activej.bytebuf.ByteBufPool;
import io.activej.common.ApplicationSettings;
import io.activej.common.Checks;
import io.activej.common.recycle.Recyclers;
import io.activej.net.socket.tcp.ITcpSocket;
import io.activej.promise.Promise;
import io.activej.promise.SettablePromise;
import io.activej.reactor.AbstractNioReactive;
import io.activej.reactor.Reactive;
import io.activej.reactor.net.CloseWithoutNotifyException;
import io.activej.reactor.nio.NioReactor;
import java.nio.ByteBuffer;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import org.jetbrains.annotations.Nullable;

public final class SslTcpSocket
extends AbstractNioReactive
implements ITcpSocket {
    private static final boolean CHECKS = Checks.isEnabled(SslTcpSocket.class);
    public static final boolean ERROR_ON_CLOSE_WITHOUT_NOTIFY = ApplicationSettings.getBoolean(SslTcpSocket.class, (String)"errorOnCloseWithoutNotify", (Boolean)false);
    private final SSLEngine engine;
    private final Executor executor;
    private final ITcpSocket upstream;
    private ByteBuf net2engine = ByteBuf.empty();
    private ByteBuf engine2app = ByteBuf.empty();
    private ByteBuf app2engine = ByteBuf.empty();
    private boolean shouldReturnEndOfStream;
    @Nullable
    private SettablePromise<ByteBuf> read;
    @Nullable
    private SettablePromise<Void> write;
    @Nullable
    private Promise<Void> pendingUpstreamWrite;

    private SslTcpSocket(NioReactor reactor, ITcpSocket socket, SSLEngine engine, Executor executor) {
        super(reactor);
        this.engine = engine;
        this.executor = executor;
        this.upstream = socket;
        this.startHandShake();
    }

    public static SslTcpSocket wrapClientSocket(NioReactor reactor, ITcpSocket socket, String host, int port, SSLContext sslContext, Executor executor) {
        SSLEngine sslEngine = sslContext.createSSLEngine(host, port);
        sslEngine.setUseClientMode(true);
        return SslTcpSocket.create(reactor, socket, sslEngine, executor);
    }

    public static SslTcpSocket wrapClientSocket(NioReactor reactor, ITcpSocket socket, SSLContext sslContext, Executor executor) {
        SSLEngine sslEngine = sslContext.createSSLEngine();
        sslEngine.setUseClientMode(true);
        return SslTcpSocket.create(reactor, socket, sslEngine, executor);
    }

    public static SslTcpSocket wrapServerSocket(NioReactor reactor, ITcpSocket socket, SSLContext sslContext, Executor executor) {
        SSLEngine sslEngine = sslContext.createSSLEngine();
        sslEngine.setUseClientMode(false);
        return SslTcpSocket.create(reactor, socket, sslEngine, executor);
    }

    public static SslTcpSocket create(NioReactor reactor, ITcpSocket socket, SSLEngine engine, Executor executor) {
        return new SslTcpSocket(reactor, socket, engine, executor);
    }

    @Override
    public Promise<ByteBuf> read() {
        SettablePromise read;
        if (CHECKS) {
            Reactive.checkInReactorThread((Reactive)this);
        }
        this.read = null;
        if (this.shouldReturnEndOfStream) {
            this.shouldReturnEndOfStream = false;
            return Promise.of(null);
        }
        if (this.isClosed()) {
            return Promise.ofException((Exception)new AsyncCloseException());
        }
        if (this.engine2app.canRead()) {
            ByteBuf readBuf = this.engine2app;
            this.engine2app = ByteBuf.empty();
            return Promise.of((Object)readBuf);
        }
        this.read = read = new SettablePromise();
        this.sync();
        return read;
    }

    @Override
    public Promise<Void> write(@Nullable ByteBuf buf) {
        SettablePromise write;
        if (CHECKS) {
            Reactive.checkInReactorThread((Reactive)this);
        }
        if (this.isClosed()) {
            if (buf != null) {
                buf.recycle();
            }
            return Promise.ofException((Exception)new AsyncCloseException());
        }
        if (buf == null) {
            throw new UnsupportedOperationException("SSL cannot work in half-duplex mode");
        }
        if (!buf.canRead()) {
            buf.recycle();
            return this.write == null ? Promise.complete() : this.write;
        }
        this.app2engine = ByteBufPool.append((ByteBuf)this.app2engine, (ByteBuf)buf);
        if (this.write != null) {
            return this.write;
        }
        this.write = write = new SettablePromise();
        this.sync();
        return write;
    }

    @Override
    public boolean isReadAvailable() {
        return this.engine2app != null && this.engine2app.canRead();
    }

    private void doRead() {
        this.upstream.read().whenException(this::closeEx).whenResult(buf -> {
            if (this.isClosed()) {
                assert (this.pendingUpstreamWrite != null);
                Recyclers.recycle((Object)buf);
                return;
            }
            if (buf != null) {
                this.net2engine = ByteBufPool.append((ByteBuf)this.net2engine, (ByteBuf)buf);
                this.sync();
            } else {
                if (this.engine.isInboundDone()) {
                    return;
                }
                try {
                    this.engine.closeInbound();
                }
                catch (SSLException e) {
                    if (!ERROR_ON_CLOSE_WITHOUT_NOTIFY && this.read != null) {
                        SettablePromise<ByteBuf> read = this.read;
                        this.read = null;
                        read.set(null);
                    }
                    this.closeEx((Exception)new CloseWithoutNotifyException("Peer closed without sending close_notify", (Throwable)e));
                }
            }
        });
    }

    private void doWrite(ByteBuf dstBuf) {
        Promise<Void> writePromise = this.upstream.write(dstBuf);
        if (this.pendingUpstreamWrite != null) {
            return;
        }
        if (!writePromise.isComplete()) {
            this.pendingUpstreamWrite = writePromise;
        }
        writePromise.whenException(this::closeEx).whenComplete(() -> {
            this.pendingUpstreamWrite = null;
        }).whenResult(() -> {
            if (this.isClosed()) {
                return;
            }
            if (this.engine.isOutboundDone()) {
                this.close();
                return;
            }
            if (!this.app2engine.canRead() && this.engine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING && this.write != null) {
                SettablePromise<Void> write = this.write;
                this.write = null;
                write.set(null);
            }
        });
    }

    private SSLEngineResult tryToUnwrap() throws SSLException {
        SSLEngineResult result;
        ByteBuf dstBuf = ByteBufPool.allocate((int)this.engine.getSession().getPacketBufferSize());
        ByteBuffer srcBuffer = this.net2engine.toReadByteBuffer();
        ByteBuffer dstBuffer = dstBuf.toWriteByteBuffer();
        try {
            result = this.engine.unwrap(srcBuffer, dstBuffer);
        }
        catch (SSLException e) {
            dstBuf.recycle();
            throw e;
        }
        catch (RuntimeException e) {
            dstBuf.recycle();
            throw new SSLException(e);
        }
        this.net2engine.ofReadByteBuffer(srcBuffer);
        this.net2engine = SslTcpSocket.recycleIfEmpty(this.net2engine);
        dstBuf.ofWriteByteBuffer(dstBuffer);
        if (!this.isClosed() && dstBuf.canRead()) {
            this.engine2app = ByteBufPool.append((ByteBuf)this.engine2app, (ByteBuf)dstBuf);
        } else {
            dstBuf.recycle();
        }
        return result;
    }

    private SSLEngineResult tryToWrap() throws SSLException {
        SSLEngineResult result;
        ByteBuf dstBuf = ByteBufPool.allocate((int)this.engine.getSession().getPacketBufferSize());
        ByteBuffer srcBuffer = this.app2engine.toReadByteBuffer();
        ByteBuffer dstBuffer = dstBuf.toWriteByteBuffer();
        try {
            result = this.engine.wrap(srcBuffer, dstBuffer);
        }
        catch (SSLException e) {
            dstBuf.recycle();
            throw e;
        }
        catch (RuntimeException e) {
            dstBuf.recycle();
            throw new SSLException(e);
        }
        this.app2engine.ofReadByteBuffer(srcBuffer);
        this.app2engine = SslTcpSocket.recycleIfEmpty(this.app2engine);
        dstBuf.ofWriteByteBuffer(dstBuffer);
        if (dstBuf.canRead()) {
            this.doWrite(dstBuf);
        } else {
            dstBuf.recycle();
        }
        return result;
    }

    private void doHandshake() throws SSLException {
        SSLEngineResult result = null;
        while (!this.isClosed()) {
            if (result != null && result.getStatus() == SSLEngineResult.Status.CLOSED) {
                this.close();
                return;
            }
            SSLEngineResult.HandshakeStatus handshakeStatus = this.engine.getHandshakeStatus();
            if (handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
                result = this.tryToWrap();
                continue;
            }
            if (handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                result = this.tryToUnwrap();
                if (result.getStatus() != SSLEngineResult.Status.BUFFER_UNDERFLOW) continue;
                this.doRead();
                return;
            }
            if (handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                this.executeTasks();
                return;
            }
            this.doSync();
            return;
        }
    }

    private void executeTasks() {
        Runnable task;
        while (!this.isClosed() && (task = this.engine.getDelegatedTask()) != null) {
            Promise.ofBlocking((Executor)this.executor, task::run).whenResult(() -> {
                if (this.isClosed()) {
                    return;
                }
                try {
                    this.doHandshake();
                }
                catch (SSLException e) {
                    this.closeEx(e);
                }
            });
        }
    }

    private void sync() {
        try {
            this.doSync();
        }
        catch (SSLException e) {
            this.closeEx(e);
        }
    }

    private void doSync() throws SSLException {
        if (this.isClosed()) {
            return;
        }
        SSLEngineResult result = null;
        SSLEngineResult.HandshakeStatus handshakeStatus = this.engine.getHandshakeStatus();
        if (handshakeStatus != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            this.doHandshake();
            return;
        }
        if (this.app2engine.canRead()) {
            do {
                result = this.tryToWrap();
            } while (!this.isClosed() && this.app2engine.canRead() && (result.bytesConsumed() != 0 || result.bytesProduced() != 0));
        }
        if (this.isClosed()) {
            return;
        }
        if (this.net2engine.canRead()) {
            do {
                result = this.tryToUnwrap();
            } while (this.net2engine.canRead() && (result.bytesConsumed() != 0 || result.bytesProduced() != 0));
            if (result.getStatus() == SSLEngineResult.Status.CLOSED) {
                this.shouldReturnEndOfStream = true;
            }
            if (this.read != null && this.engine2app.canRead()) {
                SettablePromise<ByteBuf> read = this.read;
                this.read = null;
                ByteBuf readBuf = this.engine2app;
                this.engine2app = ByteBuf.empty();
                read.set((Object)readBuf);
            }
        }
        if (result != null && result.getStatus() == SSLEngineResult.Status.CLOSED) {
            this.close();
            return;
        }
        if (!(this.isClosed() || this.read == null && this.engine2app.canRead())) {
            this.doRead();
        }
    }

    private static ByteBuf recycleIfEmpty(ByteBuf buf) {
        if (buf.canRead()) {
            return buf;
        }
        buf.recycle();
        return ByteBuf.empty();
    }

    private void startHandShake() {
        try {
            this.engine.beginHandshake();
            this.sync();
        }
        catch (SSLException e) {
            this.closeEx(e);
        }
    }

    private void tryCloseOutbound() {
        if (!this.engine.isOutboundDone()) {
            this.engine.closeOutbound();
            try {
                SSLEngineResult result;
                while (!this.engine.isOutboundDone() && (result = this.tryToWrap()).getStatus() != SSLEngineResult.Status.CLOSED) {
                }
            }
            catch (SSLException sSLException) {
                // empty catch block
            }
        }
    }

    public void closeEx(Exception e) {
        Reactive.checkInReactorThread((Reactive)this);
        if (this.isClosed()) {
            return;
        }
        Recyclers.recycle((Object)this.net2engine);
        Recyclers.recycle((Object)this.engine2app);
        this.engine2app = null;
        this.net2engine = null;
        this.tryCloseOutbound();
        Recyclers.recycle((Object)this.app2engine);
        this.app2engine = null;
        if (this.pendingUpstreamWrite != null) {
            this.pendingUpstreamWrite.whenResult(() -> this.upstream.closeEx(e));
        } else {
            this.upstream.closeEx(e);
        }
        if (this.read != null) {
            if (this.shouldReturnEndOfStream) {
                this.shouldReturnEndOfStream = false;
                this.read.set(null);
            } else {
                this.read.setException(e);
            }
            this.read = null;
        }
        if (this.write != null) {
            this.write.setException(e);
            this.write = null;
        }
    }

    @Override
    public boolean isClosed() {
        return this.net2engine == null;
    }
}

