/*
 * Decompiled with CFR 0.152.
 */
package io.activej.net;

import io.activej.net.AbstractReactiveServer;
import io.activej.net.WorkerServer;
import io.activej.net.socket.tcp.ITcpSocket;
import io.activej.reactor.nio.NioReactor;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class PrimaryServer
extends AbstractReactiveServer {
    private final WorkerServer[] workerServers;
    private int currentAcceptor = -1;

    private PrimaryServer(NioReactor primaryReactor, WorkerServer[] workerServers) {
        super(primaryReactor);
        this.workerServers = workerServers;
        for (WorkerServer workerServer : workerServers) {
            if (!(workerServer instanceof AbstractReactiveServer)) continue;
            ((AbstractReactiveServer)workerServer).acceptServer = this;
        }
    }

    public static Builder builder(NioReactor primaryReactor, List<? extends WorkerServer> workerServers) {
        return PrimaryServer.builder(primaryReactor, workerServers.toArray(new WorkerServer[0]));
    }

    public static Builder builder(NioReactor primaryReactor, Iterable<? extends WorkerServer> workerServers) {
        ArrayList list = new ArrayList();
        workerServers.forEach(list::add);
        return PrimaryServer.builder(primaryReactor, list);
    }

    public static Builder builder(NioReactor primaryReactor, WorkerServer ... workerServer) {
        return new PrimaryServer(primaryReactor, workerServer).new Builder();
    }

    @Override
    protected void serve(ITcpSocket socket, InetAddress remoteAddress) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected WorkerServer getWorkerServer() {
        this.currentAcceptor = (this.currentAcceptor + 1) % this.workerServers.length;
        return this.workerServers[this.currentAcceptor];
    }

    @Override
    public String toString() {
        return "PrimaryServer{numOfWorkerServers=" + this.workerServers.length + (String)(this.listenAddresses.isEmpty() ? "" : ", listenAddresses=" + this.listenAddresses) + (String)(this.sslListenAddresses.isEmpty() ? "" : ", sslListenAddresses=" + this.sslListenAddresses) + (this.acceptOnce ? ", acceptOnce" : "") + ", workerServers=" + Arrays.toString(this.workerServers) + "}";
    }

    public final class Builder
    extends AbstractReactiveServer.Builder<Builder, PrimaryServer> {
        private Builder() {
        }
    }
}

