/*
 * Decompiled with CFR 0.152.
 */
package io.activej.net;

import io.activej.common.builder.AbstractBuilder;
import io.activej.common.inspector.BaseInspector;
import io.activej.jmx.api.attribute.JmxAttribute;
import io.activej.jmx.stats.EventStats;
import io.activej.net.PrimaryServer;
import io.activej.net.ReactiveServer;
import io.activej.net.WorkerServer;
import io.activej.net.socket.tcp.ITcpSocket;
import io.activej.net.socket.tcp.SslTcpSocket;
import io.activej.net.socket.tcp.TcpSocket;
import io.activej.promise.Promise;
import io.activej.promise.SettableCallback;
import io.activej.reactor.AbstractNioReactive;
import io.activej.reactor.Reactive;
import io.activej.reactor.jmx.ReactiveJmxBeanWithStats;
import io.activej.reactor.net.ServerSocketSettings;
import io.activej.reactor.net.SocketSettings;
import io.activej.reactor.nio.NioReactor;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.SelectableChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReactiveServer
extends AbstractNioReactive
implements ReactiveServer,
WorkerServer,
ReactiveJmxBeanWithStats {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected ServerSocketSettings serverSocketSettings = ServerSocketSettings.defaultInstance();
    protected SocketSettings socketSettings = SocketSettings.defaultInstance();
    protected boolean acceptOnce;
    private AcceptFilter acceptFilter;
    protected List<InetSocketAddress> listenAddresses = new ArrayList<InetSocketAddress>();
    private SSLContext sslContext;
    private Executor sslExecutor;
    protected List<InetSocketAddress> sslListenAddresses = new ArrayList<InetSocketAddress>();
    private boolean running = false;
    private List<ServerSocketChannel> serverSocketChannels;
    private List<ServerSocketChannel> sslServerSocketChannels;
    private static final Duration SMOOTHING_WINDOW = Duration.ofMinutes(1L);
    AbstractReactiveServer acceptServer = this;
    @Nullable
    private TcpSocket.Inspector socketInspector;
    @Nullable
    private TcpSocket.Inspector socketSslInspector;
    private final EventStats accepts = EventStats.create((Duration)SMOOTHING_WINDOW);
    private final EventStats acceptsSsl = EventStats.create((Duration)SMOOTHING_WINDOW);
    private final EventStats filteredAccepts = EventStats.create((Duration)SMOOTHING_WINDOW);

    protected AbstractReactiveServer(NioReactor reactor) {
        super(reactor);
    }

    protected abstract void serve(ITcpSocket var1, InetAddress var2);

    protected void onListen() {
    }

    protected void onClose(SettableCallback<Void> cb) {
        cb.set(null);
    }

    protected void onAccept(SocketChannel socketChannel, InetSocketAddress localAddress, InetAddress remoteAddress, boolean ssl) {
    }

    protected void onFilteredAccept(SocketChannel socketChannel, InetSocketAddress localAddress, InetAddress remoteAddress, boolean ssl) {
    }

    @Override
    public final void listen() throws IOException {
        Reactive.checkInReactorThread((Reactive)this);
        if (this.running) {
            return;
        }
        this.running = true;
        this.onListen();
        if (this.listenAddresses != null && !this.listenAddresses.isEmpty()) {
            this.serverSocketChannels = this.listenAddresses(this.listenAddresses, false);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Listening on {}: {}", this.getBoundAddresses(this.serverSocketChannels), (Object)this);
            }
        }
        if (this.sslListenAddresses != null && !this.sslListenAddresses.isEmpty()) {
            this.sslServerSocketChannels = this.listenAddresses(this.sslListenAddresses, true);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Listening with SSL on {}: {}", this.getBoundAddresses(this.sslServerSocketChannels), (Object)this);
            }
        }
    }

    private List<ServerSocketChannel> listenAddresses(List<InetSocketAddress> addresses, boolean ssl) throws IOException {
        ArrayList<ServerSocketChannel> channels = new ArrayList<ServerSocketChannel>(addresses.size());
        for (InetSocketAddress address : addresses) {
            try {
                channels.add(this.reactor.listen(address, this.serverSocketSettings, channel -> this.doAccept((SocketChannel)channel, address, ssl)));
            }
            catch (IOException e) {
                this.logger.error("Can't listen on [{}]: {}", new Object[]{address, this, e});
                this.closeServerSockets(channels);
                this.close();
                throw e;
            }
        }
        return channels;
    }

    @Override
    public final Promise<?> close() {
        Reactive.checkInReactorThread((Reactive)this);
        if (!this.running) {
            return Promise.complete();
        }
        this.running = false;
        this.closeServerSockets();
        return Promise.ofCallback(this::onClose).whenResult($ -> this.logger.info("Server closed: {}", (Object)this)).whenException(e -> this.logger.error("Server closed exceptionally: {}", (Object)this, e));
    }

    public final Future<?> closeFuture() {
        return this.reactor.submit(this::close);
    }

    public final boolean isRunning() {
        return this.running;
    }

    protected void closeServerSockets() {
        this.closeServerSockets(this.serverSocketChannels);
        this.closeServerSockets(this.sslServerSocketChannels);
    }

    private void closeServerSockets(List<ServerSocketChannel> channels) {
        if (channels == null || channels.isEmpty()) {
            return;
        }
        Iterator<ServerSocketChannel> it = channels.iterator();
        while (it.hasNext()) {
            ServerSocketChannel serverSocketChannel = it.next();
            if (serverSocketChannel == null) continue;
            this.reactor.closeChannel((SelectableChannel)serverSocketChannel, serverSocketChannel.keyFor(this.reactor.getSelector()));
            it.remove();
        }
    }

    protected WorkerServer getWorkerServer() {
        return this;
    }

    protected TcpSocket.Inspector getSocketInspector(InetAddress remoteAddress, InetSocketAddress localAddress, boolean ssl) {
        return ssl ? this.socketSslInspector : this.socketInspector;
    }

    private void doAccept(SocketChannel channel, InetSocketAddress localAddress, boolean ssl) {
        InetSocketAddress remoteSocketAddress;
        try {
            remoteSocketAddress = (InetSocketAddress)channel.getRemoteAddress();
        }
        catch (IOException e) {
            this.reactor.closeChannel((SelectableChannel)channel, null);
            return;
        }
        InetAddress remoteAddress = remoteSocketAddress.getAddress();
        if (this.acceptFilter != null && this.acceptFilter.filterAccept(channel, localAddress, remoteAddress, ssl)) {
            this.filteredAccepts.recordEvent();
            this.onFilteredAccept(channel, localAddress, remoteAddress, ssl);
            this.reactor.closeChannel((SelectableChannel)channel, null);
            return;
        }
        WorkerServer workerServer = this.getWorkerServer();
        NioReactor workerServerReactor = workerServer.getReactor();
        if (workerServerReactor == this.reactor) {
            workerServer.doAccept(channel, localAddress, remoteSocketAddress, ssl, this.socketSettings);
        } else {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("received connection from [{}]{}: {}", new Object[]{remoteAddress, ssl ? " over SSL" : "", this});
            }
            this.accepts.recordEvent();
            if (ssl) {
                this.acceptsSsl.recordEvent();
            }
            this.onAccept(channel, localAddress, remoteAddress, ssl);
            workerServerReactor.execute(() -> workerServer.doAccept(channel, localAddress, remoteSocketAddress, ssl, this.socketSettings));
        }
        if (this.acceptOnce) {
            this.closeServerSockets();
        }
    }

    @Override
    public final void doAccept(SocketChannel socketChannel, InetSocketAddress localAddress, InetSocketAddress remoteSocketAddress, boolean ssl, SocketSettings socketSettings) {
        TcpSocket socket;
        assert (this.reactor.inReactorThread());
        this.accepts.recordEvent();
        if (ssl) {
            this.acceptsSsl.recordEvent();
        }
        InetAddress remoteAddress = remoteSocketAddress.getAddress();
        this.onAccept(socketChannel, localAddress, remoteAddress, ssl);
        try {
            TcpSocket.Inspector inspector;
            TcpSocket tcpSocket = TcpSocket.wrapChannel(this.reactor, socketChannel, remoteSocketAddress, socketSettings);
            TcpSocket.Inspector inspector2 = inspector = ssl ? this.socketSslInspector : this.socketInspector;
            if (inspector != null) {
                inspector.onConnect(tcpSocket);
                tcpSocket.setInspector(inspector);
            }
            socket = tcpSocket;
        }
        catch (IOException e) {
            this.logger.warn("Failed to wrap channel {}", (Object)socketChannel, (Object)e);
            this.reactor.closeChannel((SelectableChannel)socketChannel, null);
            return;
        }
        socket = ssl ? SslTcpSocket.wrapServerSocket(this.reactor, socket, this.sslContext, this.sslExecutor) : socket;
        this.serve(socket, remoteAddress);
    }

    public ServerSocketSettings getServerSocketSettings() {
        return this.serverSocketSettings;
    }

    @JmxAttribute
    public List<InetSocketAddress> getListenAddresses() {
        return this.listenAddresses;
    }

    @JmxAttribute
    public List<InetSocketAddress> getSslListenAddresses() {
        return this.sslListenAddresses;
    }

    @JmxAttribute
    public List<InetSocketAddress> getBoundAddresses() {
        return this.getBoundAddresses(this.serverSocketChannels);
    }

    @JmxAttribute
    public List<InetSocketAddress> getSslBoundAddresses() {
        return this.getBoundAddresses(this.sslServerSocketChannels);
    }

    private List<InetSocketAddress> getBoundAddresses(List<ServerSocketChannel> channels) {
        if (channels == null) {
            return List.of();
        }
        return channels.stream().map(ch -> {
            try {
                return (InetSocketAddress)ch.getLocalAddress();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }).collect(Collectors.toList());
    }

    public SocketSettings getSocketSettings() {
        return this.socketSettings;
    }

    @JmxAttribute(extraSubAttributes={"totalCount"})
    @Nullable
    public final EventStats getAccepts() {
        return this.acceptServer.listenAddresses.isEmpty() ? null : this.accepts;
    }

    @JmxAttribute
    @Nullable
    public final EventStats getAcceptsSsl() {
        return this.acceptServer.sslListenAddresses.isEmpty() ? null : this.acceptsSsl;
    }

    @JmxAttribute
    @Nullable
    public final EventStats getFilteredAccepts() {
        return this.acceptFilter == null ? null : this.filteredAccepts;
    }

    @JmxAttribute
    @Nullable
    public final TcpSocket.JmxInspector getSocketStats() {
        return this instanceof PrimaryServer || this.acceptServer.listenAddresses.isEmpty() ? null : (TcpSocket.JmxInspector)BaseInspector.lookup((BaseInspector)this.socketInspector, TcpSocket.JmxInspector.class);
    }

    @JmxAttribute
    @Nullable
    public final TcpSocket.JmxInspector getSocketStatsSsl() {
        return this instanceof PrimaryServer || this.acceptServer.sslListenAddresses.isEmpty() ? null : (TcpSocket.JmxInspector)BaseInspector.lookup((BaseInspector)this.socketSslInspector, TcpSocket.JmxInspector.class);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append('{');
        boolean first = true;
        if (!this.listenAddresses.isEmpty()) {
            sb.append("listenAddresses=").append(this.listenAddresses);
            first = false;
        }
        if (!this.sslListenAddresses.isEmpty()) {
            sb.append(first ? "" : ", ").append("sslListenAddresses=").append(this.sslListenAddresses);
            first = false;
        }
        if (this.serverSocketChannels != null) {
            sb.append(first ? "" : ", ").append("boundAddresses=").append(this.getBoundAddresses());
            first = false;
        }
        if (this.sslServerSocketChannels != null) {
            sb.append(first ? "" : ", ").append("sslBoundAddresses=").append(this.getSslBoundAddresses());
            first = false;
        }
        if (this.acceptOnce) {
            sb.append(first ? "" : ", ").append("acceptOnce");
        }
        sb.append('}');
        return sb.toString();
    }

    @FunctionalInterface
    public static interface AcceptFilter {
        public boolean filterAccept(SocketChannel var1, InetSocketAddress var2, InetAddress var3, boolean var4);
    }

    public abstract class Builder<Self extends Builder<Self, S>, S extends AbstractReactiveServer>
    extends AbstractBuilder<Self, S> {
        public final Self withAcceptFilter(AcceptFilter acceptFilter) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            AbstractReactiveServer.this.acceptFilter = acceptFilter;
            return (Self)((Object)this);
        }

        public final Self withServerSocketSettings(ServerSocketSettings serverSocketSettings) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            AbstractReactiveServer.this.serverSocketSettings = serverSocketSettings;
            return (Self)((Object)this);
        }

        public final Self withSocketSettings(SocketSettings socketSettings) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            AbstractReactiveServer.this.socketSettings = socketSettings;
            return (Self)((Object)this);
        }

        public final Self withListenAddresses(List<InetSocketAddress> addresses) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            AbstractReactiveServer.this.listenAddresses = addresses;
            return (Self)((Object)this);
        }

        public final Self withListenAddresses(InetSocketAddress ... addresses) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            return this.withListenAddresses(List.of(addresses));
        }

        public final Self withListenAddress(InetSocketAddress address) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            return this.withListenAddresses(List.of(address));
        }

        public final Self withListenPort(int port) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            return this.withListenAddress(new InetSocketAddress(port));
        }

        public final Self withSslListenAddresses(SSLContext sslContext, Executor sslExecutor, List<InetSocketAddress> addresses) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            AbstractReactiveServer.this.sslContext = sslContext;
            AbstractReactiveServer.this.sslExecutor = sslExecutor;
            AbstractReactiveServer.this.sslListenAddresses = addresses;
            return (Self)((Object)this);
        }

        public final Self withSslListenAddresses(SSLContext sslContext, Executor sslExecutor, InetSocketAddress ... addresses) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            return this.withSslListenAddresses(sslContext, sslExecutor, List.of(addresses));
        }

        public final Self withSslListenAddress(SSLContext sslContext, Executor sslExecutor, InetSocketAddress address) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            return this.withSslListenAddresses(sslContext, sslExecutor, List.of(address));
        }

        public final Self withSslListenPort(SSLContext sslContext, Executor sslExecutor, int port) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            return this.withSslListenAddress(sslContext, sslExecutor, new InetSocketAddress(port));
        }

        public final Self withAcceptOnce() {
            Builder.checkNotBuilt((AbstractBuilder)this);
            return this.withAcceptOnce(true);
        }

        public final Self withAcceptOnce(boolean acceptOnce) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            AbstractReactiveServer.this.acceptOnce = acceptOnce;
            return (Self)((Object)this);
        }

        public final Self withSocketInspector(TcpSocket.Inspector socketInspector) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            AbstractReactiveServer.this.socketInspector = socketInspector;
            return (Self)((Object)this);
        }

        public final Self withSocketSslInspector(TcpSocket.Inspector socketSslInspector) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            AbstractReactiveServer.this.socketSslInspector = socketSslInspector;
            return (Self)((Object)this);
        }

        public final Self withLogger(Logger logger) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            AbstractReactiveServer.this.logger = logger;
            return (Self)((Object)this);
        }

        protected S doBuild() {
            return (S)AbstractReactiveServer.this;
        }
    }
}

