/*
 * Decompiled with CFR 0.152.
 */
package io.activej.jmx.api.attribute;

import io.activej.jmx.api.attribute.JmxReducer;
import java.time.Duration;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.ToDoubleFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.LongStream;
import org.jetbrains.annotations.Nullable;

public final class JmxReducers {
    @Nullable
    private static Number reduceNumbers(List<? extends Number> list, ToDoubleFunction<DoubleStream> opDouble, ToLongFunction<LongStream> opLong) {
        Class<?> numberClass = list.get(0).getClass();
        if (JmxReducers.isFloatingPointNumber(numberClass)) {
            return JmxReducers.convert(numberClass, opDouble.applyAsDouble(list.stream().mapToDouble(Number::doubleValue)));
        }
        if (JmxReducers.isIntegerNumber(numberClass)) {
            return JmxReducers.convert(numberClass, opLong.applyAsLong(list.stream().mapToLong(Number::longValue)));
        }
        throw new IllegalArgumentException("Unsupported objects of type: " + numberClass.getName());
    }

    private static boolean isFloatingPointNumber(Class<?> numberClass) {
        return Float.class.isAssignableFrom(numberClass) || Double.class.isAssignableFrom(numberClass);
    }

    private static boolean isIntegerNumber(Class<?> numberClass) {
        return Byte.class.isAssignableFrom(numberClass) || Short.class.isAssignableFrom(numberClass) || Integer.class.isAssignableFrom(numberClass) || Long.class.isAssignableFrom(numberClass);
    }

    private static Number convert(Class<?> targetClass, Number number) {
        if (Byte.class.isAssignableFrom(targetClass)) {
            return number.byteValue();
        }
        if (Short.class.isAssignableFrom(targetClass)) {
            return number.shortValue();
        }
        if (Integer.class.isAssignableFrom(targetClass)) {
            return number.intValue();
        }
        if (Long.class.isAssignableFrom(targetClass)) {
            return number.longValue();
        }
        if (Float.class.isAssignableFrom(targetClass)) {
            return Float.valueOf(number.floatValue());
        }
        if (Double.class.isAssignableFrom(targetClass)) {
            return number.doubleValue();
        }
        throw new IllegalArgumentException("target class is not a number class");
    }

    private static Duration sumDuration(List<Duration> list) {
        Duration initial = Duration.ZERO;
        for (Duration o : list) {
            initial = initial.plus(o);
        }
        return initial;
    }

    public static final class JmxReducerConcat
    implements JmxReducer<Object> {
        @Override
        @Nullable
        public List<String> reduce(List<?> list) {
            if ((list = list.stream().filter(Objects::nonNull).toList()).isEmpty()) {
                return null;
            }
            Class<?> attributeClass = list.get(0).getClass();
            if (Collection.class.isAssignableFrom(attributeClass)) {
                List<Object> l = list;
                return l.stream().flatMap(Collection::stream).map(Objects::toString).toList();
            }
            return list.stream().map(Objects::toString).toList();
        }
    }

    public static final class JmxReducerMax<C extends Comparable<C>>
    implements JmxReducer<C> {
        @Override
        @Nullable
        public C reduce(List<? extends C> list) {
            return (C)((Comparable)list.stream().filter(Objects::nonNull).max(Comparator.naturalOrder()).orElse(null));
        }
    }

    public static final class JmxReducerMin<C extends Comparable<C>>
    implements JmxReducer<C> {
        @Override
        @Nullable
        public C reduce(List<? extends C> list) {
            return (C)((Comparable)list.stream().filter(Objects::nonNull).min(Comparator.naturalOrder()).orElse(null));
        }
    }

    public static final class JmxReducerAvg
    implements JmxReducer<Object> {
        @Override
        @Nullable
        public Object reduce(List<?> list) {
            if ((list = list.stream().filter(Objects::nonNull).collect(Collectors.toList())).isEmpty()) {
                return null;
            }
            Class<?> attributeClass = list.get(0).getClass();
            if (Number.class.isAssignableFrom(attributeClass)) {
                return JmxReducers.reduceNumbers(list, d -> d.average().getAsDouble(), l -> (long)l.average().getAsDouble());
            }
            if (attributeClass == Duration.class) {
                return JmxReducers.sumDuration(list).dividedBy(list.size());
            }
            throw new IllegalStateException("Cannot sum values of type: " + attributeClass);
        }
    }

    public static final class JmxReducerSum
    implements JmxReducer<Object> {
        @Override
        @Nullable
        public Object reduce(List<?> list) {
            if ((list = list.stream().filter(Objects::nonNull).collect(Collectors.toList())).isEmpty()) {
                return null;
            }
            Class<?> attributeClass = list.get(0).getClass();
            if (Number.class.isAssignableFrom(attributeClass)) {
                return JmxReducers.reduceNumbers(list, DoubleStream::sum, LongStream::sum);
            }
            if (attributeClass == Duration.class) {
                return JmxReducers.sumDuration(list);
            }
            throw new IllegalStateException("Cannot sum values of type: " + attributeClass);
        }
    }

    public static final class JmxReducerDistinct
    implements JmxReducer<Object> {
        @Override
        public Object reduce(List<?> list) {
            if (list.isEmpty()) {
                return null;
            }
            Object firstValue = list.get(0);
            return list.stream().allMatch(value -> Objects.equals(firstValue, value)) ? firstValue : null;
        }
    }

    public static final class JmxReducerAny
    implements JmxReducer<Object> {
        @Override
        public Object reduce(List<?> list) {
            return list.stream().filter(Objects::nonNull).findAny().orElse(null);
        }
    }
}

