/*
 * Decompiled with CFR 0.152.
 */
package io.activej.jmx.stats;

import io.activej.common.ApplicationSettings;
import io.activej.common.Checks;
import io.activej.common.builder.AbstractBuilder;
import io.activej.jmx.api.attribute.JmxAttribute;
import io.activej.jmx.stats.EventStats;
import io.activej.jmx.stats.JmxHistogram;
import io.activej.jmx.stats.JmxRefreshableStats;
import io.activej.jmx.stats.JmxStats;
import io.activej.jmx.stats.JmxStatsWithReset;
import io.activej.jmx.stats.JmxStatsWithSmoothingWindow;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jetbrains.annotations.Nullable;

public final class ValueStats
implements JmxRefreshableStats<ValueStats>,
JmxStatsWithReset,
JmxStatsWithSmoothingWindow {
    private static final DecimalFormatSymbols DECIMAL_FORMAT_SYMBOLS = DecimalFormatSymbols.getInstance(Locale.US);
    private static final long MAX_INTERVAL_BETWEEN_REFRESHES = ApplicationSettings.getDuration(JmxStats.class, (String)"maxIntervalBetweenRefreshes", (Duration)Duration.ofHours(1L)).toMillis();
    private static final double LN_2 = Math.log(2.0);
    private static final String NEG_INF = "-\u221e";
    private static final String POS_INF = "+\u221e";
    private long lastTimestampMillis;
    private long lastValue;
    private long lastSum;
    private long lastSqr;
    private long lastCount;
    private long lastMin;
    private long lastMax;
    private long totalSum;
    private long totalCount;
    private double smoothedSum;
    private double smoothedSqr;
    private double smoothedCount;
    private double smoothedMin = Double.MAX_VALUE;
    private double smoothedMax = -1.7976931348623157E308;
    private long absoluteMax = Long.MAX_VALUE;
    private long absoluteMin = Long.MIN_VALUE;
    private double smoothedRateCount;
    private double smoothedRateTime;
    private double smoothingWindow;
    private double smoothingWindowCoef;
    @Nullable
    JmxHistogram histogram;
    private int addedStats;
    @Nullable
    private String unit;
    @Nullable
    private String rateUnit;
    private boolean useAvgAndDeviation = true;
    private boolean useMinMax = true;
    private boolean useLastValue = true;
    private boolean useAbsoluteValues;
    private int precision = 1000;

    private ValueStats(double smoothingWindow) {
        this.smoothingWindow = smoothingWindow;
        this.smoothingWindowCoef = ValueStats.calculateSmoothingWindowCoef(smoothingWindow);
        this.resetStats();
    }

    private ValueStats() {
        this.smoothingWindow = -1.0;
        this.smoothingWindowCoef = -1.0;
    }

    public static ValueStats createAccumulator() {
        return (ValueStats)ValueStats.accumulatorBuilder().build();
    }

    public static Builder accumulatorBuilder() {
        return new ValueStats().new Builder();
    }

    public static ValueStats create(Duration smoothingWindow) {
        return (ValueStats)ValueStats.builder(smoothingWindow).build();
    }

    public static Builder builder(Duration smoothingWindow) {
        return new ValueStats((double)smoothingWindow.toMillis() / 1000.0).new Builder();
    }

    public void setHistogram(@Nullable JmxHistogram histogram) {
        this.histogram = histogram;
    }

    public void setHistogram(long[] levels) {
        this.histogram = JmxHistogram.ofLevels(levels);
    }

    @Override
    public void resetStats() {
        this.smoothedSum = 0.0;
        this.smoothedSqr = 0.0;
        this.smoothedCount = 0.0;
        this.smoothedMin = Double.MAX_VALUE;
        this.smoothedMax = -1.7976931348623157E308;
        this.smoothedRateCount = 0.0;
        this.smoothedRateTime = 0.0;
        this.totalSum = 0L;
        this.totalCount = 0L;
        this.absoluteMin = Long.MAX_VALUE;
        this.absoluteMax = Long.MIN_VALUE;
        this.lastMax = Long.MIN_VALUE;
        this.lastMin = Long.MAX_VALUE;
        this.lastSum = 0L;
        this.lastSqr = 0L;
        this.lastCount = 0L;
        this.lastValue = 0L;
        this.lastTimestampMillis = 0L;
        if (this.histogram != null) {
            this.histogram.reset();
        }
    }

    public void recordValue(long value) {
        this.lastValue = value;
        if (value < this.lastMin) {
            this.lastMin = value;
        }
        if (value > this.lastMax) {
            this.lastMax = value;
        }
        this.lastSum += value;
        this.lastSqr += value * value;
        ++this.lastCount;
        if (this.histogram != null) {
            this.histogram.record(value);
        }
    }

    public void refresh(long timestamp) {
        long timeElapsedMillis;
        long lastMax;
        long lastMin;
        long lastCount;
        long lastSqr;
        long lastSum;
        if (this.lastCount > 0L) {
            lastSum = this.lastSum;
            lastSqr = this.lastSqr;
            lastCount = this.lastCount;
            lastMin = this.lastMin;
            lastMax = this.lastMax;
            this.lastSum = 0L;
            this.lastSqr = 0L;
            this.lastCount = 0L;
            this.lastMin = Long.MAX_VALUE;
            this.lastMax = Long.MIN_VALUE;
        } else {
            lastSum = 0L;
            lastSqr = 0L;
            lastCount = 0L;
            lastMin = Long.MAX_VALUE;
            lastMax = Long.MIN_VALUE;
        }
        long l = timeElapsedMillis = this.lastTimestampMillis == 0L ? 0L : timestamp - this.lastTimestampMillis;
        if (ValueStats.isTimePeriodValid(timeElapsedMillis)) {
            double timeElapsed = (double)timeElapsedMillis * 0.001;
            double smoothingFactor = Math.exp(timeElapsed * this.smoothingWindowCoef);
            if (lastCount != 0L) {
                this.smoothedSum = (double)lastSum + this.smoothedSum * smoothingFactor;
                this.smoothedSqr = (double)lastSqr + this.smoothedSqr * smoothingFactor;
                this.smoothedCount = (double)lastCount + this.smoothedCount * smoothingFactor;
                this.totalSum += lastSum;
                this.totalCount += lastCount;
                double smoothedAvg = this.smoothedSum / this.smoothedCount;
                this.smoothedMin = (double)lastMin < this.smoothedMin ? (double)lastMin : smoothedAvg + (this.smoothedMin - smoothedAvg) * smoothingFactor;
                this.smoothedMax = (double)lastMax > this.smoothedMax ? (double)lastMax : smoothedAvg + (this.smoothedMax - smoothedAvg) * smoothingFactor;
                this.absoluteMin = Long.min(this.absoluteMin, lastMin);
                this.absoluteMax = Long.max(this.absoluteMax, lastMax);
            }
            this.smoothedRateCount = (double)lastCount + this.smoothedRateCount * smoothingFactor;
            this.smoothedRateTime = timeElapsed + this.smoothedRateTime * smoothingFactor;
        }
        this.lastTimestampMillis = timestamp;
    }

    private static boolean isTimePeriodValid(long timePeriod) {
        return timePeriod < MAX_INTERVAL_BETWEEN_REFRESHES && timePeriod >= 0L;
    }

    @Override
    public void add(ValueStats anotherStats) {
        if (anotherStats.lastTimestampMillis == 0L) {
            return;
        }
        this.smoothedSum += anotherStats.smoothedSum;
        this.smoothedSqr += anotherStats.smoothedSqr;
        this.smoothedCount += anotherStats.smoothedCount;
        this.smoothedRateCount += anotherStats.smoothedRateCount;
        this.smoothedRateTime += anotherStats.smoothedRateTime;
        this.totalSum += anotherStats.totalSum;
        this.totalCount += anotherStats.totalCount;
        this.smoothedMin = Math.min(this.smoothedMin, anotherStats.smoothedMin);
        this.smoothedMax = Math.max(this.smoothedMax, anotherStats.smoothedMax);
        if (anotherStats.lastTimestampMillis > this.lastTimestampMillis) {
            this.lastTimestampMillis = anotherStats.lastTimestampMillis;
            this.lastValue = anotherStats.lastValue;
        }
        if (this.addedStats == 0) {
            this.smoothingWindow = anotherStats.smoothingWindow;
            this.smoothingWindowCoef = anotherStats.smoothingWindowCoef;
            this.unit = anotherStats.unit;
            this.rateUnit = anotherStats.rateUnit;
            this.useAvgAndDeviation = anotherStats.useAvgAndDeviation;
            this.useMinMax = anotherStats.useMinMax;
            this.useLastValue = anotherStats.useLastValue;
            this.useAbsoluteValues = anotherStats.useAbsoluteValues;
        } else {
            if (this.smoothingWindow != anotherStats.smoothingWindow) {
                this.smoothingWindow = -1.0;
                this.smoothingWindowCoef = ValueStats.calculateSmoothingWindowCoef(this.smoothingWindow);
            }
            if (!Objects.equals(this.unit, anotherStats.unit)) {
                this.unit = null;
            }
            if (!Objects.equals(this.rateUnit, anotherStats.rateUnit)) {
                this.rateUnit = null;
            }
            this.useAvgAndDeviation &= anotherStats.useAvgAndDeviation;
            this.useMinMax &= anotherStats.useMinMax;
            this.useLastValue &= anotherStats.useLastValue;
            this.useAbsoluteValues |= anotherStats.useAbsoluteValues;
            if (this.precision != anotherStats.precision) {
                this.precision = 1000;
            }
        }
        if (anotherStats.histogram != null) {
            if (this.histogram == null) {
                this.histogram = anotherStats.histogram.createAccumulator();
            }
            this.histogram.add(anotherStats.histogram);
        }
        ++this.addedStats;
    }

    private static double calculateSmoothingWindowCoef(double smoothingWindow) {
        return -(LN_2 / smoothingWindow);
    }

    @JmxAttribute(optional=true)
    public long getLastValue() {
        return this.lastValue;
    }

    @JmxAttribute(optional=true)
    public double getSmoothedAverage() {
        if (this.totalCount == 0L) {
            return 0.0;
        }
        return this.smoothedSum / this.smoothedCount;
    }

    @JmxAttribute(optional=true)
    public double getSmoothedStandardDeviation() {
        if (this.totalCount == 0L) {
            return 0.0;
        }
        double avg = this.smoothedSum / this.smoothedCount;
        double variance = this.smoothedSqr / this.smoothedCount - avg * avg;
        if (variance < 0.0) {
            variance = 0.0;
        }
        return Math.sqrt(variance);
    }

    @JmxAttribute(name="min", optional=true)
    public double getSmoothedMin() {
        return this.totalCount == 0L ? 0.0 : this.smoothedMin;
    }

    @JmxAttribute(name="max", optional=true)
    public double getSmoothedMax() {
        return this.totalCount == 0L ? 0.0 : this.smoothedMax;
    }

    @JmxAttribute(name="absoluteMin", optional=true)
    public long getAbsoluteMin() {
        return this.totalCount == 0L ? 0L : this.absoluteMin;
    }

    @JmxAttribute(name="absoluteMax", optional=true)
    public long getAbsoluteMax() {
        return this.totalCount == 0L ? 0L : this.absoluteMax;
    }

    @JmxAttribute(optional=true)
    public double getAverage() {
        return this.totalCount != 0L ? (double)this.totalSum / (double)this.totalCount : 0.0;
    }

    @JmxAttribute(optional=true)
    public double getSmoothedRate() {
        return this.totalCount != 0L ? this.smoothedRateCount / this.smoothedRateTime * (double)Math.max(1, this.addedStats) : 0.0;
    }

    @Override
    @JmxAttribute(optional=true)
    public Duration getSmoothingWindow() {
        return Duration.ofMillis((long)(this.smoothingWindow * 1000.0));
    }

    @Override
    @JmxAttribute(optional=true)
    public void setSmoothingWindow(Duration smoothingWindow) {
        this.smoothingWindow = (double)smoothingWindow.toMillis() / 1000.0;
        this.smoothingWindowCoef = ValueStats.calculateSmoothingWindowCoef(this.smoothingWindow);
    }

    @JmxAttribute(optional=true)
    public long getCount() {
        return this.totalCount + this.lastCount;
    }

    @JmxAttribute(optional=true)
    @Nullable
    public List<String> getHistogram() {
        if (this.histogram == null) {
            return null;
        }
        long[] levels = this.histogram.levels();
        long[] counts = this.histogram.counts();
        assert (counts.length == levels.length + 1);
        if (Arrays.stream(counts).noneMatch(value -> value != 0L)) {
            return null;
        }
        int left = IntStream.range(0, counts.length).filter(i -> i > 0 && levels[i - 1] == 0L || counts[i] != 0L).findFirst().getAsInt();
        int right = IntStream.iterate(levels.length, i -> i - 1).filter(i -> counts[i] != 0L).findFirst().getAsInt();
        int maxLevelStrLen = Math.max(Math.max(NEG_INF.length(), POS_INF.length()), IntStream.range(left, right).map(i -> Long.toString(levels[i]).length()).max().orElse(0));
        int maxValueStrLen = IntStream.rangeClosed(left, right).map(i -> Long.toString(counts[i]).length()).max().orElse(0);
        return IntStream.rangeClosed(left, right).mapToObj(i -> String.format("%c%" + maxLevelStrLen + "s, %" + maxLevelStrLen + "s%c  :  %" + maxValueStrLen + "s", Character.valueOf(i == 0 ? (char)'(' : (char)'['), i == 0 ? NEG_INF : Long.valueOf(levels[i - 1]), i == levels.length ? POS_INF : Long.valueOf(levels[i]), Character.valueOf(')'), counts[i])).collect(Collectors.toList());
    }

    @JmxAttribute
    public String get() {
        return this.toString();
    }

    public String toString() {
        DecimalFormat decimalFormat;
        if (this.totalCount == 0L) {
            return "";
        }
        double min = this.smoothedMin;
        double max = this.smoothedMax;
        if (this.useAbsoluteValues) {
            min = this.absoluteMin;
            max = this.absoluteMax;
        }
        if (this.precision == -1) {
            decimalFormat = new DecimalFormat("0.0####E0#", DECIMAL_FORMAT_SYMBOLS);
        } else {
            decimalFormat = new DecimalFormat("0", DECIMAL_FORMAT_SYMBOLS);
            decimalFormat.setMaximumFractionDigits((int)Math.ceil(Math.min(Math.max(-Math.log10((max - min) / (double)this.precision), 0.0), 6.0)));
        }
        StringBuilder constructorTemplate = new StringBuilder();
        if (this.useAvgAndDeviation) {
            constructorTemplate.append(decimalFormat.format(this.getSmoothedAverage())).append('\u00b1').append(decimalFormat.format(this.getSmoothedStandardDeviation())).append(' ');
            if (this.unit != null) {
                constructorTemplate.append(this.unit).append("  ");
            } else {
                constructorTemplate.append(' ');
            }
        }
        if (this.useMinMax) {
            constructorTemplate.append('[').append(decimalFormat.format(min)).append("...").append(decimalFormat.format(max)).append("]  ");
        }
        if (this.useLastValue) {
            constructorTemplate.append("last: ").append(decimalFormat.format(this.lastValue)).append("  ");
        }
        if (this.rateUnit != null) {
            constructorTemplate.append("calls: ").append(EventStats.format(this.totalCount, this.getSmoothedRate(), this.rateUnit, decimalFormat)).append("  ");
        }
        if (this.addedStats != 0) {
            constructorTemplate.append('[').append(this.addedStats).append(']');
        }
        return constructorTemplate.toString().trim();
    }

    public final class Builder
    extends AbstractBuilder<Builder, ValueStats> {
        private Builder() {
        }

        public Builder withUnit(String unit) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            ValueStats.this.unit = unit;
            return this;
        }

        public Builder withRate(String rateUnit) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            ValueStats.this.rateUnit = rateUnit;
            return this;
        }

        public Builder withRate() {
            Builder.checkNotBuilt((AbstractBuilder)this);
            ValueStats.this.rateUnit = "";
            return this;
        }

        public Builder withHistogram(JmxHistogram histogram) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            ValueStats.this.histogram = histogram;
            return this;
        }

        public Builder withHistogram(long[] histogram) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            ValueStats.this.setHistogram(histogram);
            return this;
        }

        public Builder withAbsoluteValues(boolean value) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            ValueStats.this.useAbsoluteValues = value;
            return this;
        }

        public Builder withAverageAndDeviation(boolean value) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            ValueStats.this.useAvgAndDeviation = value;
            return this;
        }

        public Builder withMinMax(boolean value) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            ValueStats.this.useMinMax = value;
            return this;
        }

        public Builder withLastValue(boolean value) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            ValueStats.this.useLastValue = value;
            return this;
        }

        public Builder withPrecision(int precision) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            Checks.checkArgument((precision > 0 ? 1 : 0) != 0, (Object)"Precision should be a positive value");
            ValueStats.this.precision = precision;
            return this;
        }

        public Builder withScientificNotation() {
            Builder.checkNotBuilt((AbstractBuilder)this);
            ValueStats.this.precision = -1;
            return this;
        }

        protected ValueStats doBuild() {
            return ValueStats.this;
        }
    }
}

