/*
 * Decompiled with CFR 0.152.
 */
package io.activej.jmx.stats;

import io.activej.common.collection.CollectionUtils;
import io.activej.common.reflection.ReflectionUtils;
import io.activej.jmx.api.attribute.JmxAttribute;
import io.activej.jmx.stats.JmxRefreshableStats;
import io.activej.jmx.stats.JmxStats;
import io.activej.jmx.stats.JmxStatsWithReset;
import io.activej.jmx.stats.JmxStatsWithSmoothingWindow;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;

public final class StatsUtils {
    private static final ThreadLocal<Set<Object>> VISITED = ThreadLocal.withInitial(HashSet::new);
    private static final ThreadLocal<Integer> RECURSION_LEVEL = ThreadLocal.withInitial(() -> 0);

    public static boolean isJmxStats(Class<?> cls) {
        return JmxStats.class.isAssignableFrom(cls);
    }

    public static boolean isJmxRefreshableStats(Class<?> cls) {
        return JmxRefreshableStats.class.isAssignableFrom(cls);
    }

    public static void resetStats(Object instance) {
        StatsUtils.visitFields(instance, item -> {
            if (item instanceof JmxStatsWithReset) {
                ((JmxStatsWithReset)item).resetStats();
                return true;
            }
            return false;
        });
    }

    public static void setSmoothingWindow(Object instance, Duration smoothingWindowSeconds) {
        StatsUtils.visitFields(instance, item -> {
            if (item instanceof JmxStatsWithSmoothingWindow) {
                ((JmxStatsWithSmoothingWindow)item).setSmoothingWindow(smoothingWindowSeconds);
                return true;
            }
            return false;
        });
    }

    @Nullable
    public static Duration getSmoothingWindow(Object instance) {
        HashSet result = new HashSet();
        StatsUtils.visitFields(instance, item -> {
            if (item instanceof JmxStatsWithSmoothingWindow) {
                Duration smoothingWindow = ((JmxStatsWithSmoothingWindow)item).getSmoothingWindow();
                result.add(smoothingWindow);
                return true;
            }
            return false;
        });
        if (result.size() == 1) {
            return (Duration)CollectionUtils.first(result);
        }
        return null;
    }

    private static void visitFields(Object instance, Predicate<Object> action) {
        RECURSION_LEVEL.set(RECURSION_LEVEL.get() + 1);
        try {
            StatsUtils.doVisitFields(instance, action);
        }
        finally {
            Integer oldRecursionLevel = RECURSION_LEVEL.get();
            RECURSION_LEVEL.set(oldRecursionLevel - 1);
            if (oldRecursionLevel == 1) {
                VISITED.get().clear();
            }
        }
    }

    private static void doVisitFields(Object instance, Predicate<Object> action) {
        if (instance == null) {
            return;
        }
        for (Method method : instance.getClass().getMethods()) {
            Object fieldValue;
            Class<?> returnType;
            if (method.getParameters().length != 0 || (returnType = method.getReturnType()) == Void.TYPE || ReflectionUtils.isSimpleType(returnType) || !method.isAnnotationPresent(JmxAttribute.class) || !VISITED.get().add(List.of(Integer.valueOf(System.identityHashCode(instance)), method))) continue;
            try {
                fieldValue = method.invoke(instance, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getCause());
            }
            if (fieldValue == null || action.test(fieldValue)) continue;
            if (Map.class.isAssignableFrom(returnType)) {
                for (Object item : ((Map)fieldValue).values()) {
                    StatsUtils.doVisitFields(item, action);
                }
                continue;
            }
            if (Collection.class.isAssignableFrom(returnType)) {
                for (Object item : (Collection)fieldValue) {
                    StatsUtils.doVisitFields(item, action);
                }
                continue;
            }
            StatsUtils.doVisitFields(fieldValue, action);
        }
    }
}

