/*
 * Decompiled with CFR 0.152.
 */
package io.activej.jmx.stats;

import io.activej.common.Checks;
import io.activej.jmx.stats.JmxHistogram;
import java.util.Arrays;

public final class JmxHistograms {
    private static final long[] TABLE_10 = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L};

    static int longLogBase10(long v) {
        int t;
        return t - (v < TABLE_10[t = (64 - Long.numberOfLeadingZeros(v)) * 1233 >>> 12] ? 1 : 0);
    }

    public static final class Custom
    extends AbstractJmxHistogram {
        public Custom(long[] levels) {
            super(levels);
        }

        @Override
        public JmxHistogram createAccumulator() {
            return new Custom(this.levels);
        }

        @Override
        public void record(long value) {
            int n = Math.abs(Arrays.binarySearch(this.levels, value) + 1);
            this.counters[n] = this.counters[n] + 1L;
        }

        @Override
        protected long getResult(int index) {
            return this.counters[index];
        }
    }

    public static final class Base10Linear
    extends AbstractJmxHistogram {
        public Base10Linear() {
            super(POWERS_OF_TEN_LINEAR);
        }

        @Override
        public JmxHistogram createAccumulator() {
            return new Base10Linear();
        }

        @Override
        public void record(long value) {
            if (value == 0L) {
                this.counters[1] = this.counters[1] + 1L;
            } else if (value > 0L) {
                int index = (64 - Long.numberOfLeadingZeros(value)) * 1233 >>> 12;
                long power = TABLE_10[index];
                if (value < power) {
                    power = TABLE_10[--index];
                }
                int subindex = (int)(value / power);
                int n = index * 9 + subindex + 1;
                this.counters[n] = this.counters[n] + 1L;
            } else {
                this.counters[0] = this.counters[0] + 1L;
            }
        }

        @Override
        protected long getResult(int index) {
            return this.counters[index];
        }
    }

    public static class Base10
    extends AbstractJmxHistogram {
        public Base10() {
            super(POWERS_OF_TEN);
        }

        @Override
        public JmxHistogram createAccumulator() {
            return new Base10();
        }

        @Override
        public void record(long value) {
            if (value >= 0L) {
                int n = JmxHistograms.longLogBase10(value) + 2;
                this.counters[n] = this.counters[n] + 1L;
            } else {
                this.counters[0] = this.counters[0] + 1L;
            }
        }

        @Override
        protected long getResult(int index) {
            return this.counters[index];
        }
    }

    public static final class Base2
    extends AbstractJmxHistogram {
        public Base2() {
            super(POWERS_OF_TWO);
        }

        @Override
        public JmxHistogram createAccumulator() {
            return new Base2();
        }

        @Override
        public void record(long value) {
            int n = 64 - Long.numberOfLeadingZeros(value);
            this.counters[n] = this.counters[n] + 1L;
        }

        @Override
        protected long getResult(int index) {
            return this.counters[(index + 65 - 1) % 65];
        }
    }

    public static abstract class AbstractJmxHistogram
    implements JmxHistogram {
        protected final long[] counters;
        protected final long[] levels;

        protected AbstractJmxHistogram(long[] levels) {
            this.counters = new long[levels.length + 1];
            this.levels = levels;
        }

        protected AbstractJmxHistogram(long[] levels, int counters) {
            this.counters = new long[counters];
            this.levels = levels;
        }

        @Override
        public long[] levels() {
            return this.levels;
        }

        @Override
        public long[] counts() {
            long[] result = new long[this.levels.length + 1];
            for (int i = 0; i <= this.levels.length; ++i) {
                result[i] = this.getResult(i);
            }
            return result;
        }

        protected abstract long getResult(int var1);

        @Override
        public void reset() {
            Arrays.fill(this.counters, 0L);
        }

        @Override
        public void add(JmxHistogram another) {
            AbstractJmxHistogram anotherImpl = (AbstractJmxHistogram)another;
            Checks.checkArgument((Arrays.equals(anotherImpl.levels, this.levels) && anotherImpl.counters.length == this.counters.length ? 1 : 0) != 0, (Object)"Histograms mismatch");
            for (int i = 0; i < this.counters.length; ++i) {
                int n = i;
                this.counters[n] = this.counters[n] + anotherImpl.counters[i];
            }
        }
    }
}

