/*
 * Decompiled with CFR 0.152.
 */
package io.activej.jmx.stats;

import io.activej.common.Checks;
import io.activej.jmx.stats.JmxHistograms;
import java.util.Arrays;

public interface JmxHistogram {
    public static final long[] POWERS_OF_TWO = new long[]{0L, 1L, 2L, 4L, 8L, 16L, 32L, 64L, 128L, 256L, 512L, 1024L, 2048L, 4096L, 8192L, 16384L, 32768L, 65536L, 131072L, 262144L, 524288L, 0x100000L, 0x200000L, 0x400000L, 0x800000L, 0x1000000L, 0x2000000L, 0x4000000L, 0x8000000L, 0x10000000L, 0x20000000L, 0x40000000L, 0x80000000L, 0x100000000L, 0x200000000L, 0x400000000L, 0x800000000L, 0x1000000000L, 0x2000000000L, 0x4000000000L, 0x8000000000L, 0x10000000000L, 0x20000000000L, 0x40000000000L, 0x80000000000L, 0x100000000000L, 0x200000000000L, 0x400000000000L, 0x800000000000L, 0x1000000000000L, 0x2000000000000L, 0x4000000000000L, 0x8000000000000L, 0x10000000000000L, 0x20000000000000L, 0x40000000000000L, 0x80000000000000L, 0x100000000000000L, 0x200000000000000L, 0x400000000000000L, 0x800000000000000L, 0x1000000000000000L, 0x2000000000000000L, 0x4000000000000000L};
    public static final long[] POWERS_OF_TEN = new long[]{0L, 1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L};
    public static final long[] POWERS_OF_TEN_LINEAR = new long[]{0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L, 20L, 30L, 40L, 50L, 60L, 70L, 80L, 90L, 100L, 200L, 300L, 400L, 500L, 600L, 700L, 800L, 900L, 1000L, 2000L, 3000L, 4000L, 5000L, 6000L, 7000L, 8000L, 9000L, 10000L, 20000L, 30000L, 40000L, 50000L, 60000L, 70000L, 80000L, 90000L, 100000L, 200000L, 300000L, 400000L, 500000L, 600000L, 700000L, 800000L, 900000L, 1000000L, 2000000L, 3000000L, 4000000L, 5000000L, 6000000L, 7000000L, 8000000L, 9000000L, 10000000L, 20000000L, 30000000L, 40000000L, 50000000L, 60000000L, 70000000L, 80000000L, 90000000L, 100000000L, 200000000L, 300000000L, 400000000L, 500000000L, 600000000L, 700000000L, 800000000L, 900000000L, 1000000000L, 2000000000L, 3000000000L, 4000000000L, 5000000000L, 6000000000L, 7000000000L, 8000000000L, 9000000000L, 10000000000L, 20000000000L, 30000000000L, 40000000000L, 50000000000L, 60000000000L, 70000000000L, 80000000000L, 90000000000L, 100000000000L, 200000000000L, 300000000000L, 400000000000L, 500000000000L, 600000000000L, 700000000000L, 800000000000L, 900000000000L, 1000000000000L, 2000000000000L, 3000000000000L, 4000000000000L, 5000000000000L, 6000000000000L, 7000000000000L, 8000000000000L, 9000000000000L, 10000000000000L, 20000000000000L, 30000000000000L, 40000000000000L, 50000000000000L, 60000000000000L, 70000000000000L, 80000000000000L, 90000000000000L, 100000000000000L, 200000000000000L, 300000000000000L, 400000000000000L, 500000000000000L, 600000000000000L, 700000000000000L, 800000000000000L, 900000000000000L, 1000000000000000L, 2000000000000000L, 3000000000000000L, 4000000000000000L, 5000000000000000L, 6000000000000000L, 7000000000000000L, 8000000000000000L, 9000000000000000L, 10000000000000000L, 20000000000000000L, 30000000000000000L, 40000000000000000L, 50000000000000000L, 60000000000000000L, 70000000000000000L, 80000000000000000L, 90000000000000000L, 100000000000000000L, 200000000000000000L, 300000000000000000L, 400000000000000000L, 500000000000000000L, 600000000000000000L, 700000000000000000L, 800000000000000000L, 900000000000000000L, 1000000000000000000L, 2000000000000000000L, 3000000000000000000L, 4000000000000000000L, 5000000000000000000L, 6000000000000000000L, 7000000000000000000L, 8000000000000000000L, 9000000000000000000L};

    public static JmxHistogram ofLevels(long[] levels) {
        Checks.checkArgument((levels.length > 0 ? 1 : 0) != 0, (Object)"levels amount must be at least 1");
        for (int i = 1; i < levels.length; ++i) {
            Checks.checkArgument((levels[i] > levels[i - 1] ? 1 : 0) != 0, (Object)"levels must be ascending");
        }
        if (Arrays.equals(POWERS_OF_TWO, levels)) {
            return new JmxHistograms.Base2();
        }
        if (Arrays.equals(POWERS_OF_TEN, levels)) {
            return new JmxHistograms.Base10();
        }
        if (Arrays.equals(POWERS_OF_TEN_LINEAR, levels)) {
            return new JmxHistograms.Base10Linear();
        }
        return new JmxHistograms.Custom(levels);
    }

    public long[] levels();

    public long[] counts();

    public void record(long var1);

    public void reset();

    public JmxHistogram createAccumulator();

    public void add(JmxHistogram var1);
}

