/*
 * Decompiled with CFR 0.152.
 */
package io.activej.inject.util;

import io.activej.inject.util.Utils;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;

public final class Trie<K, V> {
    private final V payload;
    private final Map<K, Trie<K, V>> children;

    public Trie(V payload, Map<K, Trie<K, V>> children) {
        this.payload = payload;
        this.children = children;
    }

    public static <K, V> Trie<K, V> leaf(V value) {
        return new Trie(value, new HashMap());
    }

    public static <K, V> Trie<K, V> of(V payload, Map<K, Trie<K, V>> children) {
        return new Trie<K, V>(payload, children);
    }

    public V get() {
        return this.payload;
    }

    public Map<K, Trie<K, V>> getChildren() {
        return this.children;
    }

    public Trie<K, V> get(K key) {
        return this.children.get(key);
    }

    public Trie<K, V> getOrDefault(K key, V defaultValue) {
        return this.children.getOrDefault(key, new Trie(defaultValue, Map.of()));
    }

    public Trie<K, V> computeIfAbsent(K key, Function<K, V> f) {
        return this.children.computeIfAbsent(key, (? super K k) -> Trie.leaf(f.apply(k)));
    }

    public Trie<K, V> get(K[] path) {
        Trie<K, V> subtree = this;
        for (K key : path) {
            if ((subtree = subtree.get(key)) != null) continue;
            return null;
        }
        return subtree;
    }

    public Trie<K, V> computeIfAbsent(K[] path, Function<K, V> f) {
        Trie<K, V> subtree = this;
        for (K key : path) {
            subtree = subtree.computeIfAbsent(key, f);
        }
        return subtree;
    }

    public void addAll(Trie<K, V> other, BiConsumer<V, V> merger) {
        Trie.mergeInto(this, other, merger);
    }

    public <E> Trie<K, E> map(Function<? super V, ? extends E> fn) {
        Trie<K, E> root = Trie.leaf(fn.apply(this.payload));
        this.children.forEach((k, sub) -> root.children.put(k, sub.map(fn)));
        return root;
    }

    public void dfs(K[] path, BiConsumer<K[], V> consumer) {
        Trie<K, V> sub = this.get(path);
        if (sub != null) {
            sub.dfsImpl(path, consumer);
        }
    }

    private void dfsImpl(K[] path, BiConsumer<K[], V> consumer) {
        this.children.forEach((key, child) -> child.dfsImpl(Utils.next(path, key), consumer));
        consumer.accept(path, this.payload);
    }

    public void dfs(Consumer<V> consumer) {
        this.children.forEach((key, child) -> child.dfs(consumer));
        consumer.accept(this.payload);
    }

    private static <K, V> void mergeInto(Trie<K, V> into, Trie<K, V> from, BiConsumer<V, V> merger) {
        if (into == from) {
            return;
        }
        merger.accept(into.get(), from.get());
        from.children.forEach((scope, child) -> Trie.mergeInto(into.children.computeIfAbsent(scope, (? super K $) -> child), child, merger));
    }

    public static <K, V> Trie<K, V> merge(BiConsumer<V, V> merger, V rootPayload, Trie<K, V> first, Trie<K, V> second) {
        Trie<K, V> combined = Trie.leaf(rootPayload);
        Trie.mergeInto(combined, first, merger);
        Trie.mergeInto(combined, second, merger);
        return combined;
    }

    @SafeVarargs
    public static <K, V> Trie<K, V> merge(BiConsumer<V, V> merger, V rootPayload, Trie<K, V> first, Trie<K, V> second, Trie<K, V> ... rest) {
        return Trie.merge(merger, rootPayload, Stream.concat(Stream.of(first, second), Arrays.stream(rest)));
    }

    public static <K, V> Trie<K, V> merge(BiConsumer<V, V> merger, V rootPayload, Collection<Trie<K, V>> bindings) {
        return Trie.merge(merger, rootPayload, bindings.stream());
    }

    public static <K, V> Trie<K, V> merge(BiConsumer<V, V> merger, V rootPayload, Stream<Trie<K, V>> bindings) {
        Trie combined = Trie.leaf(rootPayload);
        bindings.forEach(sb -> Trie.mergeInto(combined, sb, merger));
        return combined;
    }

    public String prettyPrint() {
        return this.prettyPrint(0);
    }

    private String prettyPrint(int indent) {
        String indentStr = new String(new char[indent]).replace('\u0000', '\t');
        StringBuilder sb = new StringBuilder().append("(").append(this.payload).append(") {");
        if (!this.children.isEmpty()) {
            sb.append("\n" + indentStr);
            this.children.forEach((key, child) -> sb.append(indentStr).append('\t').append(key).append(" -> ").append(child.prettyPrint(indent + 1)));
        }
        return sb.append("}\n").toString();
    }

    public String toString() {
        return "{" + this.payload + ", " + this.children + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Trie trie = (Trie)o;
        return Objects.equals(this.payload, trie.payload) && this.children.equals(trie.children);
    }

    public int hashCode() {
        int result = this.payload != null ? this.payload.hashCode() : 0;
        result = 31 * result + this.children.hashCode();
        return result;
    }
}

