/*
 * Decompiled with CFR 0.152.
 */
package io.activej.inject.module;

import io.activej.common.Checks;
import io.activej.common.collection.CollectionUtils;
import io.activej.inject.Key;
import io.activej.inject.Qualifiers;
import io.activej.inject.Scope;
import io.activej.inject.binding.Binding;
import io.activej.inject.impl.CompiledBinding;
import io.activej.inject.impl.CompiledBindingLocator;
import io.activej.inject.module.Module;
import io.activej.inject.module.SimpleModule;
import io.activej.inject.util.Trie;
import io.activej.inject.util.Utils;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class Modules {
    static final Module EMPTY = new SimpleModule(Trie.leaf(Map.of()), Map.of(), Map.of(), Map.of());

    public static Module combine(Collection<Module> modules) {
        if (modules.size() == 1) {
            return modules.iterator().next();
        }
        Trie<Scope, Map<Key<?>, Set<Binding<?>>>> bindings = Trie.merge(Utils.bindingMultimapMerger(), new HashMap(), modules.stream().map(Module::getBindings));
        HashMap bindingGenerators = new HashMap();
        HashMap bindingTransformers = new HashMap();
        HashMap multibinders = new HashMap();
        for (Module module : modules) {
            Utils.combineMultimap(bindingTransformers, module.getBindingTransformers());
            Utils.combineMultimap(bindingGenerators, module.getBindingGenerators());
            Utils.mergeMultibinders(multibinders, module.getMultibinders());
        }
        return new SimpleModule(bindings, bindingTransformers, bindingGenerators, multibinders);
    }

    public static Module combine(Module ... modules) {
        return modules.length == 0 ? Module.empty() : (modules.length == 1 ? modules[0] : Modules.combine(List.of(modules)));
    }

    public static Module override(List<Module> modules) {
        return modules.stream().reduce(Module.empty(), Modules::override);
    }

    public static Module override(Module ... modules) {
        return Modules.override(List.of(modules));
    }

    public static Module override(Module into, Module replacements) {
        Trie<Scope, Map<Key<?>, Set<Binding<?>>>> bindings = Trie.merge(Map::putAll, new HashMap(), into.getBindings(), replacements.getBindings());
        HashMap bindingGenerators = new HashMap(into.getBindingGenerators());
        bindingGenerators.putAll(replacements.getBindingGenerators());
        HashMap bindingTransformers = new HashMap(into.getBindingTransformers());
        bindingTransformers.putAll(replacements.getBindingTransformers());
        HashMap multibinders = new HashMap(into.getMultibinders());
        multibinders.putAll(replacements.getMultibinders());
        return new SimpleModule(bindings, bindingTransformers, bindingGenerators, multibinders);
    }

    public static Module ignoreScopes(Module from) {
        HashMap bindings = new HashMap();
        HashMap scopes = new HashMap();
        from.getBindings().dfs((Scope[])Scope.UNSCOPED, (scope, localBindings) -> localBindings.forEach((k, b) -> {
            bindings.merge(k, b, ($, $2) -> {
                Scope[] alreadyThere = (Scope[])scopes.get(k);
                String where = alreadyThere.length == 0 ? "in root" : "in scope " + Utils.getScopeDisplayString(alreadyThere);
                throw new IllegalStateException("Duplicate key " + k + ", already defined " + where + " and in scope " + Utils.getScopeDisplayString(scope));
            });
            scopes.put(k, scope);
        }));
        return new SimpleModule(Trie.leaf(bindings), from.getBindingTransformers(), from.getBindingGenerators(), from.getMultibinders());
    }

    public static Trie<Scope, Set<Key<?>>> getImports(Trie<Scope, Map<Key<?>, Set<Binding<?>>>> trie) {
        return Modules.getImports(trie, Set.of());
    }

    private static Trie<Scope, Set<Key<?>>> getImports(Trie<Scope, Map<Key<?>, Set<Binding<?>>>> trie, Set<Key<?>> upperExports) {
        Set exports = CollectionUtils.union(upperExports, trie.get().keySet());
        Set imports = trie.get().values().stream().flatMap(bindings -> bindings.stream().flatMap(binding -> binding.getDependencies().stream())).collect(Collectors.toCollection(HashSet::new));
        imports.removeAll(exports);
        HashMap subMap = new HashMap();
        trie.getChildren().forEach((key, subtrie) -> subMap.put(key, Modules.getImports(subtrie, exports)));
        return Trie.of(imports, subMap);
    }

    public static Module remap(Module module, Map<Key<?>, Key<?>> remapping) {
        HashMap remappingInverted = new HashMap(remapping.size());
        remapping.forEach((key1, key2) -> remappingInverted.put(key2, key1));
        Checks.checkArgument((remappingInverted.size() == remapping.size() ? 1 : 0) != 0, (Object)"Duplicate keys");
        return Modules.remap(module, key -> remappingInverted.getOrDefault(key, key));
    }

    public static Module remap(Module module, UnaryOperator<Key<?>> remapping) {
        return Modules.remap(module, (path, key) -> (Key)remapping.apply((Key<?>)key), (path, key) -> (Key)remapping.apply((Key<?>)key));
    }

    public static Module remap(Module module, BiFunction<Scope[], Key<?>, Key<?>> exportsMapping, BiFunction<Scope[], Key<?>, Key<?>> importsMapping) {
        return new SimpleModule(Modules.remap(exportsMapping, importsMapping, Scope.UNSCOPED, module.getBindings(), Map.of()), module.getBindingTransformers(), module.getBindingGenerators(), module.getMultibinders());
    }

    public static Module restrict(Module module, Key<?> ... exports) {
        return Modules.restrict(module, Set.of(exports));
    }

    public static Module restrict(Module module, Set<Key<?>> exports) {
        return Modules.restrict(module, exports::contains);
    }

    public static Module restrict(Module module, Predicate<Key<?>> exportsPredicate) {
        return Modules.restrict(module, (Scope[] scopes, Key<?> key) -> exportsPredicate.test((Key<?>)key));
    }

    public static Module restrict(Module module, BiPredicate<Scope[], Key<?>> exportsPredicate) {
        return new SimpleModule(Modules.restrict(exportsPredicate, module.getBindings()), module.getBindingTransformers(), module.getBindingGenerators(), module.getMultibinders());
    }

    private static Trie<Scope, Map<Key<?>, Set<Binding<?>>>> restrict(BiPredicate<Scope[], Key<?>> exportsPredicate, Trie<Scope, Map<Key<?>, Set<Binding<?>>>> trie) {
        HashMap exportsMappings = new HashMap();
        BiFunction<Scope[], Key<?>, Key<?>> remapping = (path, key) -> {
            if (exportsPredicate.test((Scope[])path, (Key<?>)key)) {
                return key;
            }
            Map mapping = exportsMappings.computeIfAbsent(List.of(path), $ -> new HashMap());
            Key result = (Key)mapping.get(key);
            if (result == null) {
                result = Key.ofType(key.getType(), Qualifiers.uniqueQualifier(key.getQualifier()));
                mapping.put(key, result);
            }
            return result;
        };
        return Modules.remap(remapping, (path, key) -> key, Scope.UNSCOPED, trie, Map.of());
    }

    private static Trie<Scope, Map<Key<?>, Set<Binding<?>>>> remap(final BiFunction<Scope[], Key<?>, Key<?>> exportsMapping, final BiFunction<Scope[], Key<?>, Key<?>> importsMapping, final Scope[] path, Trie<Scope, Map<Key<?>, Set<Binding<?>>>> oldBindingsTrie, Map<Key<?>, Scope[]> upperBindings) {
        Map<Key<?>, Set<Binding<?>>> oldBindingsMap = oldBindingsTrie.get();
        HashMap newBindingsMap = new HashMap();
        final HashMap bindings = new HashMap(upperBindings);
        oldBindingsMap.keySet().forEach(key -> bindings.put((Key<?>)key, path));
        for (Map.Entry<Key<?>, Set<Binding<?>>> entry : oldBindingsMap.entrySet()) {
            HashSet<1> newBindings;
            Key<?> oldExportKey = entry.getKey();
            Key<?> newExportKey = exportsMapping.apply(path, oldExportKey);
            if (newBindingsMap.put(newExportKey, newBindings = new HashSet<1>()) != null) {
                throw new IllegalArgumentException("Duplicate remapping: " + oldExportKey + " -> " + newExportKey);
            }
            boolean changed = false;
            for (final Binding<Object> binding : entry.getValue()) {
                Set<Key<?>> oldDependencies = binding.getDependencies();
                HashSet newDependencies = new HashSet(oldDependencies.size());
                for (Key<?> oldDependency : oldDependencies) {
                    Scope[] importKeyPath = (Scope[])bindings.get(oldDependency);
                    Key<?> newImportKey = importKeyPath != null ? exportsMapping.apply(importKeyPath, oldDependency) : importsMapping.apply(path, oldDependency);
                    changed |= !oldDependency.equals(newImportKey);
                    newDependencies.add(newImportKey);
                }
                Binding<Object> newBinding = changed ? new Binding<Object>(newDependencies){

                    @Override
                    public CompiledBinding<Object> compile(final CompiledBindingLocator compiledBindings, boolean threadsafe, int scope, @Nullable Integer slot) {
                        return binding.compile(new CompiledBindingLocator(){

                            @Override
                            public <Q> CompiledBinding<Q> get(Key<Q> oldImportKey) {
                                Scope[] importKeyPath = (Scope[])bindings.get(oldImportKey);
                                Key newImportKey = importKeyPath != null ? (Key)exportsMapping.apply(importKeyPath, oldImportKey) : (Key)importsMapping.apply(path, oldImportKey);
                                return compiledBindings.get(newImportKey);
                            }
                        }, threadsafe, scope, slot);
                    }
                } : binding;
                newBindings.add(newBinding);
            }
        }
        HashMap newChildren = new HashMap();
        oldBindingsTrie.getChildren().forEach((key, subtrie) -> newChildren.put(key, Modules.remap(exportsMapping, importsMapping, Utils.next(path, key), subtrie, bindings)));
        return Trie.of(newBindingsMap, newChildren);
    }
}

