/*
 * Decompiled with CFR 0.152.
 */
package io.activej.inject.module;

import io.activej.inject.Key;
import io.activej.inject.KeyPattern;
import io.activej.inject.Qualifiers;
import io.activej.inject.Scope;
import io.activej.inject.binding.Binding;
import io.activej.inject.binding.BindingGenerator;
import io.activej.inject.binding.BindingTransformer;
import io.activej.inject.binding.Multibinder;
import io.activej.inject.module.Modules;
import io.activej.inject.module.SimpleModule;
import io.activej.inject.util.Trie;
import java.util.Map;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;

public interface Module {
    public Trie<Scope, Map<Key<?>, Set<Binding<?>>>> getBindings();

    default public Trie<Scope, Set<Key<?>>> getExports() {
        return this.getBindings().map(map -> map.keySet().stream().filter(key -> !Qualifiers.isUnique(key.getQualifier())).collect(Collectors.toSet()));
    }

    default public Trie<Scope, Set<Key<?>>> getImports() {
        return Modules.getImports(this.getBindings());
    }

    public Map<KeyPattern<?>, Set<BindingGenerator<?>>> getBindingGenerators();

    public Map<KeyPattern<?>, Set<BindingTransformer<?>>> getBindingTransformers();

    public Map<Key<?>, Multibinder<?>> getMultibinders();

    default public Module combineWith(Module another) {
        return Modules.combine(this, another);
    }

    default public Module overrideWith(Module another) {
        return Modules.override(this, another);
    }

    default public Module transformWith(UnaryOperator<Module> fn) {
        return (Module)fn.apply(this);
    }

    public static Module empty() {
        return Modules.EMPTY;
    }

    public static Module of(Trie<Scope, Map<Key<?>, Set<Binding<?>>>> bindings) {
        return new SimpleModule(bindings, Map.of(), Map.of(), Map.of());
    }

    public static Module of(Trie<Scope, Map<Key<?>, Set<Binding<?>>>> bindings, Map<KeyPattern<?>, Set<BindingTransformer<?>>> transformers, Map<KeyPattern<?>, Set<BindingGenerator<?>>> generators, Map<Key<?>, Multibinder<?>> multibinders) {
        return new SimpleModule(bindings, transformers, generators, multibinders);
    }
}

